/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowTypeConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings of a workflow type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowTypeConfiguration implements StructuredPojo,
        ToCopyableBuilder<WorkflowTypeConfiguration.Builder, WorkflowTypeConfiguration> {
    private final String defaultTaskStartToCloseTimeout;

    private final String defaultExecutionStartToCloseTimeout;

    private final TaskList defaultTaskList;

    private final String defaultTaskPriority;

    private final String defaultChildPolicy;

    private final String defaultLambdaRole;

    private WorkflowTypeConfiguration(BuilderImpl builder) {
        this.defaultTaskStartToCloseTimeout = builder.defaultTaskStartToCloseTimeout;
        this.defaultExecutionStartToCloseTimeout = builder.defaultExecutionStartToCloseTimeout;
        this.defaultTaskList = builder.defaultTaskList;
        this.defaultTaskPriority = builder.defaultTaskPriority;
        this.defaultChildPolicy = builder.defaultChildPolicy;
        this.defaultLambdaRole = builder.defaultLambdaRole;
    }

    /**
     * <p>
     * <i>Optional.</i> The default maximum duration, specified when registering the workflow type, that a decision task
     * for executions of this workflow type might take before returning completion or failure. If the task does not
     * close in the specified time then the task is automatically timed out and rescheduled. If the decider eventually
     * reports a completion or failure, it is ignored. This default can be overridden when starting a workflow execution
     * using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return Optional.</i> The default maximum duration, specified when registering the workflow type, that a decision
     *         task for executions of this workflow type might take before returning completion or failure. If the task
     *         does not close in the specified time then the task is automatically timed out and rescheduled. If the
     *         decider eventually reports a completion or failure, it is ignored. This default can be overridden when
     *         starting a workflow execution using the <a>StartWorkflowExecution</a> action or the
     *         <code>StartChildWorkflowExecution</code> decision.</p>
     */
    public String defaultTaskStartToCloseTimeout() {
        return defaultTaskStartToCloseTimeout;
    }

    /**
     * <p>
     * <i>Optional.</i> The default maximum duration, specified when registering the workflow type, for executions of
     * this workflow type. This default can be overridden when starting a workflow execution using the
     * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return Optional.</i> The default maximum duration, specified when registering the workflow type, for executions
     *         of this workflow type. This default can be overridden when starting a workflow execution using the
     *         <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.</p>
     */
    public String defaultExecutionStartToCloseTimeout() {
        return defaultExecutionStartToCloseTimeout;
    }

    /**
     * <p>
     * <i>Optional.</i> The default task list, specified when registering the workflow type, for decisions tasks
     * scheduled for workflow executions of this type. This default can be overridden when starting a workflow execution
     * using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
     * </p>
     * 
     * @return Optional.</i> The default task list, specified when registering the workflow type, for decisions tasks
     *         scheduled for workflow executions of this type. This default can be overridden when starting a workflow
     *         execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution
     */
    public TaskList defaultTaskList() {
        return defaultTaskList;
    }

    /**
     * <p>
     * <i>Optional.</i> The default task priority, specified when registering the workflow type, for all decision tasks
     * of this workflow type. This default can be overridden when starting a workflow execution using the
     * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
     * </p>
     * <p>
     * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     * </p>
     * 
     * @return Optional.</i> The default task priority, specified when registering the workflow type, for all decision
     *         tasks of this workflow type. This default can be overridden when starting a workflow execution using the
     *         <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.</p>
     *         <p>
     *         Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     *         </p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon Simple Workflow Developer Guide
     */
    public String defaultTaskPriority() {
        return defaultTaskPriority;
    }

    /**
     * <p>
     * <i>Optional.</i> The default policy to use for the child workflow executions when a workflow execution of this
     * type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
     * timeout. This default can be overridden when starting a workflow execution using the
     * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.</li>
     * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * </ul>
     * 
     * @return Optional.</i> The default policy to use for the child workflow executions when a workflow execution of
     *         this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an
     *         expired timeout. This default can be overridden when starting a workflow execution using the
     *         <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     *         <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.</li>
     *         <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.
     * @see ChildPolicy
     */
    public String defaultChildPolicy() {
        return defaultChildPolicy;
    }

    /**
     * <p>
     * The default IAM role to use when a workflow execution invokes a AWS Lambda function.
     * </p>
     * 
     * @return The default IAM role to use when a workflow execution invokes a AWS Lambda function.
     */
    public String defaultLambdaRole() {
        return defaultLambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((defaultTaskStartToCloseTimeout() == null) ? 0 : defaultTaskStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode
                + ((defaultExecutionStartToCloseTimeout() == null) ? 0 : defaultExecutionStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((defaultTaskList() == null) ? 0 : defaultTaskList().hashCode());
        hashCode = 31 * hashCode + ((defaultTaskPriority() == null) ? 0 : defaultTaskPriority().hashCode());
        hashCode = 31 * hashCode + ((defaultChildPolicy() == null) ? 0 : defaultChildPolicy().hashCode());
        hashCode = 31 * hashCode + ((defaultLambdaRole() == null) ? 0 : defaultLambdaRole().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowTypeConfiguration)) {
            return false;
        }
        WorkflowTypeConfiguration other = (WorkflowTypeConfiguration) obj;
        if (other.defaultTaskStartToCloseTimeout() == null ^ this.defaultTaskStartToCloseTimeout() == null) {
            return false;
        }
        if (other.defaultTaskStartToCloseTimeout() != null
                && !other.defaultTaskStartToCloseTimeout().equals(this.defaultTaskStartToCloseTimeout())) {
            return false;
        }
        if (other.defaultExecutionStartToCloseTimeout() == null ^ this.defaultExecutionStartToCloseTimeout() == null) {
            return false;
        }
        if (other.defaultExecutionStartToCloseTimeout() != null
                && !other.defaultExecutionStartToCloseTimeout().equals(this.defaultExecutionStartToCloseTimeout())) {
            return false;
        }
        if (other.defaultTaskList() == null ^ this.defaultTaskList() == null) {
            return false;
        }
        if (other.defaultTaskList() != null && !other.defaultTaskList().equals(this.defaultTaskList())) {
            return false;
        }
        if (other.defaultTaskPriority() == null ^ this.defaultTaskPriority() == null) {
            return false;
        }
        if (other.defaultTaskPriority() != null && !other.defaultTaskPriority().equals(this.defaultTaskPriority())) {
            return false;
        }
        if (other.defaultChildPolicy() == null ^ this.defaultChildPolicy() == null) {
            return false;
        }
        if (other.defaultChildPolicy() != null && !other.defaultChildPolicy().equals(this.defaultChildPolicy())) {
            return false;
        }
        if (other.defaultLambdaRole() == null ^ this.defaultLambdaRole() == null) {
            return false;
        }
        if (other.defaultLambdaRole() != null && !other.defaultLambdaRole().equals(this.defaultLambdaRole())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (defaultTaskStartToCloseTimeout() != null) {
            sb.append("DefaultTaskStartToCloseTimeout: ").append(defaultTaskStartToCloseTimeout()).append(",");
        }
        if (defaultExecutionStartToCloseTimeout() != null) {
            sb.append("DefaultExecutionStartToCloseTimeout: ").append(defaultExecutionStartToCloseTimeout()).append(",");
        }
        if (defaultTaskList() != null) {
            sb.append("DefaultTaskList: ").append(defaultTaskList()).append(",");
        }
        if (defaultTaskPriority() != null) {
            sb.append("DefaultTaskPriority: ").append(defaultTaskPriority()).append(",");
        }
        if (defaultChildPolicy() != null) {
            sb.append("DefaultChildPolicy: ").append(defaultChildPolicy()).append(",");
        }
        if (defaultLambdaRole() != null) {
            sb.append("DefaultLambdaRole: ").append(defaultLambdaRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowTypeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowTypeConfiguration> {
        /**
         * <p>
         * <i>Optional.</i> The default maximum duration, specified when registering the workflow type, that a decision
         * task for executions of this workflow type might take before returning completion or failure. If the task does
         * not close in the specified time then the task is automatically timed out and rescheduled. If the decider
         * eventually reports a completion or failure, it is ignored. This default can be overridden when starting a
         * workflow execution using the <a>StartWorkflowExecution</a> action or the
         * <code>StartChildWorkflowExecution</code> decision.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskStartToCloseTimeout
         *        Optional.</i> The default maximum duration, specified when registering the workflow type, that a
         *        decision task for executions of this workflow type might take before returning completion or failure.
         *        If the task does not close in the specified time then the task is automatically timed out and
         *        rescheduled. If the decider eventually reports a completion or failure, it is ignored. This default
         *        can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or
         *        the <code>StartChildWorkflowExecution</code> decision.</p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout);

        /**
         * <p>
         * <i>Optional.</i> The default maximum duration, specified when registering the workflow type, for executions
         * of this workflow type. This default can be overridden when starting a workflow execution using the
         * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param defaultExecutionStartToCloseTimeout
         *        Optional.</i> The default maximum duration, specified when registering the workflow type, for
         *        executions of this workflow type. This default can be overridden when starting a workflow execution
         *        using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
         *        decision.</p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout);

        /**
         * <p>
         * <i>Optional.</i> The default task list, specified when registering the workflow type, for decisions tasks
         * scheduled for workflow executions of this type. This default can be overridden when starting a workflow
         * execution using the <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code>
         * decision.
         * </p>
         * 
         * @param defaultTaskList
         *        Optional.</i> The default task list, specified when registering the workflow type, for decisions tasks
         *        scheduled for workflow executions of this type. This default can be overridden when starting a
         *        workflow execution using the <a>StartWorkflowExecution</a> action or the
         *        <code>StartChildWorkflowExecution
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskList(TaskList defaultTaskList);

        /**
         * <p>
         * <i>Optional.</i> The default task priority, specified when registering the workflow type, for all decision
         * tasks of this workflow type. This default can be overridden when starting a workflow execution using the
         * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
         * </p>
         * <p>
         * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * </p>
         * 
         * @param defaultTaskPriority
         *        Optional.</i> The default task priority, specified when registering the workflow type, for all
         *        decision tasks of this workflow type. This default can be overridden when starting a workflow
         *        execution using the <a>StartWorkflowExecution</a> action or the
         *        <code>StartChildWorkflowExecution</code> decision.</p>
         *        <p>
         *        Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         *        <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         *        </p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon Simple Workflow Developer Guide
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskPriority(String defaultTaskPriority);

        /**
         * <p>
         * <i>Optional.</i> The default policy to use for the child workflow executions when a workflow execution of
         * this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an
         * expired timeout. This default can be overridden when starting a workflow execution using the
         * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * 
         * @param defaultChildPolicy
         *        Optional.</i> The default policy to use for the child workflow executions when a workflow execution of
         *        this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to
         *        an expired timeout. This default can be overridden when starting a workflow execution using the
         *        <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder defaultChildPolicy(String defaultChildPolicy);

        /**
         * <p>
         * <i>Optional.</i> The default policy to use for the child workflow executions when a workflow execution of
         * this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an
         * expired timeout. This default can be overridden when starting a workflow execution using the
         * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * 
         * @param defaultChildPolicy
         *        Optional.</i> The default policy to use for the child workflow executions when a workflow execution of
         *        this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to
         *        an expired timeout. This default can be overridden when starting a workflow execution using the
         *        <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> decision.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder defaultChildPolicy(ChildPolicy defaultChildPolicy);

        /**
         * <p>
         * The default IAM role to use when a workflow execution invokes a AWS Lambda function.
         * </p>
         * 
         * @param defaultLambdaRole
         *        The default IAM role to use when a workflow execution invokes a AWS Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultLambdaRole(String defaultLambdaRole);
    }

    private static final class BuilderImpl implements Builder {
        private String defaultTaskStartToCloseTimeout;

        private String defaultExecutionStartToCloseTimeout;

        private TaskList defaultTaskList;

        private String defaultTaskPriority;

        private String defaultChildPolicy;

        private String defaultLambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowTypeConfiguration model) {
            setDefaultTaskStartToCloseTimeout(model.defaultTaskStartToCloseTimeout);
            setDefaultExecutionStartToCloseTimeout(model.defaultExecutionStartToCloseTimeout);
            setDefaultTaskList(model.defaultTaskList);
            setDefaultTaskPriority(model.defaultTaskPriority);
            setDefaultChildPolicy(model.defaultChildPolicy);
            setDefaultLambdaRole(model.defaultLambdaRole);
        }

        public final String getDefaultTaskStartToCloseTimeout() {
            return defaultTaskStartToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
            return this;
        }

        public final void setDefaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
        }

        public final String getDefaultExecutionStartToCloseTimeout() {
            return defaultExecutionStartToCloseTimeout;
        }

        @Override
        public final Builder defaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout) {
            this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
            return this;
        }

        public final void setDefaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout) {
            this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
        }

        public final TaskList getDefaultTaskList() {
            return defaultTaskList;
        }

        @Override
        public final Builder defaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
            return this;
        }

        public final void setDefaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
        }

        public final String getDefaultTaskPriority() {
            return defaultTaskPriority;
        }

        @Override
        public final Builder defaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
            return this;
        }

        public final void setDefaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
        }

        public final String getDefaultChildPolicy() {
            return defaultChildPolicy;
        }

        @Override
        public final Builder defaultChildPolicy(String defaultChildPolicy) {
            this.defaultChildPolicy = defaultChildPolicy;
            return this;
        }

        @Override
        public final Builder defaultChildPolicy(ChildPolicy defaultChildPolicy) {
            this.defaultChildPolicy(defaultChildPolicy.toString());
            return this;
        }

        public final void setDefaultChildPolicy(String defaultChildPolicy) {
            this.defaultChildPolicy = defaultChildPolicy;
        }

        public final void setDefaultChildPolicy(ChildPolicy defaultChildPolicy) {
            this.defaultChildPolicy(defaultChildPolicy.toString());
        }

        public final String getDefaultLambdaRole() {
            return defaultLambdaRole;
        }

        @Override
        public final Builder defaultLambdaRole(String defaultLambdaRole) {
            this.defaultLambdaRole = defaultLambdaRole;
            return this;
        }

        public final void setDefaultLambdaRole(String defaultLambdaRole) {
            this.defaultLambdaRole = defaultLambdaRole;
        }

        @Override
        public WorkflowTypeConfiguration build() {
            return new WorkflowTypeConfiguration(this);
        }
    }
}
