/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.swf.transform.WorkflowTypeInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a workflow type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowTypeInfo implements StructuredPojo, ToCopyableBuilder<WorkflowTypeInfo.Builder, WorkflowTypeInfo> {
    private final WorkflowType workflowType;

    private final String status;

    private final String description;

    private final Date creationDate;

    private final Date deprecationDate;

    private WorkflowTypeInfo(BuilderImpl builder) {
        this.workflowType = builder.workflowType;
        this.status = builder.status;
        this.description = builder.description;
        this.creationDate = builder.creationDate;
        this.deprecationDate = builder.deprecationDate;
    }

    /**
     * <p>
     * The workflow type this information is about.
     * </p>
     * 
     * @return The workflow type this information is about.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * <p>
     * The current status of the workflow type.
     * </p>
     * 
     * @return The current status of the workflow type.
     * @see RegistrationStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The description of the type registered through <a>RegisterWorkflowType</a>.
     * </p>
     * 
     * @return The description of the type registered through <a>RegisterWorkflowType</a>.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The date when this type was registered.
     * </p>
     * 
     * @return The date when this type was registered.
     */
    public Date creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * If the type is in deprecated state, then it is set to the date when the type was deprecated.
     * </p>
     * 
     * @return If the type is in deprecated state, then it is set to the date when the type was deprecated.
     */
    public Date deprecationDate() {
        return deprecationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((workflowType() == null) ? 0 : workflowType().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        hashCode = 31 * hashCode + ((deprecationDate() == null) ? 0 : deprecationDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowTypeInfo)) {
            return false;
        }
        WorkflowTypeInfo other = (WorkflowTypeInfo) obj;
        if (other.workflowType() == null ^ this.workflowType() == null) {
            return false;
        }
        if (other.workflowType() != null && !other.workflowType().equals(this.workflowType())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.deprecationDate() == null ^ this.deprecationDate() == null) {
            return false;
        }
        if (other.deprecationDate() != null && !other.deprecationDate().equals(this.deprecationDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (workflowType() != null) {
            sb.append("WorkflowType: ").append(workflowType()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (deprecationDate() != null) {
            sb.append("DeprecationDate: ").append(deprecationDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowTypeInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowTypeInfo> {
        /**
         * <p>
         * The workflow type this information is about.
         * </p>
         * 
         * @param workflowType
         *        The workflow type this information is about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The current status of the workflow type.
         * </p>
         * 
         * @param status
         *        The current status of the workflow type.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the workflow type.
         * </p>
         * 
         * @param status
         *        The current status of the workflow type.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder status(RegistrationStatus status);

        /**
         * <p>
         * The description of the type registered through <a>RegisterWorkflowType</a>.
         * </p>
         * 
         * @param description
         *        The description of the type registered through <a>RegisterWorkflowType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date when this type was registered.
         * </p>
         * 
         * @param creationDate
         *        The date when this type was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Date creationDate);

        /**
         * <p>
         * If the type is in deprecated state, then it is set to the date when the type was deprecated.
         * </p>
         * 
         * @param deprecationDate
         *        If the type is in deprecated state, then it is set to the date when the type was deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationDate(Date deprecationDate);
    }

    private static final class BuilderImpl implements Builder {
        private WorkflowType workflowType;

        private String status;

        private String description;

        private Date creationDate;

        private Date deprecationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowTypeInfo model) {
            setWorkflowType(model.workflowType);
            setStatus(model.status);
            setDescription(model.description);
            setCreationDate(model.creationDate);
            setDeprecationDate(model.deprecationDate);
        }

        public final WorkflowType getWorkflowType() {
            return workflowType;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegistrationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(RegistrationStatus status) {
            this.status(status.toString());
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Date getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy(creationDate);
            return this;
        }

        public final void setCreationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy(creationDate);
        }

        public final Date getDeprecationDate() {
            return deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Date deprecationDate) {
            this.deprecationDate = StandardMemberCopier.copy(deprecationDate);
            return this;
        }

        public final void setDeprecationDate(Date deprecationDate) {
            this.deprecationDate = StandardMemberCopier.copy(deprecationDate);
        }

        @Override
        public WorkflowTypeInfo build() {
            return new WorkflowTypeInfo(this);
        }
    }
}
