/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.swf.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ContinueAsNewWorkflowExecutionDecisionAttributes JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ContinueAsNewWorkflowExecutionDecisionAttributesUnmarshaller implements
        Unmarshaller<ContinueAsNewWorkflowExecutionDecisionAttributes, JsonUnmarshallerContext> {

    public ContinueAsNewWorkflowExecutionDecisionAttributes unmarshall(JsonUnmarshallerContext context) throws Exception {
        ContinueAsNewWorkflowExecutionDecisionAttributes.Builder continueAsNewWorkflowExecutionDecisionAttributesBuilder = ContinueAsNewWorkflowExecutionDecisionAttributes
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("input", targetDepth)) {
                    context.nextToken();
                    continueAsNewWorkflowExecutionDecisionAttributesBuilder.input(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("executionStartToCloseTimeout", targetDepth)) {
                    context.nextToken();
                    continueAsNewWorkflowExecutionDecisionAttributesBuilder.executionStartToCloseTimeout(context.getUnmarshaller(
                            String.class).unmarshall(context));
                }
                if (context.testExpression("taskList", targetDepth)) {
                    context.nextToken();
                    continueAsNewWorkflowExecutionDecisionAttributesBuilder.taskList(TaskListUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("taskPriority", targetDepth)) {
                    context.nextToken();
                    continueAsNewWorkflowExecutionDecisionAttributesBuilder.taskPriority(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("taskStartToCloseTimeout", targetDepth)) {
                    context.nextToken();
                    continueAsNewWorkflowExecutionDecisionAttributesBuilder.taskStartToCloseTimeout(context.getUnmarshaller(
                            String.class).unmarshall(context));
                }
                if (context.testExpression("childPolicy", targetDepth)) {
                    context.nextToken();
                    continueAsNewWorkflowExecutionDecisionAttributesBuilder.childPolicy(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("tagList", targetDepth)) {
                    context.nextToken();
                    continueAsNewWorkflowExecutionDecisionAttributesBuilder.tagList(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("workflowTypeVersion", targetDepth)) {
                    context.nextToken();
                    continueAsNewWorkflowExecutionDecisionAttributesBuilder.workflowTypeVersion(context.getUnmarshaller(
                            String.class).unmarshall(context));
                }
                if (context.testExpression("lambdaRole", targetDepth)) {
                    context.nextToken();
                    continueAsNewWorkflowExecutionDecisionAttributesBuilder.lambdaRole(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return continueAsNewWorkflowExecutionDecisionAttributesBuilder.build();
    }

    private static ContinueAsNewWorkflowExecutionDecisionAttributesUnmarshaller INSTANCE;

    public static ContinueAsNewWorkflowExecutionDecisionAttributesUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ContinueAsNewWorkflowExecutionDecisionAttributesUnmarshaller();
        return INSTANCE;
    }
}