/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.swf.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * StartChildWorkflowExecutionFailedEventAttributes JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class StartChildWorkflowExecutionFailedEventAttributesUnmarshaller implements
        Unmarshaller<StartChildWorkflowExecutionFailedEventAttributes, JsonUnmarshallerContext> {

    public StartChildWorkflowExecutionFailedEventAttributes unmarshall(JsonUnmarshallerContext context) throws Exception {
        StartChildWorkflowExecutionFailedEventAttributes.Builder startChildWorkflowExecutionFailedEventAttributesBuilder = StartChildWorkflowExecutionFailedEventAttributes
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("workflowType", targetDepth)) {
                    context.nextToken();
                    startChildWorkflowExecutionFailedEventAttributesBuilder.workflowType(WorkflowTypeUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("cause", targetDepth)) {
                    context.nextToken();
                    startChildWorkflowExecutionFailedEventAttributesBuilder.cause(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("workflowId", targetDepth)) {
                    context.nextToken();
                    startChildWorkflowExecutionFailedEventAttributesBuilder.workflowId(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("initiatedEventId", targetDepth)) {
                    context.nextToken();
                    startChildWorkflowExecutionFailedEventAttributesBuilder.initiatedEventId(context.getUnmarshaller(Long.class)
                            .unmarshall(context));
                }
                if (context.testExpression("decisionTaskCompletedEventId", targetDepth)) {
                    context.nextToken();
                    startChildWorkflowExecutionFailedEventAttributesBuilder.decisionTaskCompletedEventId(context.getUnmarshaller(
                            Long.class).unmarshall(context));
                }
                if (context.testExpression("control", targetDepth)) {
                    context.nextToken();
                    startChildWorkflowExecutionFailedEventAttributesBuilder.control(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return startChildWorkflowExecutionFailedEventAttributesBuilder.build();
    }

    private static StartChildWorkflowExecutionFailedEventAttributesUnmarshaller INSTANCE;

    public static StartChildWorkflowExecutionFailedEventAttributesUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new StartChildWorkflowExecutionFailedEventAttributesUnmarshaller();
        return INSTANCE;
    }
}