/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.swf.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * WorkflowExecutionOpenCountsMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class WorkflowExecutionOpenCountsMarshaller {

    private static final MarshallingInfo<Integer> OPENACTIVITYTASKS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("openActivityTasks").build();
    private static final MarshallingInfo<Integer> OPENDECISIONTASKS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("openDecisionTasks").build();
    private static final MarshallingInfo<Integer> OPENTIMERS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("openTimers").build();
    private static final MarshallingInfo<Integer> OPENCHILDWORKFLOWEXECUTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("openChildWorkflowExecutions").build();
    private static final MarshallingInfo<Integer> OPENLAMBDAFUNCTIONS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("openLambdaFunctions").build();

    private static final WorkflowExecutionOpenCountsMarshaller instance = new WorkflowExecutionOpenCountsMarshaller();

    public static WorkflowExecutionOpenCountsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(WorkflowExecutionOpenCounts workflowExecutionOpenCounts, ProtocolMarshaller protocolMarshaller) {

        if (workflowExecutionOpenCounts == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(workflowExecutionOpenCounts.openActivityTasks(), OPENACTIVITYTASKS_BINDING);
            protocolMarshaller.marshall(workflowExecutionOpenCounts.openDecisionTasks(), OPENDECISIONTASKS_BINDING);
            protocolMarshaller.marshall(workflowExecutionOpenCounts.openTimers(), OPENTIMERS_BINDING);
            protocolMarshaller.marshall(workflowExecutionOpenCounts.openChildWorkflowExecutions(),
                    OPENCHILDWORKFLOWEXECUTIONS_BINDING);
            protocolMarshaller.marshall(workflowExecutionOpenCounts.openLambdaFunctions(), OPENLAMBDAFUNCTIONS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
