/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf;

import java.net.URI;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.Aws4Signer;
import software.amazon.awssdk.auth.Signer;
import software.amazon.awssdk.auth.StaticSignerProvider;
import software.amazon.awssdk.client.builder.ClientBuilder;
import software.amazon.awssdk.client.builder.DefaultClientBuilder;
import software.amazon.awssdk.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.services.swf.SWFBaseClientBuilder;
import software.amazon.awssdk.services.swf.SwfHttpConfigurationOptions;
import software.amazon.awssdk.utils.AttributeMap;

@SdkInternalApi
abstract class DefaultSWFBaseClientBuilder<B extends SWFBaseClientBuilder<B, C>, C>
extends DefaultClientBuilder<B, C>
implements ClientBuilder<B, C> {
    DefaultSWFBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "swf";
    }

    protected final ClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider).addRequestHandlerPath("/software/amazon/awssdk/services/swf/request.handler2s").defaultEndpoint(this::defaultEndpoint).build();
    }

    private SignerProvider defaultSignerProvider() {
        Aws4Signer signer = new Aws4Signer();
        signer.setServiceName("swf");
        signer.setRegionName(this.signingRegion().value());
        return new StaticSignerProvider((Signer)signer);
    }

    private URI defaultEndpoint() {
        return null;
    }

    protected final AttributeMap serviceSpecificHttpConfig() {
        return SwfHttpConfigurationOptions.OPTIONS;
    }
}

