/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.swf.model.ActivityType;
import software.amazon.awssdk.services.swf.model.RegistrationStatus;
import software.amazon.awssdk.services.swf.transform.ActivityTypeInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActivityTypeInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, ActivityTypeInfo> {
    private final ActivityType activityType;
    private final String status;
    private final String description;
    private final Date creationDate;
    private final Date deprecationDate;

    private ActivityTypeInfo(BuilderImpl builder) {
        this.activityType = builder.activityType;
        this.status = builder.status;
        this.description = builder.description;
        this.creationDate = builder.creationDate;
        this.deprecationDate = builder.deprecationDate;
    }

    public ActivityType activityType() {
        return this.activityType;
    }

    public String status() {
        return this.status;
    }

    public String description() {
        return this.description;
    }

    public Date creationDate() {
        return this.creationDate;
    }

    public Date deprecationDate() {
        return this.deprecationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.activityType() == null ? 0 : this.activityType().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.deprecationDate() == null ? 0 : this.deprecationDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTypeInfo)) {
            return false;
        }
        ActivityTypeInfo other = (ActivityTypeInfo)obj;
        if (other.activityType() == null ^ this.activityType() == null) {
            return false;
        }
        if (other.activityType() != null && !other.activityType().equals(this.activityType())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.deprecationDate() == null ^ this.deprecationDate() == null) {
            return false;
        }
        return other.deprecationDate() == null || other.deprecationDate().equals(this.deprecationDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activityType() != null) {
            sb.append("ActivityType: ").append(this.activityType()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.deprecationDate() != null) {
            sb.append("DeprecationDate: ").append(this.deprecationDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivityTypeInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ActivityType activityType;
        private String status;
        private String description;
        private Date creationDate;
        private Date deprecationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTypeInfo model) {
            this.setActivityType(model.activityType);
            this.setStatus(model.status);
            this.setDescription(model.description);
            this.setCreationDate(model.creationDate);
            this.setDeprecationDate(model.deprecationDate);
        }

        public final ActivityType getActivityType() {
            return this.activityType;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType activityType) {
            this.activityType = activityType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegistrationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(RegistrationStatus status) {
            this.status(status.toString());
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Date getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy((Date)creationDate);
            return this;
        }

        public final void setCreationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy((Date)creationDate);
        }

        public final Date getDeprecationDate() {
            return this.deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Date deprecationDate) {
            this.deprecationDate = StandardMemberCopier.copy((Date)deprecationDate);
            return this;
        }

        public final void setDeprecationDate(Date deprecationDate) {
            this.deprecationDate = StandardMemberCopier.copy((Date)deprecationDate);
        }

        public ActivityTypeInfo build() {
            return new ActivityTypeInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActivityTypeInfo> {
        public Builder activityType(ActivityType var1);

        public Builder status(String var1);

        public Builder status(RegistrationStatus var1);

        public Builder description(String var1);

        public Builder creationDate(Date var1);

        public Builder deprecationDate(Date var1);
    }
}

