/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.services.swf.transform.DecisionTaskScheduledEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DecisionTaskScheduledEventAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, DecisionTaskScheduledEventAttributes> {
    private final TaskList taskList;
    private final String taskPriority;
    private final String startToCloseTimeout;

    private DecisionTaskScheduledEventAttributes(BuilderImpl builder) {
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.startToCloseTimeout = builder.startToCloseTimeout;
    }

    public TaskList taskList() {
        return this.taskList;
    }

    public String taskPriority() {
        return this.taskPriority;
    }

    public String startToCloseTimeout() {
        return this.startToCloseTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.taskList() == null ? 0 : this.taskList().hashCode());
        hashCode = 31 * hashCode + (this.taskPriority() == null ? 0 : this.taskPriority().hashCode());
        hashCode = 31 * hashCode + (this.startToCloseTimeout() == null ? 0 : this.startToCloseTimeout().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecisionTaskScheduledEventAttributes)) {
            return false;
        }
        DecisionTaskScheduledEventAttributes other = (DecisionTaskScheduledEventAttributes)obj;
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        if (other.taskPriority() == null ^ this.taskPriority() == null) {
            return false;
        }
        if (other.taskPriority() != null && !other.taskPriority().equals(this.taskPriority())) {
            return false;
        }
        if (other.startToCloseTimeout() == null ^ this.startToCloseTimeout() == null) {
            return false;
        }
        return other.startToCloseTimeout() == null || other.startToCloseTimeout().equals(this.startToCloseTimeout());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.taskList() != null) {
            sb.append("TaskList: ").append(this.taskList()).append(",");
        }
        if (this.taskPriority() != null) {
            sb.append("TaskPriority: ").append(this.taskPriority()).append(",");
        }
        if (this.startToCloseTimeout() != null) {
            sb.append("StartToCloseTimeout: ").append(this.startToCloseTimeout()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DecisionTaskScheduledEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private TaskList taskList;
        private String taskPriority;
        private String startToCloseTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(DecisionTaskScheduledEventAttributes model) {
            this.setTaskList(model.taskList);
            this.setTaskPriority(model.taskPriority);
            this.setStartToCloseTimeout(model.startToCloseTimeout);
        }

        public final TaskList getTaskList() {
            return this.taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        public final String getTaskPriority() {
            return this.taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final String getStartToCloseTimeout() {
            return this.startToCloseTimeout;
        }

        @Override
        public final Builder startToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
            return this;
        }

        public final void setStartToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
        }

        public DecisionTaskScheduledEventAttributes build() {
            return new DecisionTaskScheduledEventAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DecisionTaskScheduledEventAttributes> {
        public Builder taskList(TaskList var1);

        public Builder taskPriority(String var1);

        public Builder startToCloseTimeout(String var1);
    }
}

