/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionConfiguration;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionOpenCounts;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeWorkflowExecutionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeWorkflowExecutionResponse> {
    private final WorkflowExecutionInfo executionInfo;
    private final WorkflowExecutionConfiguration executionConfiguration;
    private final WorkflowExecutionOpenCounts openCounts;
    private final Date latestActivityTaskTimestamp;
    private final String latestExecutionContext;

    private DescribeWorkflowExecutionResponse(BuilderImpl builder) {
        this.executionInfo = builder.executionInfo;
        this.executionConfiguration = builder.executionConfiguration;
        this.openCounts = builder.openCounts;
        this.latestActivityTaskTimestamp = builder.latestActivityTaskTimestamp;
        this.latestExecutionContext = builder.latestExecutionContext;
    }

    public WorkflowExecutionInfo executionInfo() {
        return this.executionInfo;
    }

    public WorkflowExecutionConfiguration executionConfiguration() {
        return this.executionConfiguration;
    }

    public WorkflowExecutionOpenCounts openCounts() {
        return this.openCounts;
    }

    public Date latestActivityTaskTimestamp() {
        return this.latestActivityTaskTimestamp;
    }

    public String latestExecutionContext() {
        return this.latestExecutionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.executionInfo() == null ? 0 : this.executionInfo().hashCode());
        hashCode = 31 * hashCode + (this.executionConfiguration() == null ? 0 : this.executionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.openCounts() == null ? 0 : this.openCounts().hashCode());
        hashCode = 31 * hashCode + (this.latestActivityTaskTimestamp() == null ? 0 : this.latestActivityTaskTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.latestExecutionContext() == null ? 0 : this.latestExecutionContext().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkflowExecutionResponse)) {
            return false;
        }
        DescribeWorkflowExecutionResponse other = (DescribeWorkflowExecutionResponse)((Object)obj);
        if (other.executionInfo() == null ^ this.executionInfo() == null) {
            return false;
        }
        if (other.executionInfo() != null && !other.executionInfo().equals(this.executionInfo())) {
            return false;
        }
        if (other.executionConfiguration() == null ^ this.executionConfiguration() == null) {
            return false;
        }
        if (other.executionConfiguration() != null && !other.executionConfiguration().equals(this.executionConfiguration())) {
            return false;
        }
        if (other.openCounts() == null ^ this.openCounts() == null) {
            return false;
        }
        if (other.openCounts() != null && !other.openCounts().equals(this.openCounts())) {
            return false;
        }
        if (other.latestActivityTaskTimestamp() == null ^ this.latestActivityTaskTimestamp() == null) {
            return false;
        }
        if (other.latestActivityTaskTimestamp() != null && !other.latestActivityTaskTimestamp().equals(this.latestActivityTaskTimestamp())) {
            return false;
        }
        if (other.latestExecutionContext() == null ^ this.latestExecutionContext() == null) {
            return false;
        }
        return other.latestExecutionContext() == null || other.latestExecutionContext().equals(this.latestExecutionContext());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.executionInfo() != null) {
            sb.append("ExecutionInfo: ").append(this.executionInfo()).append(",");
        }
        if (this.executionConfiguration() != null) {
            sb.append("ExecutionConfiguration: ").append(this.executionConfiguration()).append(",");
        }
        if (this.openCounts() != null) {
            sb.append("OpenCounts: ").append(this.openCounts()).append(",");
        }
        if (this.latestActivityTaskTimestamp() != null) {
            sb.append("LatestActivityTaskTimestamp: ").append(this.latestActivityTaskTimestamp()).append(",");
        }
        if (this.latestExecutionContext() != null) {
            sb.append("LatestExecutionContext: ").append(this.latestExecutionContext()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private WorkflowExecutionInfo executionInfo;
        private WorkflowExecutionConfiguration executionConfiguration;
        private WorkflowExecutionOpenCounts openCounts;
        private Date latestActivityTaskTimestamp;
        private String latestExecutionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkflowExecutionResponse model) {
            this.setExecutionInfo(model.executionInfo);
            this.setExecutionConfiguration(model.executionConfiguration);
            this.setOpenCounts(model.openCounts);
            this.setLatestActivityTaskTimestamp(model.latestActivityTaskTimestamp);
            this.setLatestExecutionContext(model.latestExecutionContext);
        }

        public final WorkflowExecutionInfo getExecutionInfo() {
            return this.executionInfo;
        }

        @Override
        public final Builder executionInfo(WorkflowExecutionInfo executionInfo) {
            this.executionInfo = executionInfo;
            return this;
        }

        public final void setExecutionInfo(WorkflowExecutionInfo executionInfo) {
            this.executionInfo = executionInfo;
        }

        public final WorkflowExecutionConfiguration getExecutionConfiguration() {
            return this.executionConfiguration;
        }

        @Override
        public final Builder executionConfiguration(WorkflowExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        public final void setExecutionConfiguration(WorkflowExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
        }

        public final WorkflowExecutionOpenCounts getOpenCounts() {
            return this.openCounts;
        }

        @Override
        public final Builder openCounts(WorkflowExecutionOpenCounts openCounts) {
            this.openCounts = openCounts;
            return this;
        }

        public final void setOpenCounts(WorkflowExecutionOpenCounts openCounts) {
            this.openCounts = openCounts;
        }

        public final Date getLatestActivityTaskTimestamp() {
            return this.latestActivityTaskTimestamp;
        }

        @Override
        public final Builder latestActivityTaskTimestamp(Date latestActivityTaskTimestamp) {
            this.latestActivityTaskTimestamp = StandardMemberCopier.copy((Date)latestActivityTaskTimestamp);
            return this;
        }

        public final void setLatestActivityTaskTimestamp(Date latestActivityTaskTimestamp) {
            this.latestActivityTaskTimestamp = StandardMemberCopier.copy((Date)latestActivityTaskTimestamp);
        }

        public final String getLatestExecutionContext() {
            return this.latestExecutionContext;
        }

        @Override
        public final Builder latestExecutionContext(String latestExecutionContext) {
            this.latestExecutionContext = latestExecutionContext;
            return this;
        }

        public final void setLatestExecutionContext(String latestExecutionContext) {
            this.latestExecutionContext = latestExecutionContext;
        }

        public DescribeWorkflowExecutionResponse build() {
            return new DescribeWorkflowExecutionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeWorkflowExecutionResponse> {
        public Builder executionInfo(WorkflowExecutionInfo var1);

        public Builder executionConfiguration(WorkflowExecutionConfiguration var1);

        public Builder openCounts(WorkflowExecutionOpenCounts var1);

        public Builder latestActivityTaskTimestamp(Date var1);

        public Builder latestExecutionContext(String var1);
    }
}

