/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionInfoListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListClosedWorkflowExecutionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListClosedWorkflowExecutionsResponse> {
    private final List<WorkflowExecutionInfo> executionInfos;
    private final String nextPageToken;

    private ListClosedWorkflowExecutionsResponse(BuilderImpl builder) {
        this.executionInfos = builder.executionInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<WorkflowExecutionInfo> executionInfos() {
        return this.executionInfos;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.executionInfos() == null ? 0 : this.executionInfos().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClosedWorkflowExecutionsResponse)) {
            return false;
        }
        ListClosedWorkflowExecutionsResponse other = (ListClosedWorkflowExecutionsResponse)((Object)obj);
        if (other.executionInfos() == null ^ this.executionInfos() == null) {
            return false;
        }
        if (other.executionInfos() != null && !other.executionInfos().equals(this.executionInfos())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.executionInfos() != null) {
            sb.append("ExecutionInfos: ").append(this.executionInfos()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<WorkflowExecutionInfo> executionInfos;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClosedWorkflowExecutionsResponse model) {
            this.setExecutionInfos(model.executionInfos);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<WorkflowExecutionInfo> getExecutionInfos() {
            return this.executionInfos;
        }

        @Override
        public final Builder executionInfos(Collection<WorkflowExecutionInfo> executionInfos) {
            this.executionInfos = WorkflowExecutionInfoListCopier.copy(executionInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionInfos(WorkflowExecutionInfo ... executionInfos) {
            if (this.executionInfos == null) {
                this.executionInfos = new ArrayList<WorkflowExecutionInfo>(executionInfos.length);
            }
            for (WorkflowExecutionInfo e : executionInfos) {
                this.executionInfos.add(e);
            }
            return this;
        }

        public final void setExecutionInfos(Collection<WorkflowExecutionInfo> executionInfos) {
            this.executionInfos = WorkflowExecutionInfoListCopier.copy(executionInfos);
        }

        @SafeVarargs
        public final void setExecutionInfos(WorkflowExecutionInfo ... executionInfos) {
            if (this.executionInfos == null) {
                this.executionInfos = new ArrayList<WorkflowExecutionInfo>(executionInfos.length);
            }
            for (WorkflowExecutionInfo e : executionInfos) {
                this.executionInfos.add(e);
            }
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public ListClosedWorkflowExecutionsResponse build() {
            return new ListClosedWorkflowExecutionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListClosedWorkflowExecutionsResponse> {
        public Builder executionInfos(Collection<WorkflowExecutionInfo> var1);

        public Builder executionInfos(WorkflowExecutionInfo ... var1);

        public Builder nextPageToken(String var1);
    }
}

