/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.swf.model.WorkflowTypeInfo;
import software.amazon.awssdk.services.swf.model.WorkflowTypeInfoListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListWorkflowTypesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListWorkflowTypesResponse> {
    private final List<WorkflowTypeInfo> typeInfos;
    private final String nextPageToken;

    private ListWorkflowTypesResponse(BuilderImpl builder) {
        this.typeInfos = builder.typeInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<WorkflowTypeInfo> typeInfos() {
        return this.typeInfos;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typeInfos() == null ? 0 : this.typeInfos().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowTypesResponse)) {
            return false;
        }
        ListWorkflowTypesResponse other = (ListWorkflowTypesResponse)((Object)obj);
        if (other.typeInfos() == null ^ this.typeInfos() == null) {
            return false;
        }
        if (other.typeInfos() != null && !other.typeInfos().equals(this.typeInfos())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.typeInfos() != null) {
            sb.append("TypeInfos: ").append(this.typeInfos()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<WorkflowTypeInfo> typeInfos;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowTypesResponse model) {
            this.setTypeInfos(model.typeInfos);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<WorkflowTypeInfo> getTypeInfos() {
            return this.typeInfos;
        }

        @Override
        public final Builder typeInfos(Collection<WorkflowTypeInfo> typeInfos) {
            this.typeInfos = WorkflowTypeInfoListCopier.copy(typeInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeInfos(WorkflowTypeInfo ... typeInfos) {
            if (this.typeInfos == null) {
                this.typeInfos = new ArrayList<WorkflowTypeInfo>(typeInfos.length);
            }
            for (WorkflowTypeInfo e : typeInfos) {
                this.typeInfos.add(e);
            }
            return this;
        }

        public final void setTypeInfos(Collection<WorkflowTypeInfo> typeInfos) {
            this.typeInfos = WorkflowTypeInfoListCopier.copy(typeInfos);
        }

        @SafeVarargs
        public final void setTypeInfos(WorkflowTypeInfo ... typeInfos) {
            if (this.typeInfos == null) {
                this.typeInfos = new ArrayList<WorkflowTypeInfo>(typeInfos.length);
            }
            for (WorkflowTypeInfo e : typeInfos) {
                this.typeInfos.add(e);
            }
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public ListWorkflowTypesResponse build() {
            return new ListWorkflowTypesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListWorkflowTypesResponse> {
        public Builder typeInfos(Collection<WorkflowTypeInfo> var1);

        public Builder typeInfos(WorkflowTypeInfo ... var1);

        public Builder nextPageToken(String var1);
    }
}

