/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.HistoryEventListCopier;
import software.amazon.awssdk.services.swf.model.WorkflowExecution;
import software.amazon.awssdk.services.swf.model.WorkflowType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PollForDecisionTaskResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PollForDecisionTaskResponse> {
    private final String taskToken;
    private final Long startedEventId;
    private final WorkflowExecution workflowExecution;
    private final WorkflowType workflowType;
    private final List<HistoryEvent> events;
    private final String nextPageToken;
    private final Long previousStartedEventId;

    private PollForDecisionTaskResponse(BuilderImpl builder) {
        this.taskToken = builder.taskToken;
        this.startedEventId = builder.startedEventId;
        this.workflowExecution = builder.workflowExecution;
        this.workflowType = builder.workflowType;
        this.events = builder.events;
        this.nextPageToken = builder.nextPageToken;
        this.previousStartedEventId = builder.previousStartedEventId;
    }

    public String taskToken() {
        return this.taskToken;
    }

    public Long startedEventId() {
        return this.startedEventId;
    }

    public WorkflowExecution workflowExecution() {
        return this.workflowExecution;
    }

    public WorkflowType workflowType() {
        return this.workflowType;
    }

    public List<HistoryEvent> events() {
        return this.events;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Long previousStartedEventId() {
        return this.previousStartedEventId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.taskToken() == null ? 0 : this.taskToken().hashCode());
        hashCode = 31 * hashCode + (this.startedEventId() == null ? 0 : this.startedEventId().hashCode());
        hashCode = 31 * hashCode + (this.workflowExecution() == null ? 0 : this.workflowExecution().hashCode());
        hashCode = 31 * hashCode + (this.workflowType() == null ? 0 : this.workflowType().hashCode());
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        hashCode = 31 * hashCode + (this.previousStartedEventId() == null ? 0 : this.previousStartedEventId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForDecisionTaskResponse)) {
            return false;
        }
        PollForDecisionTaskResponse other = (PollForDecisionTaskResponse)((Object)obj);
        if (other.taskToken() == null ^ this.taskToken() == null) {
            return false;
        }
        if (other.taskToken() != null && !other.taskToken().equals(this.taskToken())) {
            return false;
        }
        if (other.startedEventId() == null ^ this.startedEventId() == null) {
            return false;
        }
        if (other.startedEventId() != null && !other.startedEventId().equals(this.startedEventId())) {
            return false;
        }
        if (other.workflowExecution() == null ^ this.workflowExecution() == null) {
            return false;
        }
        if (other.workflowExecution() != null && !other.workflowExecution().equals(this.workflowExecution())) {
            return false;
        }
        if (other.workflowType() == null ^ this.workflowType() == null) {
            return false;
        }
        if (other.workflowType() != null && !other.workflowType().equals(this.workflowType())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        if (other.previousStartedEventId() == null ^ this.previousStartedEventId() == null) {
            return false;
        }
        return other.previousStartedEventId() == null || other.previousStartedEventId().equals(this.previousStartedEventId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.taskToken() != null) {
            sb.append("TaskToken: ").append(this.taskToken()).append(",");
        }
        if (this.startedEventId() != null) {
            sb.append("StartedEventId: ").append(this.startedEventId()).append(",");
        }
        if (this.workflowExecution() != null) {
            sb.append("WorkflowExecution: ").append(this.workflowExecution()).append(",");
        }
        if (this.workflowType() != null) {
            sb.append("WorkflowType: ").append(this.workflowType()).append(",");
        }
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (this.previousStartedEventId() != null) {
            sb.append("PreviousStartedEventId: ").append(this.previousStartedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String taskToken;
        private Long startedEventId;
        private WorkflowExecution workflowExecution;
        private WorkflowType workflowType;
        private List<HistoryEvent> events;
        private String nextPageToken;
        private Long previousStartedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForDecisionTaskResponse model) {
            this.setTaskToken(model.taskToken);
            this.setStartedEventId(model.startedEventId);
            this.setWorkflowExecution(model.workflowExecution);
            this.setWorkflowType(model.workflowType);
            this.setEvents(model.events);
            this.setNextPageToken(model.nextPageToken);
            this.setPreviousStartedEventId(model.previousStartedEventId);
        }

        public final String getTaskToken() {
            return this.taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final Long getStartedEventId() {
            return this.startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public final WorkflowExecution getWorkflowExecution() {
            return this.workflowExecution;
        }

        @Override
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final void setWorkflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
        }

        public final WorkflowType getWorkflowType() {
            return this.workflowType;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
        }

        public final Collection<HistoryEvent> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<HistoryEvent> events) {
            this.events = HistoryEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(HistoryEvent ... events) {
            if (this.events == null) {
                this.events = new ArrayList<HistoryEvent>(events.length);
            }
            for (HistoryEvent e : events) {
                this.events.add(e);
            }
            return this;
        }

        public final void setEvents(Collection<HistoryEvent> events) {
            this.events = HistoryEventListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(HistoryEvent ... events) {
            if (this.events == null) {
                this.events = new ArrayList<HistoryEvent>(events.length);
            }
            for (HistoryEvent e : events) {
                this.events.add(e);
            }
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Long getPreviousStartedEventId() {
            return this.previousStartedEventId;
        }

        @Override
        public final Builder previousStartedEventId(Long previousStartedEventId) {
            this.previousStartedEventId = previousStartedEventId;
            return this;
        }

        public final void setPreviousStartedEventId(Long previousStartedEventId) {
            this.previousStartedEventId = previousStartedEventId;
        }

        public PollForDecisionTaskResponse build() {
            return new PollForDecisionTaskResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PollForDecisionTaskResponse> {
        public Builder taskToken(String var1);

        public Builder startedEventId(Long var1);

        public Builder workflowExecution(WorkflowExecution var1);

        public Builder workflowType(WorkflowType var1);

        public Builder events(Collection<HistoryEvent> var1);

        public Builder events(HistoryEvent ... var1);

        public Builder nextPageToken(String var1);

        public Builder previousStartedEventId(Long var1);
    }
}

