/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.swf.model.Decision;
import software.amazon.awssdk.services.swf.model.DecisionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RespondDecisionTaskCompletedRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RespondDecisionTaskCompletedRequest> {
    private final String taskToken;
    private final List<Decision> decisions;
    private final String executionContext;

    private RespondDecisionTaskCompletedRequest(BuilderImpl builder) {
        this.taskToken = builder.taskToken;
        this.decisions = builder.decisions;
        this.executionContext = builder.executionContext;
    }

    public String taskToken() {
        return this.taskToken;
    }

    public List<Decision> decisions() {
        return this.decisions;
    }

    public String executionContext() {
        return this.executionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.taskToken() == null ? 0 : this.taskToken().hashCode());
        hashCode = 31 * hashCode + (this.decisions() == null ? 0 : this.decisions().hashCode());
        hashCode = 31 * hashCode + (this.executionContext() == null ? 0 : this.executionContext().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondDecisionTaskCompletedRequest)) {
            return false;
        }
        RespondDecisionTaskCompletedRequest other = (RespondDecisionTaskCompletedRequest)((Object)obj);
        if (other.taskToken() == null ^ this.taskToken() == null) {
            return false;
        }
        if (other.taskToken() != null && !other.taskToken().equals(this.taskToken())) {
            return false;
        }
        if (other.decisions() == null ^ this.decisions() == null) {
            return false;
        }
        if (other.decisions() != null && !other.decisions().equals(this.decisions())) {
            return false;
        }
        if (other.executionContext() == null ^ this.executionContext() == null) {
            return false;
        }
        return other.executionContext() == null || other.executionContext().equals(this.executionContext());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.taskToken() != null) {
            sb.append("TaskToken: ").append(this.taskToken()).append(",");
        }
        if (this.decisions() != null) {
            sb.append("Decisions: ").append(this.decisions()).append(",");
        }
        if (this.executionContext() != null) {
            sb.append("ExecutionContext: ").append(this.executionContext()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String taskToken;
        private List<Decision> decisions;
        private String executionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(RespondDecisionTaskCompletedRequest model) {
            this.setTaskToken(model.taskToken);
            this.setDecisions(model.decisions);
            this.setExecutionContext(model.executionContext);
        }

        public final String getTaskToken() {
            return this.taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final Collection<Decision> getDecisions() {
            return this.decisions;
        }

        @Override
        public final Builder decisions(Collection<Decision> decisions) {
            this.decisions = DecisionListCopier.copy(decisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decisions(Decision ... decisions) {
            if (this.decisions == null) {
                this.decisions = new ArrayList<Decision>(decisions.length);
            }
            for (Decision e : decisions) {
                this.decisions.add(e);
            }
            return this;
        }

        public final void setDecisions(Collection<Decision> decisions) {
            this.decisions = DecisionListCopier.copy(decisions);
        }

        @SafeVarargs
        public final void setDecisions(Decision ... decisions) {
            if (this.decisions == null) {
                this.decisions = new ArrayList<Decision>(decisions.length);
            }
            for (Decision e : decisions) {
                this.decisions.add(e);
            }
        }

        public final String getExecutionContext() {
            return this.executionContext;
        }

        @Override
        public final Builder executionContext(String executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        public final void setExecutionContext(String executionContext) {
            this.executionContext = executionContext;
        }

        public RespondDecisionTaskCompletedRequest build() {
            return new RespondDecisionTaskCompletedRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RespondDecisionTaskCompletedRequest> {
        public Builder taskToken(String var1);

        public Builder decisions(Collection<Decision> var1);

        public Builder decisions(Decision ... var1);

        public Builder executionContext(String var1);
    }
}

