/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WorkflowExecution
implements StructuredPojo,
ToCopyableBuilder<Builder, WorkflowExecution> {
    private final String workflowId;
    private final String runId;

    private WorkflowExecution(BuilderImpl builder) {
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
    }

    public String workflowId() {
        return this.workflowId;
    }

    public String runId() {
        return this.runId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.workflowId() == null ? 0 : this.workflowId().hashCode());
        hashCode = 31 * hashCode + (this.runId() == null ? 0 : this.runId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecution)) {
            return false;
        }
        WorkflowExecution other = (WorkflowExecution)obj;
        if (other.workflowId() == null ^ this.workflowId() == null) {
            return false;
        }
        if (other.workflowId() != null && !other.workflowId().equals(this.workflowId())) {
            return false;
        }
        if (other.runId() == null ^ this.runId() == null) {
            return false;
        }
        return other.runId() == null || other.runId().equals(this.runId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.workflowId() != null) {
            sb.append("WorkflowId: ").append(this.workflowId()).append(",");
        }
        if (this.runId() != null) {
            sb.append("RunId: ").append(this.runId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String workflowId;
        private String runId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecution model) {
            this.setWorkflowId(model.workflowId);
            this.setRunId(model.runId);
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final String getRunId() {
            return this.runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public WorkflowExecution build() {
            return new WorkflowExecution(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WorkflowExecution> {
        public Builder workflowId(String var1);

        public Builder runId(String var1);
    }
}

