/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.swf.model.CloseStatus;
import software.amazon.awssdk.services.swf.model.ExecutionStatus;
import software.amazon.awssdk.services.swf.model.TagListCopier;
import software.amazon.awssdk.services.swf.model.WorkflowExecution;
import software.amazon.awssdk.services.swf.model.WorkflowType;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WorkflowExecutionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, WorkflowExecutionInfo> {
    private final WorkflowExecution execution;
    private final WorkflowType workflowType;
    private final Date startTimestamp;
    private final Date closeTimestamp;
    private final String executionStatus;
    private final String closeStatus;
    private final WorkflowExecution parent;
    private final List<String> tagList;
    private final Boolean cancelRequested;

    private WorkflowExecutionInfo(BuilderImpl builder) {
        this.execution = builder.execution;
        this.workflowType = builder.workflowType;
        this.startTimestamp = builder.startTimestamp;
        this.closeTimestamp = builder.closeTimestamp;
        this.executionStatus = builder.executionStatus;
        this.closeStatus = builder.closeStatus;
        this.parent = builder.parent;
        this.tagList = builder.tagList;
        this.cancelRequested = builder.cancelRequested;
    }

    public WorkflowExecution execution() {
        return this.execution;
    }

    public WorkflowType workflowType() {
        return this.workflowType;
    }

    public Date startTimestamp() {
        return this.startTimestamp;
    }

    public Date closeTimestamp() {
        return this.closeTimestamp;
    }

    public String executionStatus() {
        return this.executionStatus;
    }

    public String closeStatus() {
        return this.closeStatus;
    }

    public WorkflowExecution parent() {
        return this.parent;
    }

    public List<String> tagList() {
        return this.tagList;
    }

    public Boolean cancelRequested() {
        return this.cancelRequested;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.execution() == null ? 0 : this.execution().hashCode());
        hashCode = 31 * hashCode + (this.workflowType() == null ? 0 : this.workflowType().hashCode());
        hashCode = 31 * hashCode + (this.startTimestamp() == null ? 0 : this.startTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.closeTimestamp() == null ? 0 : this.closeTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.executionStatus() == null ? 0 : this.executionStatus().hashCode());
        hashCode = 31 * hashCode + (this.closeStatus() == null ? 0 : this.closeStatus().hashCode());
        hashCode = 31 * hashCode + (this.parent() == null ? 0 : this.parent().hashCode());
        hashCode = 31 * hashCode + (this.tagList() == null ? 0 : this.tagList().hashCode());
        hashCode = 31 * hashCode + (this.cancelRequested() == null ? 0 : this.cancelRequested().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionInfo)) {
            return false;
        }
        WorkflowExecutionInfo other = (WorkflowExecutionInfo)obj;
        if (other.execution() == null ^ this.execution() == null) {
            return false;
        }
        if (other.execution() != null && !other.execution().equals(this.execution())) {
            return false;
        }
        if (other.workflowType() == null ^ this.workflowType() == null) {
            return false;
        }
        if (other.workflowType() != null && !other.workflowType().equals(this.workflowType())) {
            return false;
        }
        if (other.startTimestamp() == null ^ this.startTimestamp() == null) {
            return false;
        }
        if (other.startTimestamp() != null && !other.startTimestamp().equals(this.startTimestamp())) {
            return false;
        }
        if (other.closeTimestamp() == null ^ this.closeTimestamp() == null) {
            return false;
        }
        if (other.closeTimestamp() != null && !other.closeTimestamp().equals(this.closeTimestamp())) {
            return false;
        }
        if (other.executionStatus() == null ^ this.executionStatus() == null) {
            return false;
        }
        if (other.executionStatus() != null && !other.executionStatus().equals(this.executionStatus())) {
            return false;
        }
        if (other.closeStatus() == null ^ this.closeStatus() == null) {
            return false;
        }
        if (other.closeStatus() != null && !other.closeStatus().equals(this.closeStatus())) {
            return false;
        }
        if (other.parent() == null ^ this.parent() == null) {
            return false;
        }
        if (other.parent() != null && !other.parent().equals(this.parent())) {
            return false;
        }
        if (other.tagList() == null ^ this.tagList() == null) {
            return false;
        }
        if (other.tagList() != null && !other.tagList().equals(this.tagList())) {
            return false;
        }
        if (other.cancelRequested() == null ^ this.cancelRequested() == null) {
            return false;
        }
        return other.cancelRequested() == null || other.cancelRequested().equals(this.cancelRequested());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.execution() != null) {
            sb.append("Execution: ").append(this.execution()).append(",");
        }
        if (this.workflowType() != null) {
            sb.append("WorkflowType: ").append(this.workflowType()).append(",");
        }
        if (this.startTimestamp() != null) {
            sb.append("StartTimestamp: ").append(this.startTimestamp()).append(",");
        }
        if (this.closeTimestamp() != null) {
            sb.append("CloseTimestamp: ").append(this.closeTimestamp()).append(",");
        }
        if (this.executionStatus() != null) {
            sb.append("ExecutionStatus: ").append(this.executionStatus()).append(",");
        }
        if (this.closeStatus() != null) {
            sb.append("CloseStatus: ").append(this.closeStatus()).append(",");
        }
        if (this.parent() != null) {
            sb.append("Parent: ").append(this.parent()).append(",");
        }
        if (this.tagList() != null) {
            sb.append("TagList: ").append(this.tagList()).append(",");
        }
        if (this.cancelRequested() != null) {
            sb.append("CancelRequested: ").append(this.cancelRequested()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private WorkflowExecution execution;
        private WorkflowType workflowType;
        private Date startTimestamp;
        private Date closeTimestamp;
        private String executionStatus;
        private String closeStatus;
        private WorkflowExecution parent;
        private List<String> tagList;
        private Boolean cancelRequested;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionInfo model) {
            this.setExecution(model.execution);
            this.setWorkflowType(model.workflowType);
            this.setStartTimestamp(model.startTimestamp);
            this.setCloseTimestamp(model.closeTimestamp);
            this.setExecutionStatus(model.executionStatus);
            this.setCloseStatus(model.closeStatus);
            this.setParent(model.parent);
            this.setTagList(model.tagList);
            this.setCancelRequested(model.cancelRequested);
        }

        public final WorkflowExecution getExecution() {
            return this.execution;
        }

        @Override
        public final Builder execution(WorkflowExecution execution) {
            this.execution = execution;
            return this;
        }

        public final void setExecution(WorkflowExecution execution) {
            this.execution = execution;
        }

        public final WorkflowType getWorkflowType() {
            return this.workflowType;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
        }

        public final Date getStartTimestamp() {
            return this.startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Date startTimestamp) {
            this.startTimestamp = StandardMemberCopier.copy((Date)startTimestamp);
            return this;
        }

        public final void setStartTimestamp(Date startTimestamp) {
            this.startTimestamp = StandardMemberCopier.copy((Date)startTimestamp);
        }

        public final Date getCloseTimestamp() {
            return this.closeTimestamp;
        }

        @Override
        public final Builder closeTimestamp(Date closeTimestamp) {
            this.closeTimestamp = StandardMemberCopier.copy((Date)closeTimestamp);
            return this;
        }

        public final void setCloseTimestamp(Date closeTimestamp) {
            this.closeTimestamp = StandardMemberCopier.copy((Date)closeTimestamp);
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus.toString());
            return this;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        public final void setExecutionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus.toString());
        }

        public final String getCloseStatus() {
            return this.closeStatus;
        }

        @Override
        public final Builder closeStatus(String closeStatus) {
            this.closeStatus = closeStatus;
            return this;
        }

        @Override
        public final Builder closeStatus(CloseStatus closeStatus) {
            this.closeStatus(closeStatus.toString());
            return this;
        }

        public final void setCloseStatus(String closeStatus) {
            this.closeStatus = closeStatus;
        }

        public final void setCloseStatus(CloseStatus closeStatus) {
            this.closeStatus(closeStatus.toString());
        }

        public final WorkflowExecution getParent() {
            return this.parent;
        }

        @Override
        public final Builder parent(WorkflowExecution parent) {
            this.parent = parent;
            return this;
        }

        public final void setParent(WorkflowExecution parent) {
            this.parent = parent;
        }

        public final Collection<String> getTagList() {
            return this.tagList;
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String ... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<String>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
            return this;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        @SafeVarargs
        public final void setTagList(String ... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<String>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
        }

        public final Boolean getCancelRequested() {
            return this.cancelRequested;
        }

        @Override
        public final Builder cancelRequested(Boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
            return this;
        }

        public final void setCancelRequested(Boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
        }

        public WorkflowExecutionInfo build() {
            return new WorkflowExecutionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WorkflowExecutionInfo> {
        public Builder execution(WorkflowExecution var1);

        public Builder workflowType(WorkflowType var1);

        public Builder startTimestamp(Date var1);

        public Builder closeTimestamp(Date var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(ExecutionStatus var1);

        public Builder closeStatus(String var1);

        public Builder closeStatus(CloseStatus var1);

        public Builder parent(WorkflowExecution var1);

        public Builder tagList(Collection<String> var1);

        public Builder tagList(String ... var1);

        public Builder cancelRequested(Boolean var1);
    }
}

