/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionOpenCountsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WorkflowExecutionOpenCounts
implements StructuredPojo,
ToCopyableBuilder<Builder, WorkflowExecutionOpenCounts> {
    private final Integer openActivityTasks;
    private final Integer openDecisionTasks;
    private final Integer openTimers;
    private final Integer openChildWorkflowExecutions;
    private final Integer openLambdaFunctions;

    private WorkflowExecutionOpenCounts(BuilderImpl builder) {
        this.openActivityTasks = builder.openActivityTasks;
        this.openDecisionTasks = builder.openDecisionTasks;
        this.openTimers = builder.openTimers;
        this.openChildWorkflowExecutions = builder.openChildWorkflowExecutions;
        this.openLambdaFunctions = builder.openLambdaFunctions;
    }

    public Integer openActivityTasks() {
        return this.openActivityTasks;
    }

    public Integer openDecisionTasks() {
        return this.openDecisionTasks;
    }

    public Integer openTimers() {
        return this.openTimers;
    }

    public Integer openChildWorkflowExecutions() {
        return this.openChildWorkflowExecutions;
    }

    public Integer openLambdaFunctions() {
        return this.openLambdaFunctions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.openActivityTasks() == null ? 0 : this.openActivityTasks().hashCode());
        hashCode = 31 * hashCode + (this.openDecisionTasks() == null ? 0 : this.openDecisionTasks().hashCode());
        hashCode = 31 * hashCode + (this.openTimers() == null ? 0 : this.openTimers().hashCode());
        hashCode = 31 * hashCode + (this.openChildWorkflowExecutions() == null ? 0 : this.openChildWorkflowExecutions().hashCode());
        hashCode = 31 * hashCode + (this.openLambdaFunctions() == null ? 0 : this.openLambdaFunctions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionOpenCounts)) {
            return false;
        }
        WorkflowExecutionOpenCounts other = (WorkflowExecutionOpenCounts)obj;
        if (other.openActivityTasks() == null ^ this.openActivityTasks() == null) {
            return false;
        }
        if (other.openActivityTasks() != null && !other.openActivityTasks().equals(this.openActivityTasks())) {
            return false;
        }
        if (other.openDecisionTasks() == null ^ this.openDecisionTasks() == null) {
            return false;
        }
        if (other.openDecisionTasks() != null && !other.openDecisionTasks().equals(this.openDecisionTasks())) {
            return false;
        }
        if (other.openTimers() == null ^ this.openTimers() == null) {
            return false;
        }
        if (other.openTimers() != null && !other.openTimers().equals(this.openTimers())) {
            return false;
        }
        if (other.openChildWorkflowExecutions() == null ^ this.openChildWorkflowExecutions() == null) {
            return false;
        }
        if (other.openChildWorkflowExecutions() != null && !other.openChildWorkflowExecutions().equals(this.openChildWorkflowExecutions())) {
            return false;
        }
        if (other.openLambdaFunctions() == null ^ this.openLambdaFunctions() == null) {
            return false;
        }
        return other.openLambdaFunctions() == null || other.openLambdaFunctions().equals(this.openLambdaFunctions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.openActivityTasks() != null) {
            sb.append("OpenActivityTasks: ").append(this.openActivityTasks()).append(",");
        }
        if (this.openDecisionTasks() != null) {
            sb.append("OpenDecisionTasks: ").append(this.openDecisionTasks()).append(",");
        }
        if (this.openTimers() != null) {
            sb.append("OpenTimers: ").append(this.openTimers()).append(",");
        }
        if (this.openChildWorkflowExecutions() != null) {
            sb.append("OpenChildWorkflowExecutions: ").append(this.openChildWorkflowExecutions()).append(",");
        }
        if (this.openLambdaFunctions() != null) {
            sb.append("OpenLambdaFunctions: ").append(this.openLambdaFunctions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionOpenCountsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer openActivityTasks;
        private Integer openDecisionTasks;
        private Integer openTimers;
        private Integer openChildWorkflowExecutions;
        private Integer openLambdaFunctions;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionOpenCounts model) {
            this.setOpenActivityTasks(model.openActivityTasks);
            this.setOpenDecisionTasks(model.openDecisionTasks);
            this.setOpenTimers(model.openTimers);
            this.setOpenChildWorkflowExecutions(model.openChildWorkflowExecutions);
            this.setOpenLambdaFunctions(model.openLambdaFunctions);
        }

        public final Integer getOpenActivityTasks() {
            return this.openActivityTasks;
        }

        @Override
        public final Builder openActivityTasks(Integer openActivityTasks) {
            this.openActivityTasks = openActivityTasks;
            return this;
        }

        public final void setOpenActivityTasks(Integer openActivityTasks) {
            this.openActivityTasks = openActivityTasks;
        }

        public final Integer getOpenDecisionTasks() {
            return this.openDecisionTasks;
        }

        @Override
        public final Builder openDecisionTasks(Integer openDecisionTasks) {
            this.openDecisionTasks = openDecisionTasks;
            return this;
        }

        public final void setOpenDecisionTasks(Integer openDecisionTasks) {
            this.openDecisionTasks = openDecisionTasks;
        }

        public final Integer getOpenTimers() {
            return this.openTimers;
        }

        @Override
        public final Builder openTimers(Integer openTimers) {
            this.openTimers = openTimers;
            return this;
        }

        public final void setOpenTimers(Integer openTimers) {
            this.openTimers = openTimers;
        }

        public final Integer getOpenChildWorkflowExecutions() {
            return this.openChildWorkflowExecutions;
        }

        @Override
        public final Builder openChildWorkflowExecutions(Integer openChildWorkflowExecutions) {
            this.openChildWorkflowExecutions = openChildWorkflowExecutions;
            return this;
        }

        public final void setOpenChildWorkflowExecutions(Integer openChildWorkflowExecutions) {
            this.openChildWorkflowExecutions = openChildWorkflowExecutions;
        }

        public final Integer getOpenLambdaFunctions() {
            return this.openLambdaFunctions;
        }

        @Override
        public final Builder openLambdaFunctions(Integer openLambdaFunctions) {
            this.openLambdaFunctions = openLambdaFunctions;
            return this;
        }

        public final void setOpenLambdaFunctions(Integer openLambdaFunctions) {
            this.openLambdaFunctions = openLambdaFunctions;
        }

        public WorkflowExecutionOpenCounts build() {
            return new WorkflowExecutionOpenCounts(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WorkflowExecutionOpenCounts> {
        public Builder openActivityTasks(Integer var1);

        public Builder openDecisionTasks(Integer var1);

        public Builder openTimers(Integer var1);

        public Builder openChildWorkflowExecutions(Integer var1);

        public Builder openLambdaFunctions(Integer var1);
    }
}

