/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSimulationResponse extends SimSpaceWeaverResponse implements
        ToCopyableBuilder<DescribeSimulationResponse.Builder, DescribeSimulationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeSimulationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeSimulationResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeSimulationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionId").getter(getter(DescribeSimulationResponse::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()).build();

    private static final SdkField<LiveSimulationState> LIVE_SIMULATION_STATE_FIELD = SdkField
            .<LiveSimulationState> builder(MarshallingType.SDK_POJO).memberName("LiveSimulationState")
            .getter(getter(DescribeSimulationResponse::liveSimulationState)).setter(setter(Builder::liveSimulationState))
            .constructor(LiveSimulationState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LiveSimulationState").build())
            .build();

    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("LoggingConfiguration")
            .getter(getter(DescribeSimulationResponse::loggingConfiguration)).setter(setter(Builder::loggingConfiguration))
            .constructor(LoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build())
            .build();

    private static final SdkField<String> MAXIMUM_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaximumDuration").getter(getter(DescribeSimulationResponse::maximumDuration))
            .setter(setter(Builder::maximumDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumDuration").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeSimulationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeSimulationResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> SCHEMA_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaError").getter(getter(DescribeSimulationResponse::schemaError))
            .setter(setter(Builder::schemaError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaError").build()).build();

    private static final SdkField<S3Location> SCHEMA_S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaS3Location").getter(getter(DescribeSimulationResponse::schemaS3Location))
            .setter(setter(Builder::schemaS3Location)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaS3Location").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeSimulationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetStatus").getter(getter(DescribeSimulationResponse::targetStatusAsString))
            .setter(setter(Builder::targetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, DESCRIPTION_FIELD, EXECUTION_ID_FIELD, LIVE_SIMULATION_STATE_FIELD, LOGGING_CONFIGURATION_FIELD,
            MAXIMUM_DURATION_FIELD, NAME_FIELD, ROLE_ARN_FIELD, SCHEMA_ERROR_FIELD, SCHEMA_S3_LOCATION_FIELD, STATUS_FIELD,
            TARGET_STATUS_FIELD));

    private final String arn;

    private final Instant creationTime;

    private final String description;

    private final String executionId;

    private final LiveSimulationState liveSimulationState;

    private final LoggingConfiguration loggingConfiguration;

    private final String maximumDuration;

    private final String name;

    private final String roleArn;

    private final String schemaError;

    private final S3Location schemaS3Location;

    private final String status;

    private final String targetStatus;

    private DescribeSimulationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.executionId = builder.executionId;
        this.liveSimulationState = builder.liveSimulationState;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.maximumDuration = builder.maximumDuration;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.schemaError = builder.schemaError;
        this.schemaS3Location = builder.schemaS3Location;
        this.status = builder.status;
        this.targetStatus = builder.targetStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the simulation. For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the simulation. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time when the simulation was created, expressed as the number of seconds and milliseconds in UTC since the
     * Unix epoch (0:0:0.000, January 1, 1970).
     * </p>
     * 
     * @return The time when the simulation was created, expressed as the number of seconds and milliseconds in UTC
     *         since the Unix epoch (0:0:0.000, January 1, 1970).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The description of the simulation.
     * </p>
     * 
     * @return The description of the simulation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A universally unique identifier (UUID) for this simulation.
     * </p>
     * 
     * @return A universally unique identifier (UUID) for this simulation.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * A collection of additional state information, such as domain and clock configuration.
     * </p>
     * 
     * @return A collection of additional state information, such as domain and clock configuration.
     */
    public final LiveSimulationState liveSimulationState() {
        return liveSimulationState;
    }

    /**
     * <p>
     * Settings that control how SimSpace Weaver handles your simulation log data.
     * </p>
     * 
     * @return Settings that control how SimSpace Weaver handles your simulation log data.
     */
    public final LoggingConfiguration loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * <p>
     * The maximum running time of the simulation, specified as a number of months (m or M), hours (h or H), or days (d
     * or D). The simulation stops when it reaches this limit.
     * </p>
     * 
     * @return The maximum running time of the simulation, specified as a number of months (m or M), hours (h or H), or
     *         days (d or D). The simulation stops when it reaches this limit.
     */
    public final String maximumDuration() {
        return maximumDuration;
    }

    /**
     * <p>
     * The name of the simulation.
     * </p>
     * 
     * @return The name of the simulation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation assumes to
     * perform actions. For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For more information about IAM roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>Identity and Access
     * Management User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation
     *         assumes to perform actions. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For more information about IAM roles, see
     *         <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>Identity
     *         and Access Management User Guide</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * An error message that SimSpace Weaver returns only if there is a problem with the simulation schema.
     * </p>
     * 
     * @return An error message that SimSpace Weaver returns only if there is a problem with the simulation schema.
     */
    public final String schemaError() {
        return schemaError;
    }

    /**
     * <p>
     * The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information about
     * Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"> <i>Amazon Simple
     * Storage Service User Guide</i> </a>.
     * </p>
     * 
     * @return The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information
     *         about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html">
     *         <i>Amazon Simple Storage Service User Guide</i> </a>.
     */
    public final S3Location schemaS3Location() {
        return schemaS3Location;
    }

    /**
     * <p>
     * The current lifecycle state of the simulation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current lifecycle state of the simulation.
     * @see SimulationStatus
     */
    public final SimulationStatus status() {
        return SimulationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current lifecycle state of the simulation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current lifecycle state of the simulation.
     * @see SimulationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The desired lifecycle state of the simulation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link SimulationTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The desired lifecycle state of the simulation.
     * @see SimulationTargetStatus
     */
    public final SimulationTargetStatus targetStatus() {
        return SimulationTargetStatus.fromValue(targetStatus);
    }

    /**
     * <p>
     * The desired lifecycle state of the simulation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link SimulationTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The desired lifecycle state of the simulation.
     * @see SimulationTargetStatus
     */
    public final String targetStatusAsString() {
        return targetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(liveSimulationState());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(maximumDuration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaError());
        hashCode = 31 * hashCode + Objects.hashCode(schemaS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSimulationResponse)) {
            return false;
        }
        DescribeSimulationResponse other = (DescribeSimulationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(description(), other.description()) && Objects.equals(executionId(), other.executionId())
                && Objects.equals(liveSimulationState(), other.liveSimulationState())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(maximumDuration(), other.maximumDuration()) && Objects.equals(name(), other.name())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(schemaError(), other.schemaError())
                && Objects.equals(schemaS3Location(), other.schemaS3Location())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(targetStatusAsString(), other.targetStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSimulationResponse").add("Arn", arn()).add("CreationTime", creationTime())
                .add("Description", description()).add("ExecutionId", executionId())
                .add("LiveSimulationState", liveSimulationState()).add("LoggingConfiguration", loggingConfiguration())
                .add("MaximumDuration", maximumDuration()).add("Name", name()).add("RoleArn", roleArn())
                .add("SchemaError", schemaError()).add("SchemaS3Location", schemaS3Location()).add("Status", statusAsString())
                .add("TargetStatus", targetStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ExecutionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "LiveSimulationState":
            return Optional.ofNullable(clazz.cast(liveSimulationState()));
        case "LoggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "MaximumDuration":
            return Optional.ofNullable(clazz.cast(maximumDuration()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SchemaError":
            return Optional.ofNullable(clazz.cast(schemaError()));
        case "SchemaS3Location":
            return Optional.ofNullable(clazz.cast(schemaS3Location()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TargetStatus":
            return Optional.ofNullable(clazz.cast(targetStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSimulationResponse, T> g) {
        return obj -> g.apply((DescribeSimulationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SimSpaceWeaverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSimulationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the simulation. For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the simulation. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time when the simulation was created, expressed as the number of seconds and milliseconds in UTC since
         * the Unix epoch (0:0:0.000, January 1, 1970).
         * </p>
         * 
         * @param creationTime
         *        The time when the simulation was created, expressed as the number of seconds and milliseconds in UTC
         *        since the Unix epoch (0:0:0.000, January 1, 1970).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The description of the simulation.
         * </p>
         * 
         * @param description
         *        The description of the simulation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A universally unique identifier (UUID) for this simulation.
         * </p>
         * 
         * @param executionId
         *        A universally unique identifier (UUID) for this simulation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * A collection of additional state information, such as domain and clock configuration.
         * </p>
         * 
         * @param liveSimulationState
         *        A collection of additional state information, such as domain and clock configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder liveSimulationState(LiveSimulationState liveSimulationState);

        /**
         * <p>
         * A collection of additional state information, such as domain and clock configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LiveSimulationState.Builder} avoiding the
         * need to create one manually via {@link LiveSimulationState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LiveSimulationState.Builder#build()} is called immediately and
         * its result is passed to {@link #liveSimulationState(LiveSimulationState)}.
         * 
         * @param liveSimulationState
         *        a consumer that will call methods on {@link LiveSimulationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #liveSimulationState(LiveSimulationState)
         */
        default Builder liveSimulationState(Consumer<LiveSimulationState.Builder> liveSimulationState) {
            return liveSimulationState(LiveSimulationState.builder().applyMutation(liveSimulationState).build());
        }

        /**
         * <p>
         * Settings that control how SimSpace Weaver handles your simulation log data.
         * </p>
         * 
         * @param loggingConfiguration
         *        Settings that control how SimSpace Weaver handles your simulation log data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfiguration loggingConfiguration);

        /**
         * <p>
         * Settings that control how SimSpace Weaver handles your simulation log data.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfiguration.Builder} avoiding
         * the need to create one manually via {@link LoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingConfiguration(LoggingConfiguration)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfiguration)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfiguration.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * The maximum running time of the simulation, specified as a number of months (m or M), hours (h or H), or days
         * (d or D). The simulation stops when it reaches this limit.
         * </p>
         * 
         * @param maximumDuration
         *        The maximum running time of the simulation, specified as a number of months (m or M), hours (h or H),
         *        or days (d or D). The simulation stops when it reaches this limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumDuration(String maximumDuration);

        /**
         * <p>
         * The name of the simulation.
         * </p>
         * 
         * @param name
         *        The name of the simulation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation assumes
         * to perform actions. For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For more information about IAM roles, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>Identity and
         * Access Management User Guide</i>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation
         *        assumes to perform actions. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For more information about IAM
         *        roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in
         *        the <i>Identity and Access Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An error message that SimSpace Weaver returns only if there is a problem with the simulation schema.
         * </p>
         * 
         * @param schemaError
         *        An error message that SimSpace Weaver returns only if there is a problem with the simulation schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaError(String schemaError);

        /**
         * <p>
         * The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information
         * about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html">
         * <i>Amazon Simple Storage Service User Guide</i> </a>.
         * </p>
         * 
         * @param schemaS3Location
         *        The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more
         *        information about Amazon S3, see the <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html"> <i>Amazon Simple Storage
         *        Service User Guide</i> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaS3Location(S3Location schemaS3Location);

        /**
         * <p>
         * The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information
         * about Amazon S3, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html">
         * <i>Amazon Simple Storage Service User Guide</i> </a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #schemaS3Location(S3Location)}.
         * 
         * @param schemaS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaS3Location(S3Location)
         */
        default Builder schemaS3Location(Consumer<S3Location.Builder> schemaS3Location) {
            return schemaS3Location(S3Location.builder().applyMutation(schemaS3Location).build());
        }

        /**
         * <p>
         * The current lifecycle state of the simulation.
         * </p>
         * 
         * @param status
         *        The current lifecycle state of the simulation.
         * @see SimulationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current lifecycle state of the simulation.
         * </p>
         * 
         * @param status
         *        The current lifecycle state of the simulation.
         * @see SimulationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationStatus
         */
        Builder status(SimulationStatus status);

        /**
         * <p>
         * The desired lifecycle state of the simulation.
         * </p>
         * 
         * @param targetStatus
         *        The desired lifecycle state of the simulation.
         * @see SimulationTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationTargetStatus
         */
        Builder targetStatus(String targetStatus);

        /**
         * <p>
         * The desired lifecycle state of the simulation.
         * </p>
         * 
         * @param targetStatus
         *        The desired lifecycle state of the simulation.
         * @see SimulationTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationTargetStatus
         */
        Builder targetStatus(SimulationTargetStatus targetStatus);
    }

    static final class BuilderImpl extends SimSpaceWeaverResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private String description;

        private String executionId;

        private LiveSimulationState liveSimulationState;

        private LoggingConfiguration loggingConfiguration;

        private String maximumDuration;

        private String name;

        private String roleArn;

        private String schemaError;

        private S3Location schemaS3Location;

        private String status;

        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSimulationResponse model) {
            super(model);
            arn(model.arn);
            creationTime(model.creationTime);
            description(model.description);
            executionId(model.executionId);
            liveSimulationState(model.liveSimulationState);
            loggingConfiguration(model.loggingConfiguration);
            maximumDuration(model.maximumDuration);
            name(model.name);
            roleArn(model.roleArn);
            schemaError(model.schemaError);
            schemaS3Location(model.schemaS3Location);
            status(model.status);
            targetStatus(model.targetStatus);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final LiveSimulationState.Builder getLiveSimulationState() {
            return liveSimulationState != null ? liveSimulationState.toBuilder() : null;
        }

        public final void setLiveSimulationState(LiveSimulationState.BuilderImpl liveSimulationState) {
            this.liveSimulationState = liveSimulationState != null ? liveSimulationState.build() : null;
        }

        @Override
        public final Builder liveSimulationState(LiveSimulationState liveSimulationState) {
            this.liveSimulationState = liveSimulationState;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final String getMaximumDuration() {
            return maximumDuration;
        }

        public final void setMaximumDuration(String maximumDuration) {
            this.maximumDuration = maximumDuration;
        }

        @Override
        public final Builder maximumDuration(String maximumDuration) {
            this.maximumDuration = maximumDuration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSchemaError() {
            return schemaError;
        }

        public final void setSchemaError(String schemaError) {
            this.schemaError = schemaError;
        }

        @Override
        public final Builder schemaError(String schemaError) {
            this.schemaError = schemaError;
            return this;
        }

        public final S3Location.Builder getSchemaS3Location() {
            return schemaS3Location != null ? schemaS3Location.toBuilder() : null;
        }

        public final void setSchemaS3Location(S3Location.BuilderImpl schemaS3Location) {
            this.schemaS3Location = schemaS3Location != null ? schemaS3Location.build() : null;
        }

        @Override
        public final Builder schemaS3Location(S3Location schemaS3Location) {
            this.schemaS3Location = schemaS3Location;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetStatus() {
            return targetStatus;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(SimulationTargetStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        @Override
        public DescribeSimulationResponse build() {
            return new DescribeSimulationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
