/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSimulationsResponse extends SimSpaceWeaverResponse implements
        ToCopyableBuilder<ListSimulationsResponse.Builder, ListSimulationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSimulationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<SimulationMetadata>> SIMULATIONS_FIELD = SdkField
            .<List<SimulationMetadata>> builder(MarshallingType.LIST)
            .memberName("Simulations")
            .getter(getter(ListSimulationsResponse::simulations))
            .setter(setter(Builder::simulations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Simulations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimulationMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimulationMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SIMULATIONS_FIELD));

    private final String nextToken;

    private final List<SimulationMetadata> simulations;

    private ListSimulationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.simulations = builder.simulations;
    }

    /**
     * <p>
     * If SimSpace Weaver returns <code>nextToken</code>, there are more results available. The value of
     * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation
     * again using the returned token. Keep all other arguments unchanged. If no results remain, <code>nextToken</code>
     * is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide a token that isn't
     * valid, you receive an <i>HTTP 400 ValidationException</i> error.
     * </p>
     * 
     * @return If SimSpace Weaver returns <code>nextToken</code>, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
     *         operation again using the returned token. Keep all other arguments unchanged. If no results remain,
     *         <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
     *         provide a token that isn't valid, you receive an <i>HTTP 400 ValidationException</i> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Simulations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSimulations() {
        return simulations != null && !(simulations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of simulations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSimulations} method.
     * </p>
     * 
     * @return The list of simulations.
     */
    public final List<SimulationMetadata> simulations() {
        return simulations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSimulations() ? simulations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSimulationsResponse)) {
            return false;
        }
        ListSimulationsResponse other = (ListSimulationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSimulations() == other.hasSimulations()
                && Objects.equals(simulations(), other.simulations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSimulationsResponse").add("NextToken", nextToken())
                .add("Simulations", hasSimulations() ? simulations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Simulations":
            return Optional.ofNullable(clazz.cast(simulations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSimulationsResponse, T> g) {
        return obj -> g.apply((ListSimulationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SimSpaceWeaverResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSimulationsResponse> {
        /**
         * <p>
         * If SimSpace Weaver returns <code>nextToken</code>, there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         * operation again using the returned token. Keep all other arguments unchanged. If no results remain,
         * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
         * provide a token that isn't valid, you receive an <i>HTTP 400 ValidationException</i> error.
         * </p>
         * 
         * @param nextToken
         *        If SimSpace Weaver returns <code>nextToken</code>, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         *        operation again using the returned token. Keep all other arguments unchanged. If no results remain,
         *        <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If
         *        you provide a token that isn't valid, you receive an <i>HTTP 400 ValidationException</i> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of simulations.
         * </p>
         * 
         * @param simulations
         *        The list of simulations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulations(Collection<SimulationMetadata> simulations);

        /**
         * <p>
         * The list of simulations.
         * </p>
         * 
         * @param simulations
         *        The list of simulations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulations(SimulationMetadata... simulations);

        /**
         * <p>
         * The list of simulations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.simspaceweaver.model.SimulationMetadata.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.simspaceweaver.model.SimulationMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.simspaceweaver.model.SimulationMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #simulations(List<SimulationMetadata>)}.
         * 
         * @param simulations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.simspaceweaver.model.SimulationMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simulations(java.util.Collection<SimulationMetadata>)
         */
        Builder simulations(Consumer<SimulationMetadata.Builder>... simulations);
    }

    static final class BuilderImpl extends SimSpaceWeaverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SimulationMetadata> simulations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSimulationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            simulations(model.simulations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SimulationMetadata.Builder> getSimulations() {
            List<SimulationMetadata.Builder> result = SimulationListCopier.copyToBuilder(this.simulations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSimulations(Collection<SimulationMetadata.BuilderImpl> simulations) {
            this.simulations = SimulationListCopier.copyFromBuilder(simulations);
        }

        @Override
        public final Builder simulations(Collection<SimulationMetadata> simulations) {
            this.simulations = SimulationListCopier.copy(simulations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulations(SimulationMetadata... simulations) {
            simulations(Arrays.asList(simulations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulations(Consumer<SimulationMetadata.Builder>... simulations) {
            simulations(Stream.of(simulations).map(c -> SimulationMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSimulationsResponse build() {
            return new ListSimulationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
