/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.simspaceweaver.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.simspaceweaver.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.simspaceweaver.model.DeleteAppRequest;
import software.amazon.awssdk.services.simspaceweaver.model.DeleteAppResponse;
import software.amazon.awssdk.services.simspaceweaver.model.DeleteSimulationRequest;
import software.amazon.awssdk.services.simspaceweaver.model.DeleteSimulationResponse;
import software.amazon.awssdk.services.simspaceweaver.model.DescribeAppRequest;
import software.amazon.awssdk.services.simspaceweaver.model.DescribeAppResponse;
import software.amazon.awssdk.services.simspaceweaver.model.DescribeSimulationRequest;
import software.amazon.awssdk.services.simspaceweaver.model.DescribeSimulationResponse;
import software.amazon.awssdk.services.simspaceweaver.model.ListAppsRequest;
import software.amazon.awssdk.services.simspaceweaver.model.ListAppsResponse;
import software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsRequest;
import software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsResponse;
import software.amazon.awssdk.services.simspaceweaver.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.simspaceweaver.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.simspaceweaver.model.StartAppRequest;
import software.amazon.awssdk.services.simspaceweaver.model.StartAppResponse;
import software.amazon.awssdk.services.simspaceweaver.model.StartClockRequest;
import software.amazon.awssdk.services.simspaceweaver.model.StartClockResponse;
import software.amazon.awssdk.services.simspaceweaver.model.StartSimulationRequest;
import software.amazon.awssdk.services.simspaceweaver.model.StartSimulationResponse;
import software.amazon.awssdk.services.simspaceweaver.model.StopAppRequest;
import software.amazon.awssdk.services.simspaceweaver.model.StopAppResponse;
import software.amazon.awssdk.services.simspaceweaver.model.StopClockRequest;
import software.amazon.awssdk.services.simspaceweaver.model.StopClockResponse;
import software.amazon.awssdk.services.simspaceweaver.model.StopSimulationRequest;
import software.amazon.awssdk.services.simspaceweaver.model.StopSimulationResponse;
import software.amazon.awssdk.services.simspaceweaver.model.TagResourceRequest;
import software.amazon.awssdk.services.simspaceweaver.model.TagResourceResponse;
import software.amazon.awssdk.services.simspaceweaver.model.UntagResourceRequest;
import software.amazon.awssdk.services.simspaceweaver.model.UntagResourceResponse;
import software.amazon.awssdk.services.simspaceweaver.paginators.ListAppsPublisher;
import software.amazon.awssdk.services.simspaceweaver.paginators.ListSimulationsPublisher;

/**
 * Service client for accessing AWS SimSpace Weaver asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * SimSpace Weaver (SimSpace Weaver) is a managed service that you can use to build and operate large-scale spatial
 * simulations in the Amazon Web Services Cloud. For example, you can create a digital twin of a city, crowd simulations
 * with millions of people and objects, and massively multiplayer games with hundreds of thousands of connected players.
 * For more information about SimSpace Weaver, see the <i> <a
 * href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/">SimSpace Weaver User Guide</a> </i>.
 * </p>
 * <p>
 * This API reference describes the API operations and data types that you can use to communicate directly with SimSpace
 * Weaver.
 * </p>
 * <p>
 * SimSpace Weaver also provides the SimSpace Weaver app SDK, which you use for app development. The SimSpace Weaver app
 * SDK API reference is included in the SimSpace Weaver app SDK documentation. This documentation is part of the
 * SimSpace Weaver app SDK distributable package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SimSpaceWeaverAsyncClient extends AwsClient {
    String SERVICE_NAME = "simspaceweaver";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "simspaceweaver";

    /**
     * <p>
     * Creates a snapshot of the specified simulation. A snapshot is a file that contains simulation state data at a
     * specific time. The state data saved in a snapshot includes entity data from the State Fabric, the simulation
     * configuration specified in the schema, and the clock tick number. You can use the snapshot to initialize a new
     * simulation. For more information about snapshots, see <a
     * href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html">Snapshots</a> in
     * the <i>SimSpace Weaver User Guide</i>.
     * </p>
     * <p>
     * You specify a <code>Destination</code> when you create a snapshot. The <code>Destination</code> is the name of an
     * Amazon S3 bucket and an optional <code>ObjectKeyPrefix</code>. The <code>ObjectKeyPrefix</code> is usually the
     * name of a folder in the bucket. SimSpace Weaver creates a <code>snapshot</code> folder inside the
     * <code>Destination</code> and places the snapshot file there.
     * </p>
     * <p>
     * The snapshot file is an Amazon S3 object. It has an object key with the form:
     * <code> <i>object-key-prefix</i>/snapshot/<i>simulation-name</i>-<i>YYMMdd</i>-<i>HHmm</i>-<i>ss</i>.zip</code>,
     * where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code> <i>YY</i> </code> is the 2-digit year
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>MM</i> </code> is the 2-digit month
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>dd</i> </code> is the 2-digit day of the month
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>HH</i> </code> is the 2-digit hour (24-hour clock)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>mm</i> </code> is the 2-digit minutes
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>ss</i> </code> is the 2-digit seconds
     * </p>
     * </li>
     * </ul>
     *
     * @param createSnapshotRequest
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/CreateSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of the specified simulation. A snapshot is a file that contains simulation state data at a
     * specific time. The state data saved in a snapshot includes entity data from the State Fabric, the simulation
     * configuration specified in the schema, and the clock tick number. You can use the snapshot to initialize a new
     * simulation. For more information about snapshots, see <a
     * href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html">Snapshots</a> in
     * the <i>SimSpace Weaver User Guide</i>.
     * </p>
     * <p>
     * You specify a <code>Destination</code> when you create a snapshot. The <code>Destination</code> is the name of an
     * Amazon S3 bucket and an optional <code>ObjectKeyPrefix</code>. The <code>ObjectKeyPrefix</code> is usually the
     * name of a folder in the bucket. SimSpace Weaver creates a <code>snapshot</code> folder inside the
     * <code>Destination</code> and places the snapshot file there.
     * </p>
     * <p>
     * The snapshot file is an Amazon S3 object. It has an object key with the form:
     * <code> <i>object-key-prefix</i>/snapshot/<i>simulation-name</i>-<i>YYMMdd</i>-<i>HHmm</i>-<i>ss</i>.zip</code>,
     * where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code> <i>YY</i> </code> is the 2-digit year
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>MM</i> </code> is the 2-digit month
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>dd</i> </code> is the 2-digit day of the month
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>HH</i> </code> is the 2-digit hour (24-hour clock)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>mm</i> </code> is the 2-digit minutes
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>ss</i> </code> is the 2-digit seconds
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/CreateSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest) {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes the instance of the given custom app.
     * </p>
     *
     * @param deleteAppRequest
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAppResponse> deleteApp(DeleteAppRequest deleteAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the instance of the given custom app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAppRequest#builder()}
     * </p>
     *
     * @param deleteAppRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAppResponse> deleteApp(Consumer<DeleteAppRequest.Builder> deleteAppRequest) {
        return deleteApp(DeleteAppRequest.builder().applyMutation(deleteAppRequest).build());
    }

    /**
     * <p>
     * Deletes all SimSpace Weaver resources assigned to the given simulation.
     * </p>
     * <note>
     * <p>
     * Your simulation uses resources in other Amazon Web Services. This API operation doesn't delete resources in other
     * Amazon Web Services.
     * </p>
     * </note>
     *
     * @param deleteSimulationRequest
     * @return A Java Future containing the result of the DeleteSimulation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.DeleteSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DeleteSimulation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSimulationResponse> deleteSimulation(DeleteSimulationRequest deleteSimulationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all SimSpace Weaver resources assigned to the given simulation.
     * </p>
     * <note>
     * <p>
     * Your simulation uses resources in other Amazon Web Services. This API operation doesn't delete resources in other
     * Amazon Web Services.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSimulationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSimulationRequest#builder()}
     * </p>
     *
     * @param deleteSimulationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSimulationInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSimulation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.DeleteSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DeleteSimulation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSimulationResponse> deleteSimulation(
            Consumer<DeleteSimulationRequest.Builder> deleteSimulationRequest) {
        return deleteSimulation(DeleteSimulationRequest.builder().applyMutation(deleteSimulationRequest).build());
    }

    /**
     * <p>
     * Returns the state of the given custom app.
     * </p>
     *
     * @param describeAppRequest
     * @return A Java Future containing the result of the DescribeApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DescribeApp" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAppResponse> describeApp(DescribeAppRequest describeAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the state of the given custom app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAppRequest#builder()}
     * </p>
     *
     * @param describeAppRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAppInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DescribeApp" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAppResponse> describeApp(Consumer<DescribeAppRequest.Builder> describeAppRequest) {
        return describeApp(DescribeAppRequest.builder().applyMutation(describeAppRequest).build());
    }

    /**
     * <p>
     * Returns the current state of the given simulation.
     * </p>
     *
     * @param describeSimulationRequest
     * @return A Java Future containing the result of the DescribeSimulation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.DescribeSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DescribeSimulation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSimulationResponse> describeSimulation(DescribeSimulationRequest describeSimulationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current state of the given simulation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSimulationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSimulationRequest#builder()}
     * </p>
     *
     * @param describeSimulationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSimulationInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeSimulation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.DescribeSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DescribeSimulation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSimulationResponse> describeSimulation(
            Consumer<DescribeSimulationRequest.Builder> describeSimulationRequest) {
        return describeSimulation(DescribeSimulationRequest.builder().applyMutation(describeSimulationRequest).build());
    }

    /**
     * <p>
     * Lists all custom apps or service apps for the given simulation and domain.
     * </p>
     *
     * @param listAppsRequest
     * @return A Java Future containing the result of the ListApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAppsResponse> listApps(ListAppsRequest listAppsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all custom apps or service apps for the given simulation and domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppsRequest#builder()}
     * </p>
     *
     * @param listAppsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAppsResponse> listApps(Consumer<ListAppsRequest.Builder> listAppsRequest) {
        return listApps(ListAppsRequest.builder().applyMutation(listAppsRequest).build());
    }

    /**
     * <p>
     * Lists all custom apps or service apps for the given simulation and domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApps(software.amazon.awssdk.services.simspaceweaver.model.ListAppsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListAppsPublisher publisher = client.listAppsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListAppsPublisher publisher = client.listAppsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.simspaceweaver.model.ListAppsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.simspaceweaver.model.ListAppsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApps(software.amazon.awssdk.services.simspaceweaver.model.ListAppsRequest)} operation.</b>
     * </p>
     *
     * @param listAppsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsPublisher listAppsPaginator(ListAppsRequest listAppsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all custom apps or service apps for the given simulation and domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApps(software.amazon.awssdk.services.simspaceweaver.model.ListAppsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListAppsPublisher publisher = client.listAppsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListAppsPublisher publisher = client.listAppsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.simspaceweaver.model.ListAppsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.simspaceweaver.model.ListAppsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApps(software.amazon.awssdk.services.simspaceweaver.model.ListAppsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppsRequest#builder()}
     * </p>
     *
     * @param listAppsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsPublisher listAppsPaginator(Consumer<ListAppsRequest.Builder> listAppsRequest) {
        return listAppsPaginator(ListAppsRequest.builder().applyMutation(listAppsRequest).build());
    }

    /**
     * <p>
     * Lists the SimSpace Weaver simulations in the Amazon Web Services account used to make the API call.
     * </p>
     *
     * @param listSimulationsRequest
     * @return A Java Future containing the result of the ListSimulations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.ListSimulations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListSimulations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSimulationsResponse> listSimulations(ListSimulationsRequest listSimulationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SimSpace Weaver simulations in the Amazon Web Services account used to make the API call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSimulationsRequest#builder()}
     * </p>
     *
     * @param listSimulationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListSimulations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.ListSimulations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListSimulations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSimulationsResponse> listSimulations(
            Consumer<ListSimulationsRequest.Builder> listSimulationsRequest) {
        return listSimulations(ListSimulationsRequest.builder().applyMutation(listSimulationsRequest).build());
    }

    /**
     * <p>
     * Lists the SimSpace Weaver simulations in the Amazon Web Services account used to make the API call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulations(software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListSimulationsPublisher publisher = client.listSimulationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListSimulationsPublisher publisher = client.listSimulationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulations(software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSimulationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.ListSimulations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListSimulations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationsPublisher listSimulationsPaginator(ListSimulationsRequest listSimulationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SimSpace Weaver simulations in the Amazon Web Services account used to make the API call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulations(software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListSimulationsPublisher publisher = client.listSimulationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.simspaceweaver.paginators.ListSimulationsPublisher publisher = client.listSimulationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulations(software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSimulationsRequest#builder()}
     * </p>
     *
     * @param listSimulationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.ListSimulations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListSimulations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationsPublisher listSimulationsPaginator(Consumer<ListSimulationsRequest.Builder> listSimulationsRequest) {
        return listSimulationsPaginator(ListSimulationsRequest.builder().applyMutation(listSimulationsRequest).build());
    }

    /**
     * <p>
     * Lists all tags on a SimSpace Weaver resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on a SimSpace Weaver resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts a custom app with the configuration specified in the simulation schema.
     * </p>
     *
     * @param startAppRequest
     * @return A Java Future containing the result of the StartApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.StartApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartAppResponse> startApp(StartAppRequest startAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a custom app with the configuration specified in the simulation schema.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAppRequest.Builder} avoiding the need to
     * create one manually via {@link StartAppRequest#builder()}
     * </p>
     *
     * @param startAppRequest
     *        A {@link Consumer} that will call methods on {@link StartAppInput.Builder} to create a request.
     * @return A Java Future containing the result of the StartApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.StartApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartAppResponse> startApp(Consumer<StartAppRequest.Builder> startAppRequest) {
        return startApp(StartAppRequest.builder().applyMutation(startAppRequest).build());
    }

    /**
     * <p>
     * Starts the simulation clock.
     * </p>
     *
     * @param startClockRequest
     * @return A Java Future containing the result of the StartClock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.StartClock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartClock" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartClockResponse> startClock(StartClockRequest startClockRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the simulation clock.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartClockRequest.Builder} avoiding the need to
     * create one manually via {@link StartClockRequest#builder()}
     * </p>
     *
     * @param startClockRequest
     *        A {@link Consumer} that will call methods on {@link StartClockInput.Builder} to create a request.
     * @return A Java Future containing the result of the StartClock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.StartClock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartClock" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartClockResponse> startClock(Consumer<StartClockRequest.Builder> startClockRequest) {
        return startClock(StartClockRequest.builder().applyMutation(startClockRequest).build());
    }

    /**
     * <p>
     * Starts a simulation with the given name. You must choose to start your simulation from a schema or from a
     * snapshot. For more information about the schema, see the <a
     * href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/schema-reference.html">schema reference</a> in
     * the <i>SimSpace Weaver User Guide</i>. For more information about snapshots, see <a
     * href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html">Snapshots</a> in
     * the <i>SimSpace Weaver User Guide</i>.
     * </p>
     *
     * @param startSimulationRequest
     * @return A Java Future containing the result of the StartSimulation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.StartSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartSimulation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSimulationResponse> startSimulation(StartSimulationRequest startSimulationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a simulation with the given name. You must choose to start your simulation from a schema or from a
     * snapshot. For more information about the schema, see the <a
     * href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/schema-reference.html">schema reference</a> in
     * the <i>SimSpace Weaver User Guide</i>. For more information about snapshots, see <a
     * href="https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html">Snapshots</a> in
     * the <i>SimSpace Weaver User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSimulationRequest.Builder} avoiding the need
     * to create one manually via {@link StartSimulationRequest#builder()}
     * </p>
     *
     * @param startSimulationRequest
     *        A {@link Consumer} that will call methods on {@link StartSimulationInput.Builder} to create a request.
     * @return A Java Future containing the result of the StartSimulation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.StartSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartSimulation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSimulationResponse> startSimulation(
            Consumer<StartSimulationRequest.Builder> startSimulationRequest) {
        return startSimulation(StartSimulationRequest.builder().applyMutation(startSimulationRequest).build());
    }

    /**
     * <p>
     * Stops the given custom app and shuts down all of its allocated compute resources.
     * </p>
     *
     * @param stopAppRequest
     * @return A Java Future containing the result of the StopApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.StopApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopAppResponse> stopApp(StopAppRequest stopAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the given custom app and shuts down all of its allocated compute resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopAppRequest.Builder} avoiding the need to create
     * one manually via {@link StopAppRequest#builder()}
     * </p>
     *
     * @param stopAppRequest
     *        A {@link Consumer} that will call methods on {@link StopAppInput.Builder} to create a request.
     * @return A Java Future containing the result of the StopApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.StopApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopAppResponse> stopApp(Consumer<StopAppRequest.Builder> stopAppRequest) {
        return stopApp(StopAppRequest.builder().applyMutation(stopAppRequest).build());
    }

    /**
     * <p>
     * Stops the simulation clock.
     * </p>
     *
     * @param stopClockRequest
     * @return A Java Future containing the result of the StopClock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.StopClock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopClock" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopClockResponse> stopClock(StopClockRequest stopClockRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the simulation clock.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopClockRequest.Builder} avoiding the need to
     * create one manually via {@link StopClockRequest#builder()}
     * </p>
     *
     * @param stopClockRequest
     *        A {@link Consumer} that will call methods on {@link StopClockInput.Builder} to create a request.
     * @return A Java Future containing the result of the StopClock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.StopClock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopClock" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopClockResponse> stopClock(Consumer<StopClockRequest.Builder> stopClockRequest) {
        return stopClock(StopClockRequest.builder().applyMutation(stopClockRequest).build());
    }

    /**
     * <p>
     * Stops the given simulation.
     * </p>
     * <important>
     * <p>
     * You can't restart a simulation after you stop it. If you want to restart a simulation, then you must stop it,
     * delete it, and start a new instance of it.
     * </p>
     * </important>
     *
     * @param stopSimulationRequest
     * @return A Java Future containing the result of the StopSimulation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.StopSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopSimulation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopSimulationResponse> stopSimulation(StopSimulationRequest stopSimulationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the given simulation.
     * </p>
     * <important>
     * <p>
     * You can't restart a simulation after you stop it. If you want to restart a simulation, then you must stop it,
     * delete it, and start a new instance of it.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopSimulationRequest.Builder} avoiding the need to
     * create one manually via {@link StopSimulationRequest#builder()}
     * </p>
     *
     * @param stopSimulationRequest
     *        A {@link Consumer} that will call methods on {@link StopSimulationInput.Builder} to create a request.
     * @return A Java Future containing the result of the StopSimulation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.StopSimulation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopSimulation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopSimulationResponse> stopSimulation(Consumer<StopSimulationRequest.Builder> stopSimulationRequest) {
        return stopSimulation(StopSimulationRequest.builder().applyMutation(stopSimulationRequest).build());
    }

    /**
     * <p>
     * Adds tags to a SimSpace Weaver resource. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyTagsException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a SimSpace Weaver resource. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyTagsException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a SimSpace Weaver resource. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a SimSpace Weaver resource. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SimSpaceWeaverException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample SimSpaceWeaverAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    @Override
    default SimSpaceWeaverServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SimSpaceWeaverAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SimSpaceWeaverAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SimSpaceWeaverAsyncClient}.
     */
    static SimSpaceWeaverAsyncClientBuilder builder() {
        return new DefaultSimSpaceWeaverAsyncClientBuilder();
    }
}
