/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon S3 bucket and optional folder (object key prefix) where SimSpace Weaver creates a file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Destination implements SdkPojo, Serializable, ToCopyableBuilder<S3Destination.Builder, S3Destination> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(S3Destination::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> OBJECT_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectKeyPrefix").getter(getter(S3Destination::objectKeyPrefix))
            .setter(setter(Builder::objectKeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectKeyPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            OBJECT_KEY_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String objectKeyPrefix;

    private S3Destination(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.objectKeyPrefix = builder.objectKeyPrefix;
    }

    /**
     * <p>
     * The name of an Amazon S3 bucket. For more information about buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring, and
     * working with Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * 
     * @return The name of an Amazon S3 bucket. For more information about buckets, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating,
     *         configuring, and working with Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User
     *         Guide</i>.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * A string prefix for an Amazon S3 object key. It's usually a folder name. For more information about folders in
     * Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-folders.html">Organizing
     * objects in the Amazon S3 console using folders</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * 
     * @return A string prefix for an Amazon S3 object key. It's usually a folder name. For more information about
     *         folders in Amazon S3, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-folders.html">Organizing objects in the
     *         Amazon S3 console using folders</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     */
    public final String objectKeyPrefix() {
        return objectKeyPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(objectKeyPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Destination)) {
            return false;
        }
        S3Destination other = (S3Destination) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(objectKeyPrefix(), other.objectKeyPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Destination").add("BucketName", bucketName()).add("ObjectKeyPrefix", objectKeyPrefix())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "ObjectKeyPrefix":
            return Optional.ofNullable(clazz.cast(objectKeyPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Destination, T> g) {
        return obj -> g.apply((S3Destination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Destination> {
        /**
         * <p>
         * The name of an Amazon S3 bucket. For more information about buckets, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring,
         * and working with Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User Guide</i>.
         * </p>
         * 
         * @param bucketName
         *        The name of an Amazon S3 bucket. For more information about buckets, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating,
         *        configuring, and working with Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * A string prefix for an Amazon S3 object key. It's usually a folder name. For more information about folders
         * in Amazon S3, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-folders.html">Organizing objects in the
         * Amazon S3 console using folders</a> in the <i>Amazon Simple Storage Service User Guide</i>.
         * </p>
         * 
         * @param objectKeyPrefix
         *        A string prefix for an Amazon S3 object key. It's usually a folder name. For more information about
         *        folders in Amazon S3, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-folders.html">Organizing objects in
         *        the Amazon S3 console using folders</a> in the <i>Amazon Simple Storage Service User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectKeyPrefix(String objectKeyPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String objectKeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Destination model) {
            bucketName(model.bucketName);
            objectKeyPrefix(model.objectKeyPrefix);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getObjectKeyPrefix() {
            return objectKeyPrefix;
        }

        public final void setObjectKeyPrefix(String objectKeyPrefix) {
            this.objectKeyPrefix = objectKeyPrefix;
        }

        @Override
        public final Builder objectKeyPrefix(String objectKeyPrefix) {
            this.objectKeyPrefix = objectKeyPrefix;
            return this;
        }

        @Override
        public S3Destination build() {
            return new S3Destination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
