/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppResponse extends SimSpaceWeaverResponse implements
        ToCopyableBuilder<DescribeAppResponse.Builder, DescribeAppResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeAppResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(DescribeAppResponse::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<SimulationAppEndpointInfo> ENDPOINT_INFO_FIELD = SdkField
            .<SimulationAppEndpointInfo> builder(MarshallingType.SDK_POJO).memberName("EndpointInfo")
            .getter(getter(DescribeAppResponse::endpointInfo)).setter(setter(Builder::endpointInfo))
            .constructor(SimulationAppEndpointInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointInfo").build()).build();

    private static final SdkField<LaunchOverrides> LAUNCH_OVERRIDES_FIELD = SdkField
            .<LaunchOverrides> builder(MarshallingType.SDK_POJO).memberName("LaunchOverrides")
            .getter(getter(DescribeAppResponse::launchOverrides)).setter(setter(Builder::launchOverrides))
            .constructor(LaunchOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchOverrides").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeAppResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SIMULATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Simulation").getter(getter(DescribeAppResponse::simulation)).setter(setter(Builder::simulation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Simulation").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeAppResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetStatus").getter(getter(DescribeAppResponse::targetStatusAsString))
            .setter(setter(Builder::targetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DOMAIN_FIELD, ENDPOINT_INFO_FIELD, LAUNCH_OVERRIDES_FIELD, NAME_FIELD, SIMULATION_FIELD, STATUS_FIELD,
            TARGET_STATUS_FIELD));

    private final String description;

    private final String domain;

    private final SimulationAppEndpointInfo endpointInfo;

    private final LaunchOverrides launchOverrides;

    private final String name;

    private final String simulation;

    private final String status;

    private final String targetStatus;

    private DescribeAppResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domain = builder.domain;
        this.endpointInfo = builder.endpointInfo;
        this.launchOverrides = builder.launchOverrides;
        this.name = builder.name;
        this.simulation = builder.simulation;
        this.status = builder.status;
        this.targetStatus = builder.targetStatus;
    }

    /**
     * <p>
     * The description of the app.
     * </p>
     * 
     * @return The description of the app.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the domain of the app.
     * </p>
     * 
     * @return The name of the domain of the app.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * Information about the network endpoint for the custom app. You can use the endpoint to connect to the custom app.
     * </p>
     * 
     * @return Information about the network endpoint for the custom app. You can use the endpoint to connect to the
     *         custom app.
     */
    public final SimulationAppEndpointInfo endpointInfo() {
        return endpointInfo;
    }

    /**
     * Returns the value of the LaunchOverrides property for this object.
     * 
     * @return The value of the LaunchOverrides property for this object.
     */
    public final LaunchOverrides launchOverrides() {
        return launchOverrides;
    }

    /**
     * <p>
     * The name of the app.
     * </p>
     * 
     * @return The name of the app.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the simulation of the app.
     * </p>
     * 
     * @return The name of the simulation of the app.
     */
    public final String simulation() {
        return simulation;
    }

    /**
     * <p>
     * The current lifecycle state of the custom app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationAppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current lifecycle state of the custom app.
     * @see SimulationAppStatus
     */
    public final SimulationAppStatus status() {
        return SimulationAppStatus.fromValue(status);
    }

    /**
     * <p>
     * The current lifecycle state of the custom app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationAppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current lifecycle state of the custom app.
     * @see SimulationAppStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The desired lifecycle state of the custom app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link SimulationAppTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The desired lifecycle state of the custom app.
     * @see SimulationAppTargetStatus
     */
    public final SimulationAppTargetStatus targetStatus() {
        return SimulationAppTargetStatus.fromValue(targetStatus);
    }

    /**
     * <p>
     * The desired lifecycle state of the custom app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link SimulationAppTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The desired lifecycle state of the custom app.
     * @see SimulationAppTargetStatus
     */
    public final String targetStatusAsString() {
        return targetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(endpointInfo());
        hashCode = 31 * hashCode + Objects.hashCode(launchOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(simulation());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppResponse)) {
            return false;
        }
        DescribeAppResponse other = (DescribeAppResponse) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(domain(), other.domain())
                && Objects.equals(endpointInfo(), other.endpointInfo())
                && Objects.equals(launchOverrides(), other.launchOverrides()) && Objects.equals(name(), other.name())
                && Objects.equals(simulation(), other.simulation()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(targetStatusAsString(), other.targetStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAppResponse").add("Description", description()).add("Domain", domain())
                .add("EndpointInfo", endpointInfo()).add("LaunchOverrides", launchOverrides()).add("Name", name())
                .add("Simulation", simulation()).add("Status", statusAsString()).add("TargetStatus", targetStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "EndpointInfo":
            return Optional.ofNullable(clazz.cast(endpointInfo()));
        case "LaunchOverrides":
            return Optional.ofNullable(clazz.cast(launchOverrides()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Simulation":
            return Optional.ofNullable(clazz.cast(simulation()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TargetStatus":
            return Optional.ofNullable(clazz.cast(targetStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppResponse, T> g) {
        return obj -> g.apply((DescribeAppResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SimSpaceWeaverResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAppResponse> {
        /**
         * <p>
         * The description of the app.
         * </p>
         * 
         * @param description
         *        The description of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the domain of the app.
         * </p>
         * 
         * @param domain
         *        The name of the domain of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Information about the network endpoint for the custom app. You can use the endpoint to connect to the custom
         * app.
         * </p>
         * 
         * @param endpointInfo
         *        Information about the network endpoint for the custom app. You can use the endpoint to connect to the
         *        custom app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointInfo(SimulationAppEndpointInfo endpointInfo);

        /**
         * <p>
         * Information about the network endpoint for the custom app. You can use the endpoint to connect to the custom
         * app.
         * </p>
         * This is a convenience method that creates an instance of the {@link SimulationAppEndpointInfo.Builder}
         * avoiding the need to create one manually via {@link SimulationAppEndpointInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SimulationAppEndpointInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #endpointInfo(SimulationAppEndpointInfo)}.
         * 
         * @param endpointInfo
         *        a consumer that will call methods on {@link SimulationAppEndpointInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointInfo(SimulationAppEndpointInfo)
         */
        default Builder endpointInfo(Consumer<SimulationAppEndpointInfo.Builder> endpointInfo) {
            return endpointInfo(SimulationAppEndpointInfo.builder().applyMutation(endpointInfo).build());
        }

        /**
         * Sets the value of the LaunchOverrides property for this object.
         *
         * @param launchOverrides
         *        The new value for the LaunchOverrides property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchOverrides(LaunchOverrides launchOverrides);

        /**
         * Sets the value of the LaunchOverrides property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LaunchOverrides.Builder} avoiding the
         * need to create one manually via {@link LaunchOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchOverrides.Builder#build()} is called immediately and its
         * result is passed to {@link #launchOverrides(LaunchOverrides)}.
         * 
         * @param launchOverrides
         *        a consumer that will call methods on {@link LaunchOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchOverrides(LaunchOverrides)
         */
        default Builder launchOverrides(Consumer<LaunchOverrides.Builder> launchOverrides) {
            return launchOverrides(LaunchOverrides.builder().applyMutation(launchOverrides).build());
        }

        /**
         * <p>
         * The name of the app.
         * </p>
         * 
         * @param name
         *        The name of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the simulation of the app.
         * </p>
         * 
         * @param simulation
         *        The name of the simulation of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulation(String simulation);

        /**
         * <p>
         * The current lifecycle state of the custom app.
         * </p>
         * 
         * @param status
         *        The current lifecycle state of the custom app.
         * @see SimulationAppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationAppStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current lifecycle state of the custom app.
         * </p>
         * 
         * @param status
         *        The current lifecycle state of the custom app.
         * @see SimulationAppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationAppStatus
         */
        Builder status(SimulationAppStatus status);

        /**
         * <p>
         * The desired lifecycle state of the custom app.
         * </p>
         * 
         * @param targetStatus
         *        The desired lifecycle state of the custom app.
         * @see SimulationAppTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationAppTargetStatus
         */
        Builder targetStatus(String targetStatus);

        /**
         * <p>
         * The desired lifecycle state of the custom app.
         * </p>
         * 
         * @param targetStatus
         *        The desired lifecycle state of the custom app.
         * @see SimulationAppTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationAppTargetStatus
         */
        Builder targetStatus(SimulationAppTargetStatus targetStatus);
    }

    static final class BuilderImpl extends SimSpaceWeaverResponse.BuilderImpl implements Builder {
        private String description;

        private String domain;

        private SimulationAppEndpointInfo endpointInfo;

        private LaunchOverrides launchOverrides;

        private String name;

        private String simulation;

        private String status;

        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppResponse model) {
            super(model);
            description(model.description);
            domain(model.domain);
            endpointInfo(model.endpointInfo);
            launchOverrides(model.launchOverrides);
            name(model.name);
            simulation(model.simulation);
            status(model.status);
            targetStatus(model.targetStatus);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final SimulationAppEndpointInfo.Builder getEndpointInfo() {
            return endpointInfo != null ? endpointInfo.toBuilder() : null;
        }

        public final void setEndpointInfo(SimulationAppEndpointInfo.BuilderImpl endpointInfo) {
            this.endpointInfo = endpointInfo != null ? endpointInfo.build() : null;
        }

        @Override
        public final Builder endpointInfo(SimulationAppEndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
            return this;
        }

        public final LaunchOverrides.Builder getLaunchOverrides() {
            return launchOverrides != null ? launchOverrides.toBuilder() : null;
        }

        public final void setLaunchOverrides(LaunchOverrides.BuilderImpl launchOverrides) {
            this.launchOverrides = launchOverrides != null ? launchOverrides.build() : null;
        }

        @Override
        public final Builder launchOverrides(LaunchOverrides launchOverrides) {
            this.launchOverrides = launchOverrides;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSimulation() {
            return simulation;
        }

        public final void setSimulation(String simulation) {
            this.simulation = simulation;
        }

        @Override
        public final Builder simulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationAppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetStatus() {
            return targetStatus;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(SimulationAppTargetStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        @Override
        public DescribeAppResponse build() {
            return new DescribeAppResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
