/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSnapshotRequest extends SimSpaceWeaverRequest implements
        ToCopyableBuilder<CreateSnapshotRequest.Builder, CreateSnapshotRequest> {
    private static final SdkField<S3Destination> DESTINATION_FIELD = SdkField.<S3Destination> builder(MarshallingType.SDK_POJO)
            .memberName("Destination").getter(getter(CreateSnapshotRequest::destination)).setter(setter(Builder::destination))
            .constructor(S3Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> SIMULATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Simulation").getter(getter(CreateSnapshotRequest::simulation)).setter(setter(Builder::simulation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Simulation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            SIMULATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final S3Destination destination;

    private final String simulation;

    private CreateSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.destination = builder.destination;
        this.simulation = builder.simulation;
    }

    /**
     * <p>
     * The Amazon S3 bucket and optional folder (object key prefix) where SimSpace Weaver creates the snapshot file.
     * </p>
     * <p>
     * The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.
     * </p>
     * 
     * @return The Amazon S3 bucket and optional folder (object key prefix) where SimSpace Weaver creates the snapshot
     *         file.</p>
     *         <p>
     *         The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.
     */
    public final S3Destination destination() {
        return destination;
    }

    /**
     * <p>
     * The name of the simulation.
     * </p>
     * 
     * @return The name of the simulation.
     */
    public final String simulation() {
        return simulation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(simulation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotRequest)) {
            return false;
        }
        CreateSnapshotRequest other = (CreateSnapshotRequest) obj;
        return Objects.equals(destination(), other.destination()) && Objects.equals(simulation(), other.simulation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSnapshotRequest").add("Destination", destination()).add("Simulation", simulation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Simulation":
            return Optional.ofNullable(clazz.cast(simulation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Destination", DESTINATION_FIELD);
        map.put("Simulation", SIMULATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotRequest, T> g) {
        return obj -> g.apply((CreateSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SimSpaceWeaverRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSnapshotRequest> {
        /**
         * <p>
         * The Amazon S3 bucket and optional folder (object key prefix) where SimSpace Weaver creates the snapshot file.
         * </p>
         * <p>
         * The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.
         * </p>
         * 
         * @param destination
         *        The Amazon S3 bucket and optional folder (object key prefix) where SimSpace Weaver creates the
         *        snapshot file.</p>
         *        <p>
         *        The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(S3Destination destination);

        /**
         * <p>
         * The Amazon S3 bucket and optional folder (object key prefix) where SimSpace Weaver creates the snapshot file.
         * </p>
         * <p>
         * The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Destination.Builder} avoiding the need
         * to create one manually via {@link S3Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Destination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(S3Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link S3Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(S3Destination)
         */
        default Builder destination(Consumer<S3Destination.Builder> destination) {
            return destination(S3Destination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The name of the simulation.
         * </p>
         * 
         * @param simulation
         *        The name of the simulation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulation(String simulation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SimSpaceWeaverRequest.BuilderImpl implements Builder {
        private S3Destination destination;

        private String simulation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotRequest model) {
            super(model);
            destination(model.destination);
            simulation(model.simulation);
        }

        public final S3Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(S3Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(S3Destination destination) {
            this.destination = destination;
            return this;
        }

        public final String getSimulation() {
            return simulation;
        }

        public final void setSimulation(String simulation) {
            this.simulation = simulation;
        }

        @Override
        public final Builder simulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSnapshotRequest build() {
            return new CreateSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
