/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of metadata about the app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimulationAppMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<SimulationAppMetadata.Builder, SimulationAppMetadata> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(SimulationAppMetadata::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SimulationAppMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SIMULATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Simulation").getter(getter(SimulationAppMetadata::simulation)).setter(setter(Builder::simulation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Simulation").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SimulationAppMetadata::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetStatus").getter(getter(SimulationAppMetadata::targetStatusAsString))
            .setter(setter(Builder::targetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, NAME_FIELD,
            SIMULATION_FIELD, STATUS_FIELD, TARGET_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domain;

    private final String name;

    private final String simulation;

    private final String status;

    private final String targetStatus;

    private SimulationAppMetadata(BuilderImpl builder) {
        this.domain = builder.domain;
        this.name = builder.name;
        this.simulation = builder.simulation;
        this.status = builder.status;
        this.targetStatus = builder.targetStatus;
    }

    /**
     * <p>
     * The domain of the app. For more information about domains, see <a href=
     * "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains"
     * >Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.
     * </p>
     * 
     * @return The domain of the app. For more information about domains, see <a href=
     *         "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains"
     *         >Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The name of the app.
     * </p>
     * 
     * @return The name of the app.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the simulation of the app.
     * </p>
     * 
     * @return The name of the simulation of the app.
     */
    public final String simulation() {
        return simulation;
    }

    /**
     * <p>
     * The current status of the app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationAppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the app.
     * @see SimulationAppStatus
     */
    public final SimulationAppStatus status() {
        return SimulationAppStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationAppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the app.
     * @see SimulationAppStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The desired status of the app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link SimulationAppTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The desired status of the app.
     * @see SimulationAppTargetStatus
     */
    public final SimulationAppTargetStatus targetStatus() {
        return SimulationAppTargetStatus.fromValue(targetStatus);
    }

    /**
     * <p>
     * The desired status of the app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link SimulationAppTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The desired status of the app.
     * @see SimulationAppTargetStatus
     */
    public final String targetStatusAsString() {
        return targetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(simulation());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationAppMetadata)) {
            return false;
        }
        SimulationAppMetadata other = (SimulationAppMetadata) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(name(), other.name())
                && Objects.equals(simulation(), other.simulation()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(targetStatusAsString(), other.targetStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimulationAppMetadata").add("Domain", domain()).add("Name", name())
                .add("Simulation", simulation()).add("Status", statusAsString()).add("TargetStatus", targetStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Simulation":
            return Optional.ofNullable(clazz.cast(simulation()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TargetStatus":
            return Optional.ofNullable(clazz.cast(targetStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Simulation", SIMULATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TargetStatus", TARGET_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SimulationAppMetadata, T> g) {
        return obj -> g.apply((SimulationAppMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimulationAppMetadata> {
        /**
         * <p>
         * The domain of the app. For more information about domains, see <a href=
         * "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains"
         * >Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.
         * </p>
         * 
         * @param domain
         *        The domain of the app. For more information about domains, see <a href=
         *        "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains"
         *        >Key concepts: Domains</a> in the <i>SimSpace Weaver User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The name of the app.
         * </p>
         * 
         * @param name
         *        The name of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the simulation of the app.
         * </p>
         * 
         * @param simulation
         *        The name of the simulation of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulation(String simulation);

        /**
         * <p>
         * The current status of the app.
         * </p>
         * 
         * @param status
         *        The current status of the app.
         * @see SimulationAppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationAppStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the app.
         * </p>
         * 
         * @param status
         *        The current status of the app.
         * @see SimulationAppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationAppStatus
         */
        Builder status(SimulationAppStatus status);

        /**
         * <p>
         * The desired status of the app.
         * </p>
         * 
         * @param targetStatus
         *        The desired status of the app.
         * @see SimulationAppTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationAppTargetStatus
         */
        Builder targetStatus(String targetStatus);

        /**
         * <p>
         * The desired status of the app.
         * </p>
         * 
         * @param targetStatus
         *        The desired status of the app.
         * @see SimulationAppTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationAppTargetStatus
         */
        Builder targetStatus(SimulationAppTargetStatus targetStatus);
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private String name;

        private String simulation;

        private String status;

        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationAppMetadata model) {
            domain(model.domain);
            name(model.name);
            simulation(model.simulation);
            status(model.status);
            targetStatus(model.targetStatus);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSimulation() {
            return simulation;
        }

        public final void setSimulation(String simulation) {
            this.simulation = simulation;
        }

        @Override
        public final Builder simulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationAppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetStatus() {
            return targetStatus;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(SimulationAppTargetStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        @Override
        public SimulationAppMetadata build() {
            return new SimulationAppMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
