/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAppRequest extends SimSpaceWeaverRequest implements
        ToCopyableBuilder<DeleteAppRequest.Builder, DeleteAppRequest> {
    private static final SdkField<String> APP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("App")
            .getter(getter(DeleteAppRequest::app)).setter(setter(Builder::app))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("app").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(DeleteAppRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> SIMULATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Simulation").getter(getter(DeleteAppRequest::simulation)).setter(setter(Builder::simulation))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("simulation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_FIELD, DOMAIN_FIELD,
            SIMULATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String app;

    private final String domain;

    private final String simulation;

    private DeleteAppRequest(BuilderImpl builder) {
        super(builder);
        this.app = builder.app;
        this.domain = builder.domain;
        this.simulation = builder.simulation;
    }

    /**
     * <p>
     * The name of the app.
     * </p>
     * 
     * @return The name of the app.
     */
    public final String app() {
        return app;
    }

    /**
     * <p>
     * The name of the domain of the app.
     * </p>
     * 
     * @return The name of the domain of the app.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The name of the simulation of the app.
     * </p>
     * 
     * @return The name of the simulation of the app.
     */
    public final String simulation() {
        return simulation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(app());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(simulation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppRequest)) {
            return false;
        }
        DeleteAppRequest other = (DeleteAppRequest) obj;
        return Objects.equals(app(), other.app()) && Objects.equals(domain(), other.domain())
                && Objects.equals(simulation(), other.simulation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAppRequest").add("App", app()).add("Domain", domain()).add("Simulation", simulation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "App":
            return Optional.ofNullable(clazz.cast(app()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Simulation":
            return Optional.ofNullable(clazz.cast(simulation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("app", APP_FIELD);
        map.put("domain", DOMAIN_FIELD);
        map.put("simulation", SIMULATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAppRequest, T> g) {
        return obj -> g.apply((DeleteAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SimSpaceWeaverRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAppRequest> {
        /**
         * <p>
         * The name of the app.
         * </p>
         * 
         * @param app
         *        The name of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder app(String app);

        /**
         * <p>
         * The name of the domain of the app.
         * </p>
         * 
         * @param domain
         *        The name of the domain of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The name of the simulation of the app.
         * </p>
         * 
         * @param simulation
         *        The name of the simulation of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulation(String simulation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SimSpaceWeaverRequest.BuilderImpl implements Builder {
        private String app;

        private String domain;

        private String simulation;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppRequest model) {
            super(model);
            app(model.app);
            domain(model.domain);
            simulation(model.simulation);
        }

        public final String getApp() {
            return app;
        }

        public final void setApp(String app) {
            this.app = app;
        }

        @Override
        public final Builder app(String app) {
            this.app = app;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getSimulation() {
            return simulation;
        }

        public final void setSimulation(String simulation) {
            this.simulation = simulation;
        }

        @Override
        public final Builder simulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAppRequest build() {
            return new DeleteAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
