/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the network endpoint that you can use to connect to your custom or service app. For more
 * information about SimSpace Weaver apps, see <a href=
 * "https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_apps">Key
 * concepts: Apps</a> in the <i>SimSpace Weaver User Guide</i>..
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimulationAppEndpointInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<SimulationAppEndpointInfo.Builder, SimulationAppEndpointInfo> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Address")
            .getter(getter(SimulationAppEndpointInfo::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<List<SimulationAppPortMapping>> INGRESS_PORT_MAPPINGS_FIELD = SdkField
            .<List<SimulationAppPortMapping>> builder(MarshallingType.LIST)
            .memberName("IngressPortMappings")
            .getter(getter(SimulationAppEndpointInfo::ingressPortMappings))
            .setter(setter(Builder::ingressPortMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPortMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimulationAppPortMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimulationAppPortMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD,
            INGRESS_PORT_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String address;

    private final List<SimulationAppPortMapping> ingressPortMappings;

    private SimulationAppEndpointInfo(BuilderImpl builder) {
        this.address = builder.address;
        this.ingressPortMappings = builder.ingressPortMappings;
    }

    /**
     * <p>
     * The IP address of the app. SimSpace Weaver dynamically assigns this IP address when the app starts.
     * </p>
     * 
     * @return The IP address of the app. SimSpace Weaver dynamically assigns this IP address when the app starts.
     */
    public final String address() {
        return address;
    }

    /**
     * For responses, this returns true if the service returned a value for the IngressPortMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIngressPortMappings() {
        return ingressPortMappings != null && !(ingressPortMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inbound TCP/UDP port numbers of the app. The combination of an IP address and a port number form a network
     * endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIngressPortMappings} method.
     * </p>
     * 
     * @return The inbound TCP/UDP port numbers of the app. The combination of an IP address and a port number form a
     *         network endpoint.
     */
    public final List<SimulationAppPortMapping> ingressPortMappings() {
        return ingressPortMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(hasIngressPortMappings() ? ingressPortMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationAppEndpointInfo)) {
            return false;
        }
        SimulationAppEndpointInfo other = (SimulationAppEndpointInfo) obj;
        return Objects.equals(address(), other.address()) && hasIngressPortMappings() == other.hasIngressPortMappings()
                && Objects.equals(ingressPortMappings(), other.ingressPortMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimulationAppEndpointInfo").add("Address", address())
                .add("IngressPortMappings", hasIngressPortMappings() ? ingressPortMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "IngressPortMappings":
            return Optional.ofNullable(clazz.cast(ingressPortMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Address", ADDRESS_FIELD);
        map.put("IngressPortMappings", INGRESS_PORT_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SimulationAppEndpointInfo, T> g) {
        return obj -> g.apply((SimulationAppEndpointInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimulationAppEndpointInfo> {
        /**
         * <p>
         * The IP address of the app. SimSpace Weaver dynamically assigns this IP address when the app starts.
         * </p>
         * 
         * @param address
         *        The IP address of the app. SimSpace Weaver dynamically assigns this IP address when the app starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The inbound TCP/UDP port numbers of the app. The combination of an IP address and a port number form a
         * network endpoint.
         * </p>
         * 
         * @param ingressPortMappings
         *        The inbound TCP/UDP port numbers of the app. The combination of an IP address and a port number form a
         *        network endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPortMappings(Collection<SimulationAppPortMapping> ingressPortMappings);

        /**
         * <p>
         * The inbound TCP/UDP port numbers of the app. The combination of an IP address and a port number form a
         * network endpoint.
         * </p>
         * 
         * @param ingressPortMappings
         *        The inbound TCP/UDP port numbers of the app. The combination of an IP address and a port number form a
         *        network endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPortMappings(SimulationAppPortMapping... ingressPortMappings);

        /**
         * <p>
         * The inbound TCP/UDP port numbers of the app. The combination of an IP address and a port number form a
         * network endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.simspaceweaver.model.SimulationAppPortMapping.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.simspaceweaver.model.SimulationAppPortMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.simspaceweaver.model.SimulationAppPortMapping.Builder#build()} is
         * called immediately and its result is passed to {@link #ingressPortMappings(List<SimulationAppPortMapping>)}.
         * 
         * @param ingressPortMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.simspaceweaver.model.SimulationAppPortMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressPortMappings(java.util.Collection<SimulationAppPortMapping>)
         */
        Builder ingressPortMappings(Consumer<SimulationAppPortMapping.Builder>... ingressPortMappings);
    }

    static final class BuilderImpl implements Builder {
        private String address;

        private List<SimulationAppPortMapping> ingressPortMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationAppEndpointInfo model) {
            address(model.address);
            ingressPortMappings(model.ingressPortMappings);
        }

        public final String getAddress() {
            return address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final List<SimulationAppPortMapping.Builder> getIngressPortMappings() {
            List<SimulationAppPortMapping.Builder> result = AppPortMappingsCopier.copyToBuilder(this.ingressPortMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngressPortMappings(Collection<SimulationAppPortMapping.BuilderImpl> ingressPortMappings) {
            this.ingressPortMappings = AppPortMappingsCopier.copyFromBuilder(ingressPortMappings);
        }

        @Override
        public final Builder ingressPortMappings(Collection<SimulationAppPortMapping> ingressPortMappings) {
            this.ingressPortMappings = AppPortMappingsCopier.copy(ingressPortMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPortMappings(SimulationAppPortMapping... ingressPortMappings) {
            ingressPortMappings(Arrays.asList(ingressPortMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPortMappings(Consumer<SimulationAppPortMapping.Builder>... ingressPortMappings) {
            ingressPortMappings(Stream.of(ingressPortMappings)
                    .map(c -> SimulationAppPortMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SimulationAppEndpointInfo build() {
            return new SimulationAppEndpointInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
