/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAppRequest extends SimSpaceWeaverRequest implements
        ToCopyableBuilder<StartAppRequest.Builder, StartAppRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartAppRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartAppRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(StartAppRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<LaunchOverrides> LAUNCH_OVERRIDES_FIELD = SdkField
            .<LaunchOverrides> builder(MarshallingType.SDK_POJO).memberName("LaunchOverrides")
            .getter(getter(StartAppRequest::launchOverrides)).setter(setter(Builder::launchOverrides))
            .constructor(LaunchOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchOverrides").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartAppRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SIMULATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Simulation").getter(getter(StartAppRequest::simulation)).setter(setter(Builder::simulation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Simulation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, DOMAIN_FIELD, LAUNCH_OVERRIDES_FIELD, NAME_FIELD, SIMULATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String description;

    private final String domain;

    private final LaunchOverrides launchOverrides;

    private final String name;

    private final String simulation;

    private StartAppRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.domain = builder.domain;
        this.launchOverrides = builder.launchOverrides;
        this.name = builder.name;
        this.simulation = builder.simulation;
    }

    /**
     * <p>
     * A value that you provide to ensure that repeated calls to this API operation using the same parameters complete
     * only once. A <code>ClientToken</code> is also known as an <i>idempotency token</i>. A <code>ClientToken</code>
     * expires after 24 hours.
     * </p>
     * 
     * @return A value that you provide to ensure that repeated calls to this API operation using the same parameters
     *         complete only once. A <code>ClientToken</code> is also known as an <i>idempotency token</i>. A
     *         <code>ClientToken</code> expires after 24 hours.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description of the app.
     * </p>
     * 
     * @return The description of the app.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the domain of the app.
     * </p>
     * 
     * @return The name of the domain of the app.
     */
    public final String domain() {
        return domain;
    }

    /**
     * Returns the value of the LaunchOverrides property for this object.
     * 
     * @return The value of the LaunchOverrides property for this object.
     */
    public final LaunchOverrides launchOverrides() {
        return launchOverrides;
    }

    /**
     * <p>
     * The name of the app.
     * </p>
     * 
     * @return The name of the app.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the simulation of the app.
     * </p>
     * 
     * @return The name of the simulation of the app.
     */
    public final String simulation() {
        return simulation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(launchOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(simulation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAppRequest)) {
            return false;
        }
        StartAppRequest other = (StartAppRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(domain(), other.domain()) && Objects.equals(launchOverrides(), other.launchOverrides())
                && Objects.equals(name(), other.name()) && Objects.equals(simulation(), other.simulation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAppRequest")
                .add("ClientToken", clientToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description()).add("Domain", domain()).add("LaunchOverrides", launchOverrides())
                .add("Name", name()).add("Simulation", simulation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "LaunchOverrides":
            return Optional.ofNullable(clazz.cast(launchOverrides()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Simulation":
            return Optional.ofNullable(clazz.cast(simulation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("LaunchOverrides", LAUNCH_OVERRIDES_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Simulation", SIMULATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAppRequest, T> g) {
        return obj -> g.apply((StartAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SimSpaceWeaverRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartAppRequest> {
        /**
         * <p>
         * A value that you provide to ensure that repeated calls to this API operation using the same parameters
         * complete only once. A <code>ClientToken</code> is also known as an <i>idempotency token</i>. A
         * <code>ClientToken</code> expires after 24 hours.
         * </p>
         * 
         * @param clientToken
         *        A value that you provide to ensure that repeated calls to this API operation using the same parameters
         *        complete only once. A <code>ClientToken</code> is also known as an <i>idempotency token</i>. A
         *        <code>ClientToken</code> expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description of the app.
         * </p>
         * 
         * @param description
         *        The description of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the domain of the app.
         * </p>
         * 
         * @param domain
         *        The name of the domain of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * Sets the value of the LaunchOverrides property for this object.
         *
         * @param launchOverrides
         *        The new value for the LaunchOverrides property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchOverrides(LaunchOverrides launchOverrides);

        /**
         * Sets the value of the LaunchOverrides property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LaunchOverrides.Builder} avoiding the
         * need to create one manually via {@link LaunchOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchOverrides.Builder#build()} is called immediately and its
         * result is passed to {@link #launchOverrides(LaunchOverrides)}.
         * 
         * @param launchOverrides
         *        a consumer that will call methods on {@link LaunchOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchOverrides(LaunchOverrides)
         */
        default Builder launchOverrides(Consumer<LaunchOverrides.Builder> launchOverrides) {
            return launchOverrides(LaunchOverrides.builder().applyMutation(launchOverrides).build());
        }

        /**
         * <p>
         * The name of the app.
         * </p>
         * 
         * @param name
         *        The name of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the simulation of the app.
         * </p>
         * 
         * @param simulation
         *        The name of the simulation of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulation(String simulation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SimSpaceWeaverRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private String domain;

        private LaunchOverrides launchOverrides;

        private String name;

        private String simulation;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAppRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            domain(model.domain);
            launchOverrides(model.launchOverrides);
            name(model.name);
            simulation(model.simulation);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final LaunchOverrides.Builder getLaunchOverrides() {
            return launchOverrides != null ? launchOverrides.toBuilder() : null;
        }

        public final void setLaunchOverrides(LaunchOverrides.BuilderImpl launchOverrides) {
            this.launchOverrides = launchOverrides != null ? launchOverrides.build() : null;
        }

        @Override
        public final Builder launchOverrides(LaunchOverrides launchOverrides) {
            this.launchOverrides = launchOverrides;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSimulation() {
            return simulation;
        }

        public final void setSimulation(String simulation) {
            this.simulation = simulation;
        }

        @Override
        public final Builder simulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAppRequest build() {
            return new StartAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
