/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of TCP/UDP ports for a custom or service app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimulationAppPortMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<SimulationAppPortMapping.Builder, SimulationAppPortMapping> {
    private static final SdkField<Integer> ACTUAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Actual").getter(getter(SimulationAppPortMapping::actual)).setter(setter(Builder::actual))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actual").build()).build();

    private static final SdkField<Integer> DECLARED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Declared").getter(getter(SimulationAppPortMapping::declared)).setter(setter(Builder::declared))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Declared").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTUAL_FIELD, DECLARED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer actual;

    private final Integer declared;

    private SimulationAppPortMapping(BuilderImpl builder) {
        this.actual = builder.actual;
        this.declared = builder.declared;
    }

    /**
     * <p>
     * The TCP/UDP port number of the running app. SimSpace Weaver dynamically assigns this port number when the app
     * starts. SimSpace Weaver maps the <code>Declared</code> port to the <code>Actual</code> port. Clients connect to
     * the app using the app's IP address and the <code>Actual</code> port number.
     * </p>
     * 
     * @return The TCP/UDP port number of the running app. SimSpace Weaver dynamically assigns this port number when the
     *         app starts. SimSpace Weaver maps the <code>Declared</code> port to the <code>Actual</code> port. Clients
     *         connect to the app using the app's IP address and the <code>Actual</code> port number.
     */
    public final Integer actual() {
        return actual;
    }

    /**
     * <p>
     * The TCP/UDP port number of the app, declared in the simulation schema. SimSpace Weaver maps the
     * <code>Declared</code> port to the <code>Actual</code> port. The source code for the app should bind to the
     * <code>Declared</code> port.
     * </p>
     * 
     * @return The TCP/UDP port number of the app, declared in the simulation schema. SimSpace Weaver maps the
     *         <code>Declared</code> port to the <code>Actual</code> port. The source code for the app should bind to
     *         the <code>Declared</code> port.
     */
    public final Integer declared() {
        return declared;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actual());
        hashCode = 31 * hashCode + Objects.hashCode(declared());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationAppPortMapping)) {
            return false;
        }
        SimulationAppPortMapping other = (SimulationAppPortMapping) obj;
        return Objects.equals(actual(), other.actual()) && Objects.equals(declared(), other.declared());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimulationAppPortMapping").add("Actual", actual()).add("Declared", declared()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Actual":
            return Optional.ofNullable(clazz.cast(actual()));
        case "Declared":
            return Optional.ofNullable(clazz.cast(declared()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Actual", ACTUAL_FIELD);
        map.put("Declared", DECLARED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SimulationAppPortMapping, T> g) {
        return obj -> g.apply((SimulationAppPortMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimulationAppPortMapping> {
        /**
         * <p>
         * The TCP/UDP port number of the running app. SimSpace Weaver dynamically assigns this port number when the app
         * starts. SimSpace Weaver maps the <code>Declared</code> port to the <code>Actual</code> port. Clients connect
         * to the app using the app's IP address and the <code>Actual</code> port number.
         * </p>
         * 
         * @param actual
         *        The TCP/UDP port number of the running app. SimSpace Weaver dynamically assigns this port number when
         *        the app starts. SimSpace Weaver maps the <code>Declared</code> port to the <code>Actual</code> port.
         *        Clients connect to the app using the app's IP address and the <code>Actual</code> port number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actual(Integer actual);

        /**
         * <p>
         * The TCP/UDP port number of the app, declared in the simulation schema. SimSpace Weaver maps the
         * <code>Declared</code> port to the <code>Actual</code> port. The source code for the app should bind to the
         * <code>Declared</code> port.
         * </p>
         * 
         * @param declared
         *        The TCP/UDP port number of the app, declared in the simulation schema. SimSpace Weaver maps the
         *        <code>Declared</code> port to the <code>Actual</code> port. The source code for the app should bind to
         *        the <code>Declared</code> port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declared(Integer declared);
    }

    static final class BuilderImpl implements Builder {
        private Integer actual;

        private Integer declared;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationAppPortMapping model) {
            actual(model.actual);
            declared(model.declared);
        }

        public final Integer getActual() {
            return actual;
        }

        public final void setActual(Integer actual) {
            this.actual = actual;
        }

        @Override
        public final Builder actual(Integer actual) {
            this.actual = actual;
            return this;
        }

        public final Integer getDeclared() {
            return declared;
        }

        public final void setDeclared(Integer declared) {
            this.declared = declared;
        }

        @Override
        public final Builder declared(Integer declared) {
            this.declared = declared;
            return this;
        }

        @Override
        public SimulationAppPortMapping build() {
            return new SimulationAppPortMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
