/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAppReplicationConfigurationResponse extends SmsResponse implements
        ToCopyableBuilder<GetAppReplicationConfigurationResponse.Builder, GetAppReplicationConfigurationResponse> {
    private static final SdkField<List<ServerGroupReplicationConfiguration>> SERVER_GROUP_REPLICATION_CONFIGURATIONS_FIELD = SdkField
            .<List<ServerGroupReplicationConfiguration>> builder(MarshallingType.LIST)
            .memberName("serverGroupReplicationConfigurations")
            .getter(getter(GetAppReplicationConfigurationResponse::serverGroupReplicationConfigurations))
            .setter(setter(Builder::serverGroupReplicationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("serverGroupReplicationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerGroupReplicationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerGroupReplicationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVER_GROUP_REPLICATION_CONFIGURATIONS_FIELD));

    private final List<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations;

    private GetAppReplicationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.serverGroupReplicationConfigurations = builder.serverGroupReplicationConfigurations;
    }

    /**
     * Returns true if the ServerGroupReplicationConfigurations property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public boolean hasServerGroupReplicationConfigurations() {
        return serverGroupReplicationConfigurations != null
                && !(serverGroupReplicationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replication configurations associated with server groups in this application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServerGroupReplicationConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The replication configurations associated with server groups in this application.
     */
    public List<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations() {
        return serverGroupReplicationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasServerGroupReplicationConfigurations() ? serverGroupReplicationConfigurations() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppReplicationConfigurationResponse)) {
            return false;
        }
        GetAppReplicationConfigurationResponse other = (GetAppReplicationConfigurationResponse) obj;
        return hasServerGroupReplicationConfigurations() == other.hasServerGroupReplicationConfigurations()
                && Objects.equals(serverGroupReplicationConfigurations(), other.serverGroupReplicationConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("GetAppReplicationConfigurationResponse")
                .add("ServerGroupReplicationConfigurations",
                        hasServerGroupReplicationConfigurations() ? serverGroupReplicationConfigurations() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverGroupReplicationConfigurations":
            return Optional.ofNullable(clazz.cast(serverGroupReplicationConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAppReplicationConfigurationResponse, T> g) {
        return obj -> g.apply((GetAppReplicationConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAppReplicationConfigurationResponse> {
        /**
         * <p>
         * The replication configurations associated with server groups in this application.
         * </p>
         * 
         * @param serverGroupReplicationConfigurations
         *        The replication configurations associated with server groups in this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupReplicationConfigurations(
                Collection<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations);

        /**
         * <p>
         * The replication configurations associated with server groups in this application.
         * </p>
         * 
         * @param serverGroupReplicationConfigurations
         *        The replication configurations associated with server groups in this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupReplicationConfigurations(ServerGroupReplicationConfiguration... serverGroupReplicationConfigurations);

        /**
         * <p>
         * The replication configurations associated with server groups in this application.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ServerGroupReplicationConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <ServerGroupReplicationConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServerGroupReplicationConfiguration>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #serverGroupReplicationConfigurations(List<ServerGroupReplicationConfiguration>)}.
         * 
         * @param serverGroupReplicationConfigurations
         *        a consumer that will call methods on {@link List<ServerGroupReplicationConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverGroupReplicationConfigurations(List<ServerGroupReplicationConfiguration>)
         */
        Builder serverGroupReplicationConfigurations(
                Consumer<ServerGroupReplicationConfiguration.Builder>... serverGroupReplicationConfigurations);
    }

    static final class BuilderImpl extends SmsResponse.BuilderImpl implements Builder {
        private List<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppReplicationConfigurationResponse model) {
            super(model);
            serverGroupReplicationConfigurations(model.serverGroupReplicationConfigurations);
        }

        public final Collection<ServerGroupReplicationConfiguration.Builder> getServerGroupReplicationConfigurations() {
            if (serverGroupReplicationConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return serverGroupReplicationConfigurations != null ? serverGroupReplicationConfigurations.stream()
                    .map(ServerGroupReplicationConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverGroupReplicationConfigurations(
                Collection<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations) {
            this.serverGroupReplicationConfigurations = ServerGroupReplicationConfigurationsCopier
                    .copy(serverGroupReplicationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupReplicationConfigurations(
                ServerGroupReplicationConfiguration... serverGroupReplicationConfigurations) {
            serverGroupReplicationConfigurations(Arrays.asList(serverGroupReplicationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupReplicationConfigurations(
                Consumer<ServerGroupReplicationConfiguration.Builder>... serverGroupReplicationConfigurations) {
            serverGroupReplicationConfigurations(Stream.of(serverGroupReplicationConfigurations)
                    .map(c -> ServerGroupReplicationConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setServerGroupReplicationConfigurations(
                Collection<ServerGroupReplicationConfiguration.BuilderImpl> serverGroupReplicationConfigurations) {
            this.serverGroupReplicationConfigurations = ServerGroupReplicationConfigurationsCopier
                    .copyFromBuilder(serverGroupReplicationConfigurations);
        }

        @Override
        public GetAppReplicationConfigurationResponse build() {
            return new GetAppReplicationConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
