/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAppValidationOutputResponse extends SmsResponse implements
        ToCopyableBuilder<GetAppValidationOutputResponse.Builder, GetAppValidationOutputResponse> {
    private static final SdkField<List<ValidationOutput>> VALIDATION_OUTPUT_LIST_FIELD = SdkField
            .<List<ValidationOutput>> builder(MarshallingType.LIST)
            .memberName("validationOutputList")
            .getter(getter(GetAppValidationOutputResponse::validationOutputList))
            .setter(setter(Builder::validationOutputList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationOutputList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_OUTPUT_LIST_FIELD));

    private final List<ValidationOutput> validationOutputList;

    private GetAppValidationOutputResponse(BuilderImpl builder) {
        super(builder);
        this.validationOutputList = builder.validationOutputList;
    }

    /**
     * Returns true if the ValidationOutputList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasValidationOutputList() {
        return validationOutputList != null && !(validationOutputList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The validation output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidationOutputList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The validation output.
     */
    public List<ValidationOutput> validationOutputList() {
        return validationOutputList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasValidationOutputList() ? validationOutputList() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppValidationOutputResponse)) {
            return false;
        }
        GetAppValidationOutputResponse other = (GetAppValidationOutputResponse) obj;
        return hasValidationOutputList() == other.hasValidationOutputList()
                && Objects.equals(validationOutputList(), other.validationOutputList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAppValidationOutputResponse")
                .add("ValidationOutputList", hasValidationOutputList() ? validationOutputList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "validationOutputList":
            return Optional.ofNullable(clazz.cast(validationOutputList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAppValidationOutputResponse, T> g) {
        return obj -> g.apply((GetAppValidationOutputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAppValidationOutputResponse> {
        /**
         * <p>
         * The validation output.
         * </p>
         * 
         * @param validationOutputList
         *        The validation output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationOutputList(Collection<ValidationOutput> validationOutputList);

        /**
         * <p>
         * The validation output.
         * </p>
         * 
         * @param validationOutputList
         *        The validation output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationOutputList(ValidationOutput... validationOutputList);

        /**
         * <p>
         * The validation output.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ValidationOutput>.Builder} avoiding the
         * need to create one manually via {@link List<ValidationOutput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationOutput>.Builder#build()} is called immediately and
         * its result is passed to {@link #validationOutputList(List<ValidationOutput>)}.
         * 
         * @param validationOutputList
         *        a consumer that will call methods on {@link List<ValidationOutput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationOutputList(List<ValidationOutput>)
         */
        Builder validationOutputList(Consumer<ValidationOutput.Builder>... validationOutputList);
    }

    static final class BuilderImpl extends SmsResponse.BuilderImpl implements Builder {
        private List<ValidationOutput> validationOutputList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppValidationOutputResponse model) {
            super(model);
            validationOutputList(model.validationOutputList);
        }

        public final Collection<ValidationOutput.Builder> getValidationOutputList() {
            if (validationOutputList instanceof SdkAutoConstructList) {
                return null;
            }
            return validationOutputList != null ? validationOutputList.stream().map(ValidationOutput::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationOutputList(Collection<ValidationOutput> validationOutputList) {
            this.validationOutputList = ValidationOutputListCopier.copy(validationOutputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationOutputList(ValidationOutput... validationOutputList) {
            validationOutputList(Arrays.asList(validationOutputList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationOutputList(Consumer<ValidationOutput.Builder>... validationOutputList) {
            validationOutputList(Stream.of(validationOutputList).map(c -> ValidationOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setValidationOutputList(Collection<ValidationOutput.BuilderImpl> validationOutputList) {
            this.validationOutputList = ValidationOutputListCopier.copyFromBuilder(validationOutputList);
        }

        @Override
        public GetAppValidationOutputResponse build() {
            return new GetAppValidationOutputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
