/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServersRequest extends SmsRequest implements
        ToCopyableBuilder<GetServersRequest.Builder, GetServersRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetServersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetServersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<VmServerAddress>> VM_SERVER_ADDRESS_LIST_FIELD = SdkField
            .<List<VmServerAddress>> builder(MarshallingType.LIST)
            .memberName("vmServerAddressList")
            .getter(getter(GetServersRequest::vmServerAddressList))
            .setter(setter(Builder::vmServerAddressList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmServerAddressList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VmServerAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(VmServerAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, VM_SERVER_ADDRESS_LIST_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<VmServerAddress> vmServerAddressList;

    private GetServersRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.vmServerAddressList = builder.vmServerAddressList;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining
     * results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. The default value is 50. To retrieve the
     *         remaining results, make another call with the returned <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns true if the VmServerAddressList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVmServerAddressList() {
        return vmServerAddressList != null && !(vmServerAddressList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The server addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVmServerAddressList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The server addresses.
     */
    public List<VmServerAddress> vmServerAddressList() {
        return vmServerAddressList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasVmServerAddressList() ? vmServerAddressList() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServersRequest)) {
            return false;
        }
        GetServersRequest other = (GetServersRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasVmServerAddressList() == other.hasVmServerAddressList()
                && Objects.equals(vmServerAddressList(), other.vmServerAddressList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetServersRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("VmServerAddressList", hasVmServerAddressList() ? vmServerAddressList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "vmServerAddressList":
            return Optional.ofNullable(clazz.cast(vmServerAddressList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServersRequest, T> g) {
        return obj -> g.apply((GetServersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetServersRequest> {
        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining
         * results, make another call with the returned <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. The default value is 50. To retrieve the
         *        remaining results, make another call with the returned <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The server addresses.
         * </p>
         * 
         * @param vmServerAddressList
         *        The server addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmServerAddressList(Collection<VmServerAddress> vmServerAddressList);

        /**
         * <p>
         * The server addresses.
         * </p>
         * 
         * @param vmServerAddressList
         *        The server addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmServerAddressList(VmServerAddress... vmServerAddressList);

        /**
         * <p>
         * The server addresses.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VmServerAddress>.Builder} avoiding the need
         * to create one manually via {@link List<VmServerAddress>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VmServerAddress>.Builder#build()} is called immediately and
         * its result is passed to {@link #vmServerAddressList(List<VmServerAddress>)}.
         * 
         * @param vmServerAddressList
         *        a consumer that will call methods on {@link List<VmServerAddress>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vmServerAddressList(List<VmServerAddress>)
         */
        Builder vmServerAddressList(Consumer<VmServerAddress.Builder>... vmServerAddressList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SmsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<VmServerAddress> vmServerAddressList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetServersRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            vmServerAddressList(model.vmServerAddressList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<VmServerAddress.Builder> getVmServerAddressList() {
            if (vmServerAddressList instanceof SdkAutoConstructList) {
                return null;
            }
            return vmServerAddressList != null ? vmServerAddressList.stream().map(VmServerAddress::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vmServerAddressList(Collection<VmServerAddress> vmServerAddressList) {
            this.vmServerAddressList = VmServerAddressListCopier.copy(vmServerAddressList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vmServerAddressList(VmServerAddress... vmServerAddressList) {
            vmServerAddressList(Arrays.asList(vmServerAddressList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vmServerAddressList(Consumer<VmServerAddress.Builder>... vmServerAddressList) {
            vmServerAddressList(Stream.of(vmServerAddressList).map(c -> VmServerAddress.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVmServerAddressList(Collection<VmServerAddress.BuilderImpl> vmServerAddressList) {
            this.vmServerAddressList = VmServerAddressListCopier.copyFromBuilder(vmServerAddressList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetServersRequest build() {
            return new GetServersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
