/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the current stage of a replication run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationRunStageDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationRunStageDetails.Builder, ReplicationRunStageDetails> {
    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stage")
            .getter(getter(ReplicationRunStageDetails::stage)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final SdkField<String> STAGE_PROGRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageProgress").getter(getter(ReplicationRunStageDetails::stageProgress))
            .setter(setter(Builder::stageProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageProgress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_FIELD,
            STAGE_PROGRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stage;

    private final String stageProgress;

    private ReplicationRunStageDetails(BuilderImpl builder) {
        this.stage = builder.stage;
        this.stageProgress = builder.stageProgress;
    }

    /**
     * <p>
     * The current stage of a replication run.
     * </p>
     * 
     * @return The current stage of a replication run.
     */
    public String stage() {
        return stage;
    }

    /**
     * <p>
     * The progress of the current stage of a replication run.
     * </p>
     * 
     * @return The progress of the current stage of a replication run.
     */
    public String stageProgress() {
        return stageProgress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        hashCode = 31 * hashCode + Objects.hashCode(stageProgress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRunStageDetails)) {
            return false;
        }
        ReplicationRunStageDetails other = (ReplicationRunStageDetails) obj;
        return Objects.equals(stage(), other.stage()) && Objects.equals(stageProgress(), other.stageProgress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReplicationRunStageDetails").add("Stage", stage()).add("StageProgress", stageProgress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stage":
            return Optional.ofNullable(clazz.cast(stage()));
        case "stageProgress":
            return Optional.ofNullable(clazz.cast(stageProgress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationRunStageDetails, T> g) {
        return obj -> g.apply((ReplicationRunStageDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationRunStageDetails> {
        /**
         * <p>
         * The current stage of a replication run.
         * </p>
         * 
         * @param stage
         *        The current stage of a replication run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(String stage);

        /**
         * <p>
         * The progress of the current stage of a replication run.
         * </p>
         * 
         * @param stageProgress
         *        The progress of the current stage of a replication run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageProgress(String stageProgress);
    }

    static final class BuilderImpl implements Builder {
        private String stage;

        private String stageProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationRunStageDetails model) {
            stage(model.stage);
            stageProgress(model.stageProgress);
        }

        public final String getStage() {
            return stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        public final String getStageProgress() {
            return stageProgress;
        }

        @Override
        public final Builder stageProgress(String stageProgress) {
            this.stageProgress = stageProgress;
            return this;
        }

        public final void setStageProgress(String stageProgress) {
            this.stageProgress = stageProgress;
        }

        @Override
        public ReplicationRunStageDetails build() {
            return new ReplicationRunStageDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
