/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output from validating an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppValidationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<AppValidationOutput.Builder, AppValidationOutput> {
    private static final SdkField<SSMOutput> SSM_OUTPUT_FIELD = SdkField.<SSMOutput> builder(MarshallingType.SDK_POJO)
            .memberName("ssmOutput").getter(getter(AppValidationOutput::ssmOutput)).setter(setter(Builder::ssmOutput))
            .constructor(SSMOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSM_OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SSMOutput ssmOutput;

    private AppValidationOutput(BuilderImpl builder) {
        this.ssmOutput = builder.ssmOutput;
    }

    /**
     * <p>
     * Output from using SSM to validate the application.
     * </p>
     * 
     * @return Output from using SSM to validate the application.
     */
    public final SSMOutput ssmOutput() {
        return ssmOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ssmOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppValidationOutput)) {
            return false;
        }
        AppValidationOutput other = (AppValidationOutput) obj;
        return Objects.equals(ssmOutput(), other.ssmOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppValidationOutput").add("SsmOutput", ssmOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ssmOutput":
            return Optional.ofNullable(clazz.cast(ssmOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppValidationOutput, T> g) {
        return obj -> g.apply((AppValidationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppValidationOutput> {
        /**
         * <p>
         * Output from using SSM to validate the application.
         * </p>
         * 
         * @param ssmOutput
         *        Output from using SSM to validate the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmOutput(SSMOutput ssmOutput);

        /**
         * <p>
         * Output from using SSM to validate the application.
         * </p>
         * This is a convenience that creates an instance of the {@link SSMOutput.Builder} avoiding the need to create
         * one manually via {@link SSMOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link SSMOutput.Builder#build()} is called immediately and its result
         * is passed to {@link #ssmOutput(SSMOutput)}.
         * 
         * @param ssmOutput
         *        a consumer that will call methods on {@link SSMOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmOutput(SSMOutput)
         */
        default Builder ssmOutput(Consumer<SSMOutput.Builder> ssmOutput) {
            return ssmOutput(SSMOutput.builder().applyMutation(ssmOutput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SSMOutput ssmOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(AppValidationOutput model) {
            ssmOutput(model.ssmOutput);
        }

        public final SSMOutput.Builder getSsmOutput() {
            return ssmOutput != null ? ssmOutput.toBuilder() : null;
        }

        @Override
        public final Builder ssmOutput(SSMOutput ssmOutput) {
            this.ssmOutput = ssmOutput;
            return this;
        }

        public final void setSsmOutput(SSMOutput.BuilderImpl ssmOutput) {
            this.ssmOutput = ssmOutput != null ? ssmOutput.build() : null;
        }

        @Override
        public AppValidationOutput build() {
            return new AppValidationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
