/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains validation output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidationOutput.Builder, ValidationOutput> {
    private static final SdkField<String> VALIDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("validationId").getter(getter(ValidationOutput::validationId)).setter(setter(Builder::validationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ValidationOutput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ValidationOutput::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ValidationOutput::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Instant> LATEST_VALIDATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("latestValidationTime").getter(getter(ValidationOutput::latestValidationTime))
            .setter(setter(Builder::latestValidationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestValidationTime").build())
            .build();

    private static final SdkField<AppValidationOutput> APP_VALIDATION_OUTPUT_FIELD = SdkField
            .<AppValidationOutput> builder(MarshallingType.SDK_POJO).memberName("appValidationOutput")
            .getter(getter(ValidationOutput::appValidationOutput)).setter(setter(Builder::appValidationOutput))
            .constructor(AppValidationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appValidationOutput").build())
            .build();

    private static final SdkField<ServerValidationOutput> SERVER_VALIDATION_OUTPUT_FIELD = SdkField
            .<ServerValidationOutput> builder(MarshallingType.SDK_POJO).memberName("serverValidationOutput")
            .getter(getter(ValidationOutput::serverValidationOutput)).setter(setter(Builder::serverValidationOutput))
            .constructor(ServerValidationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverValidationOutput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ID_FIELD,
            NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, LATEST_VALIDATION_TIME_FIELD, APP_VALIDATION_OUTPUT_FIELD,
            SERVER_VALIDATION_OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String validationId;

    private final String name;

    private final String status;

    private final String statusMessage;

    private final Instant latestValidationTime;

    private final AppValidationOutput appValidationOutput;

    private final ServerValidationOutput serverValidationOutput;

    private ValidationOutput(BuilderImpl builder) {
        this.validationId = builder.validationId;
        this.name = builder.name;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.latestValidationTime = builder.latestValidationTime;
        this.appValidationOutput = builder.appValidationOutput;
        this.serverValidationOutput = builder.serverValidationOutput;
    }

    /**
     * <p>
     * The ID of the validation.
     * </p>
     * 
     * @return The ID of the validation.
     */
    public final String validationId() {
        return validationId;
    }

    /**
     * <p>
     * The name of the validation.
     * </p>
     * 
     * @return The name of the validation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the validation.
     * @see ValidationStatus
     */
    public final ValidationStatus status() {
        return ValidationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the validation.
     * @see ValidationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message.
     * </p>
     * 
     * @return The status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The latest time that the validation was performed.
     * </p>
     * 
     * @return The latest time that the validation was performed.
     */
    public final Instant latestValidationTime() {
        return latestValidationTime;
    }

    /**
     * <p>
     * The output from validating an application.
     * </p>
     * 
     * @return The output from validating an application.
     */
    public final AppValidationOutput appValidationOutput() {
        return appValidationOutput;
    }

    /**
     * <p>
     * The output from validation an instance.
     * </p>
     * 
     * @return The output from validation an instance.
     */
    public final ServerValidationOutput serverValidationOutput() {
        return serverValidationOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(validationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(latestValidationTime());
        hashCode = 31 * hashCode + Objects.hashCode(appValidationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(serverValidationOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationOutput)) {
            return false;
        }
        ValidationOutput other = (ValidationOutput) obj;
        return Objects.equals(validationId(), other.validationId()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(latestValidationTime(), other.latestValidationTime())
                && Objects.equals(appValidationOutput(), other.appValidationOutput())
                && Objects.equals(serverValidationOutput(), other.serverValidationOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidationOutput").add("ValidationId", validationId()).add("Name", name())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("LatestValidationTime", latestValidationTime()).add("AppValidationOutput", appValidationOutput())
                .add("ServerValidationOutput", serverValidationOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "validationId":
            return Optional.ofNullable(clazz.cast(validationId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "latestValidationTime":
            return Optional.ofNullable(clazz.cast(latestValidationTime()));
        case "appValidationOutput":
            return Optional.ofNullable(clazz.cast(appValidationOutput()));
        case "serverValidationOutput":
            return Optional.ofNullable(clazz.cast(serverValidationOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationOutput, T> g) {
        return obj -> g.apply((ValidationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationOutput> {
        /**
         * <p>
         * The ID of the validation.
         * </p>
         * 
         * @param validationId
         *        The ID of the validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationId(String validationId);

        /**
         * <p>
         * The name of the validation.
         * </p>
         * 
         * @param name
         *        The name of the validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the validation.
         * </p>
         * 
         * @param status
         *        The status of the validation.
         * @see ValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the validation.
         * </p>
         * 
         * @param status
         *        The status of the validation.
         * @see ValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationStatus
         */
        Builder status(ValidationStatus status);

        /**
         * <p>
         * The status message.
         * </p>
         * 
         * @param statusMessage
         *        The status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The latest time that the validation was performed.
         * </p>
         * 
         * @param latestValidationTime
         *        The latest time that the validation was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestValidationTime(Instant latestValidationTime);

        /**
         * <p>
         * The output from validating an application.
         * </p>
         * 
         * @param appValidationOutput
         *        The output from validating an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appValidationOutput(AppValidationOutput appValidationOutput);

        /**
         * <p>
         * The output from validating an application.
         * </p>
         * This is a convenience that creates an instance of the {@link AppValidationOutput.Builder} avoiding the need
         * to create one manually via {@link AppValidationOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link AppValidationOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #appValidationOutput(AppValidationOutput)}.
         * 
         * @param appValidationOutput
         *        a consumer that will call methods on {@link AppValidationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appValidationOutput(AppValidationOutput)
         */
        default Builder appValidationOutput(Consumer<AppValidationOutput.Builder> appValidationOutput) {
            return appValidationOutput(AppValidationOutput.builder().applyMutation(appValidationOutput).build());
        }

        /**
         * <p>
         * The output from validation an instance.
         * </p>
         * 
         * @param serverValidationOutput
         *        The output from validation an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverValidationOutput(ServerValidationOutput serverValidationOutput);

        /**
         * <p>
         * The output from validation an instance.
         * </p>
         * This is a convenience that creates an instance of the {@link ServerValidationOutput.Builder} avoiding the
         * need to create one manually via {@link ServerValidationOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServerValidationOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #serverValidationOutput(ServerValidationOutput)}.
         * 
         * @param serverValidationOutput
         *        a consumer that will call methods on {@link ServerValidationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverValidationOutput(ServerValidationOutput)
         */
        default Builder serverValidationOutput(Consumer<ServerValidationOutput.Builder> serverValidationOutput) {
            return serverValidationOutput(ServerValidationOutput.builder().applyMutation(serverValidationOutput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String validationId;

        private String name;

        private String status;

        private String statusMessage;

        private Instant latestValidationTime;

        private AppValidationOutput appValidationOutput;

        private ServerValidationOutput serverValidationOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationOutput model) {
            validationId(model.validationId);
            name(model.name);
            status(model.status);
            statusMessage(model.statusMessage);
            latestValidationTime(model.latestValidationTime);
            appValidationOutput(model.appValidationOutput);
            serverValidationOutput(model.serverValidationOutput);
        }

        public final String getValidationId() {
            return validationId;
        }

        @Override
        public final Builder validationId(String validationId) {
            this.validationId = validationId;
            return this;
        }

        public final void setValidationId(String validationId) {
            this.validationId = validationId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ValidationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Instant getLatestValidationTime() {
            return latestValidationTime;
        }

        @Override
        public final Builder latestValidationTime(Instant latestValidationTime) {
            this.latestValidationTime = latestValidationTime;
            return this;
        }

        public final void setLatestValidationTime(Instant latestValidationTime) {
            this.latestValidationTime = latestValidationTime;
        }

        public final AppValidationOutput.Builder getAppValidationOutput() {
            return appValidationOutput != null ? appValidationOutput.toBuilder() : null;
        }

        @Override
        public final Builder appValidationOutput(AppValidationOutput appValidationOutput) {
            this.appValidationOutput = appValidationOutput;
            return this;
        }

        public final void setAppValidationOutput(AppValidationOutput.BuilderImpl appValidationOutput) {
            this.appValidationOutput = appValidationOutput != null ? appValidationOutput.build() : null;
        }

        public final ServerValidationOutput.Builder getServerValidationOutput() {
            return serverValidationOutput != null ? serverValidationOutput.toBuilder() : null;
        }

        @Override
        public final Builder serverValidationOutput(ServerValidationOutput serverValidationOutput) {
            this.serverValidationOutput = serverValidationOutput;
            return this;
        }

        public final void setServerValidationOutput(ServerValidationOutput.BuilderImpl serverValidationOutput) {
            this.serverValidationOutput = serverValidationOutput != null ? serverValidationOutput.build() : null;
        }

        @Override
        public ValidationOutput build() {
            return new ValidationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
