/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectorsResponse extends SmsResponse implements
        ToCopyableBuilder<GetConnectorsResponse.Builder, GetConnectorsResponse> {
    private static final SdkField<List<Connector>> CONNECTOR_LIST_FIELD = SdkField
            .<List<Connector>> builder(MarshallingType.LIST)
            .memberName("connectorList")
            .getter(getter(GetConnectorsResponse::connectorList))
            .setter(setter(Builder::connectorList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Connector> builder(MarshallingType.SDK_POJO)
                                            .constructor(Connector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetConnectorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Connector> connectorList;

    private final String nextToken;

    private GetConnectorsResponse(BuilderImpl builder) {
        super(builder);
        this.connectorList = builder.connectorList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ConnectorList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasConnectorList() {
        return connectorList != null && !(connectorList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the registered connectors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectorList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the registered connectors.
     */
    public final List<Connector> connectorList() {
        return connectorList;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorList() ? connectorList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectorsResponse)) {
            return false;
        }
        GetConnectorsResponse other = (GetConnectorsResponse) obj;
        return hasConnectorList() == other.hasConnectorList() && Objects.equals(connectorList(), other.connectorList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectorsResponse").add("ConnectorList", hasConnectorList() ? connectorList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorList":
            return Optional.ofNullable(clazz.cast(connectorList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectorsResponse, T> g) {
        return obj -> g.apply((GetConnectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetConnectorsResponse> {
        /**
         * <p>
         * Information about the registered connectors.
         * </p>
         * 
         * @param connectorList
         *        Information about the registered connectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorList(Collection<Connector> connectorList);

        /**
         * <p>
         * Information about the registered connectors.
         * </p>
         * 
         * @param connectorList
         *        Information about the registered connectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorList(Connector... connectorList);

        /**
         * <p>
         * Information about the registered connectors.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Connector>.Builder} avoiding the need to
         * create one manually via {@link List<Connector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Connector>.Builder#build()} is called immediately and its
         * result is passed to {@link #connectorList(List<Connector>)}.
         * 
         * @param connectorList
         *        a consumer that will call methods on {@link List<Connector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorList(List<Connector>)
         */
        Builder connectorList(Consumer<Connector.Builder>... connectorList);

        /**
         * <p>
         * The token required to retrieve the next set of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SmsResponse.BuilderImpl implements Builder {
        private List<Connector> connectorList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectorsResponse model) {
            super(model);
            connectorList(model.connectorList);
            nextToken(model.nextToken);
        }

        public final List<Connector.Builder> getConnectorList() {
            List<Connector.Builder> result = ConnectorListCopier.copyToBuilder(this.connectorList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder connectorList(Collection<Connector> connectorList) {
            this.connectorList = ConnectorListCopier.copy(connectorList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorList(Connector... connectorList) {
            connectorList(Arrays.asList(connectorList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorList(Consumer<Connector.Builder>... connectorList) {
            connectorList(Stream.of(connectorList).map(c -> Connector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConnectorList(Collection<Connector.BuilderImpl> connectorList) {
            this.connectorList = ConnectorListCopier.copyFromBuilder(connectorList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetConnectorsResponse build() {
            return new GetConnectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
