/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReplicationJobsResponse extends SmsResponse implements
        ToCopyableBuilder<GetReplicationJobsResponse.Builder, GetReplicationJobsResponse> {
    private static final SdkField<List<ReplicationJob>> REPLICATION_JOB_LIST_FIELD = SdkField
            .<List<ReplicationJob>> builder(MarshallingType.LIST)
            .memberName("replicationJobList")
            .getter(getter(GetReplicationJobsResponse::replicationJobList))
            .setter(setter(Builder::replicationJobList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJobList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetReplicationJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_JOB_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ReplicationJob> replicationJobList;

    private final String nextToken;

    private GetReplicationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.replicationJobList = builder.replicationJobList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationJobList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationJobList() {
        return replicationJobList != null && !(replicationJobList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the replication jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationJobList} method.
     * </p>
     * 
     * @return Information about the replication jobs.
     */
    public final List<ReplicationJob> replicationJobList() {
        return replicationJobList;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationJobList() ? replicationJobList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReplicationJobsResponse)) {
            return false;
        }
        GetReplicationJobsResponse other = (GetReplicationJobsResponse) obj;
        return hasReplicationJobList() == other.hasReplicationJobList()
                && Objects.equals(replicationJobList(), other.replicationJobList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReplicationJobsResponse")
                .add("ReplicationJobList", hasReplicationJobList() ? replicationJobList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replicationJobList":
            return Optional.ofNullable(clazz.cast(replicationJobList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReplicationJobsResponse, T> g) {
        return obj -> g.apply((GetReplicationJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetReplicationJobsResponse> {
        /**
         * <p>
         * Information about the replication jobs.
         * </p>
         * 
         * @param replicationJobList
         *        Information about the replication jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationJobList(Collection<ReplicationJob> replicationJobList);

        /**
         * <p>
         * Information about the replication jobs.
         * </p>
         * 
         * @param replicationJobList
         *        Information about the replication jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationJobList(ReplicationJob... replicationJobList);

        /**
         * <p>
         * Information about the replication jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicationJob>.Builder} avoiding the need
         * to create one manually via {@link List<ReplicationJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationJob>.Builder#build()} is called immediately and
         * its result is passed to {@link #replicationJobList(List<ReplicationJob>)}.
         * 
         * @param replicationJobList
         *        a consumer that will call methods on {@link List<ReplicationJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationJobList(List<ReplicationJob>)
         */
        Builder replicationJobList(Consumer<ReplicationJob.Builder>... replicationJobList);

        /**
         * <p>
         * The token required to retrieve the next set of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SmsResponse.BuilderImpl implements Builder {
        private List<ReplicationJob> replicationJobList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReplicationJobsResponse model) {
            super(model);
            replicationJobList(model.replicationJobList);
            nextToken(model.nextToken);
        }

        public final List<ReplicationJob.Builder> getReplicationJobList() {
            List<ReplicationJob.Builder> result = ReplicationJobListCopier.copyToBuilder(this.replicationJobList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationJobList(Collection<ReplicationJob.BuilderImpl> replicationJobList) {
            this.replicationJobList = ReplicationJobListCopier.copyFromBuilder(replicationJobList);
        }

        @Override
        @Transient
        public final Builder replicationJobList(Collection<ReplicationJob> replicationJobList) {
            this.replicationJobList = ReplicationJobListCopier.copy(replicationJobList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicationJobList(ReplicationJob... replicationJobList) {
            replicationJobList(Arrays.asList(replicationJobList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicationJobList(Consumer<ReplicationJob.Builder>... replicationJobList) {
            replicationJobList(Stream.of(replicationJobList).map(c -> ReplicationJob.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetReplicationJobsResponse build() {
            return new GetReplicationJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
