/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the latest launch of an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchDetails implements SdkPojo, Serializable, ToCopyableBuilder<LaunchDetails.Builder, LaunchDetails> {
    private static final SdkField<Instant> LATEST_LAUNCH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("latestLaunchTime").getter(getter(LaunchDetails::latestLaunchTime))
            .setter(setter(Builder::latestLaunchTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestLaunchTime").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stackName").getter(getter(LaunchDetails::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackName").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stackId").getter(getter(LaunchDetails::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_LAUNCH_TIME_FIELD,
            STACK_NAME_FIELD, STACK_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant latestLaunchTime;

    private final String stackName;

    private final String stackId;

    private LaunchDetails(BuilderImpl builder) {
        this.latestLaunchTime = builder.latestLaunchTime;
        this.stackName = builder.stackName;
        this.stackId = builder.stackId;
    }

    /**
     * <p>
     * The latest time that this application was launched successfully.
     * </p>
     * 
     * @return The latest time that this application was launched successfully.
     */
    public final Instant latestLaunchTime() {
        return latestLaunchTime;
    }

    /**
     * <p>
     * The name of the latest stack launched for this application.
     * </p>
     * 
     * @return The name of the latest stack launched for this application.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The ID of the latest stack launched for this application.
     * </p>
     * 
     * @return The ID of the latest stack launched for this application.
     */
    public final String stackId() {
        return stackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(latestLaunchTime());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchDetails)) {
            return false;
        }
        LaunchDetails other = (LaunchDetails) obj;
        return Objects.equals(latestLaunchTime(), other.latestLaunchTime()) && Objects.equals(stackName(), other.stackName())
                && Objects.equals(stackId(), other.stackId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchDetails").add("LatestLaunchTime", latestLaunchTime()).add("StackName", stackName())
                .add("StackId", stackId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "latestLaunchTime":
            return Optional.ofNullable(clazz.cast(latestLaunchTime()));
        case "stackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "stackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchDetails, T> g) {
        return obj -> g.apply((LaunchDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchDetails> {
        /**
         * <p>
         * The latest time that this application was launched successfully.
         * </p>
         * 
         * @param latestLaunchTime
         *        The latest time that this application was launched successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestLaunchTime(Instant latestLaunchTime);

        /**
         * <p>
         * The name of the latest stack launched for this application.
         * </p>
         * 
         * @param stackName
         *        The name of the latest stack launched for this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The ID of the latest stack launched for this application.
         * </p>
         * 
         * @param stackId
         *        The ID of the latest stack launched for this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);
    }

    static final class BuilderImpl implements Builder {
        private Instant latestLaunchTime;

        private String stackName;

        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchDetails model) {
            latestLaunchTime(model.latestLaunchTime);
            stackName(model.stackName);
            stackId(model.stackId);
        }

        public final Instant getLatestLaunchTime() {
            return latestLaunchTime;
        }

        public final void setLatestLaunchTime(Instant latestLaunchTime) {
            this.latestLaunchTime = latestLaunchTime;
        }

        @Override
        @Transient
        public final Builder latestLaunchTime(Instant latestLaunchTime) {
            this.latestLaunchTime = latestLaunchTime;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        @Transient
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        @Transient
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        @Override
        public LaunchDetails build() {
            return new LaunchDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
