/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a replication run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationRun implements SdkPojo, Serializable, ToCopyableBuilder<ReplicationRun.Builder, ReplicationRun> {
    private static final SdkField<String> REPLICATION_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationRunId").getter(getter(ReplicationRun::replicationRunId))
            .setter(setter(Builder::replicationRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationRunId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ReplicationRun::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ReplicationRun::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<ReplicationRunStageDetails> STAGE_DETAILS_FIELD = SdkField
            .<ReplicationRunStageDetails> builder(MarshallingType.SDK_POJO).memberName("stageDetails")
            .getter(getter(ReplicationRun::stageDetails)).setter(setter(Builder::stageDetails))
            .constructor(ReplicationRunStageDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageDetails").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ReplicationRun::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("amiId")
            .getter(getter(ReplicationRun::amiId)).setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiId").build()).build();

    private static final SdkField<Instant> SCHEDULED_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("scheduledStartTime").getter(getter(ReplicationRun::scheduledStartTime))
            .setter(setter(Builder::scheduledStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledStartTime").build())
            .build();

    private static final SdkField<Instant> COMPLETED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("completedTime").getter(getter(ReplicationRun::completedTime)).setter(setter(Builder::completedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ReplicationRun::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("encrypted").getter(getter(ReplicationRun::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(ReplicationRun::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_RUN_ID_FIELD,
            STATE_FIELD, TYPE_FIELD, STAGE_DETAILS_FIELD, STATUS_MESSAGE_FIELD, AMI_ID_FIELD, SCHEDULED_START_TIME_FIELD,
            COMPLETED_TIME_FIELD, DESCRIPTION_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationRunId;

    private final String state;

    private final String type;

    private final ReplicationRunStageDetails stageDetails;

    private final String statusMessage;

    private final String amiId;

    private final Instant scheduledStartTime;

    private final Instant completedTime;

    private final String description;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private ReplicationRun(BuilderImpl builder) {
        this.replicationRunId = builder.replicationRunId;
        this.state = builder.state;
        this.type = builder.type;
        this.stageDetails = builder.stageDetails;
        this.statusMessage = builder.statusMessage;
        this.amiId = builder.amiId;
        this.scheduledStartTime = builder.scheduledStartTime;
        this.completedTime = builder.completedTime;
        this.description = builder.description;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The ID of the replication run.
     * </p>
     * 
     * @return The ID of the replication run.
     */
    public final String replicationRunId() {
        return replicationRunId;
    }

    /**
     * <p>
     * The state of the replication run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReplicationRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the replication run.
     * @see ReplicationRunState
     */
    public final ReplicationRunState state() {
        return ReplicationRunState.fromValue(state);
    }

    /**
     * <p>
     * The state of the replication run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReplicationRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the replication run.
     * @see ReplicationRunState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The type of replication run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReplicationRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of replication run.
     * @see ReplicationRunType
     */
    public final ReplicationRunType type() {
        return ReplicationRunType.fromValue(type);
    }

    /**
     * <p>
     * The type of replication run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReplicationRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of replication run.
     * @see ReplicationRunType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Details about the current stage of the replication run.
     * </p>
     * 
     * @return Details about the current stage of the replication run.
     */
    public final ReplicationRunStageDetails stageDetails() {
        return stageDetails;
    }

    /**
     * <p>
     * The description of the current status of the replication job.
     * </p>
     * 
     * @return The description of the current status of the replication job.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI) from the replication run.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI) from the replication run.
     */
    public final String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The start time of the next replication run.
     * </p>
     * 
     * @return The start time of the next replication run.
     */
    public final Instant scheduledStartTime() {
        return scheduledStartTime;
    }

    /**
     * <p>
     * The completion time of the last replication run.
     * </p>
     * 
     * @return The completion time of the last replication run.
     */
    public final Instant completedTime() {
        return completedTime;
    }

    /**
     * <p>
     * The description of the replication run.
     * </p>
     * 
     * @return The description of the replication run.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the replication run should produce an encrypted AMI.
     * </p>
     * 
     * @return Indicates whether the replication run should produce an encrypted AMI.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KMS key ID
     * </p>
     * </li>
     * <li>
     * <p>
     * KMS key alias
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN referring to the KMS key ID
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN referring to the KMS key alias
     * </p>
     * </li>
     * </ul>
     * <p>
     * If encrypted is <i>true</i> but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is
     * used.
     * </p>
     * 
     * @return The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         KMS key ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         KMS key alias
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN referring to the KMS key ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN referring to the KMS key alias
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If encrypted is <i>true</i> but a KMS key ID is not specified, the customer's default KMS key for Amazon
     *         EBS is used.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationRunId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stageDetails());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(completedTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRun)) {
            return false;
        }
        ReplicationRun other = (ReplicationRun) obj;
        return Objects.equals(replicationRunId(), other.replicationRunId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(stageDetails(), other.stageDetails()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(amiId(), other.amiId()) && Objects.equals(scheduledStartTime(), other.scheduledStartTime())
                && Objects.equals(completedTime(), other.completedTime()) && Objects.equals(description(), other.description())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationRun").add("ReplicationRunId", replicationRunId()).add("State", stateAsString())
                .add("Type", typeAsString()).add("StageDetails", stageDetails()).add("StatusMessage", statusMessage())
                .add("AmiId", amiId()).add("ScheduledStartTime", scheduledStartTime()).add("CompletedTime", completedTime())
                .add("Description", description()).add("Encrypted", encrypted()).add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replicationRunId":
            return Optional.ofNullable(clazz.cast(replicationRunId()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "stageDetails":
            return Optional.ofNullable(clazz.cast(stageDetails()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "amiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "scheduledStartTime":
            return Optional.ofNullable(clazz.cast(scheduledStartTime()));
        case "completedTime":
            return Optional.ofNullable(clazz.cast(completedTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationRun, T> g) {
        return obj -> g.apply((ReplicationRun) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationRun> {
        /**
         * <p>
         * The ID of the replication run.
         * </p>
         * 
         * @param replicationRunId
         *        The ID of the replication run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRunId(String replicationRunId);

        /**
         * <p>
         * The state of the replication run.
         * </p>
         * 
         * @param state
         *        The state of the replication run.
         * @see ReplicationRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationRunState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the replication run.
         * </p>
         * 
         * @param state
         *        The state of the replication run.
         * @see ReplicationRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationRunState
         */
        Builder state(ReplicationRunState state);

        /**
         * <p>
         * The type of replication run.
         * </p>
         * 
         * @param type
         *        The type of replication run.
         * @see ReplicationRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationRunType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of replication run.
         * </p>
         * 
         * @param type
         *        The type of replication run.
         * @see ReplicationRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationRunType
         */
        Builder type(ReplicationRunType type);

        /**
         * <p>
         * Details about the current stage of the replication run.
         * </p>
         * 
         * @param stageDetails
         *        Details about the current stage of the replication run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageDetails(ReplicationRunStageDetails stageDetails);

        /**
         * <p>
         * Details about the current stage of the replication run.
         * </p>
         * This is a convenience that creates an instance of the {@link ReplicationRunStageDetails.Builder} avoiding the
         * need to create one manually via {@link ReplicationRunStageDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplicationRunStageDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #stageDetails(ReplicationRunStageDetails)}.
         * 
         * @param stageDetails
         *        a consumer that will call methods on {@link ReplicationRunStageDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stageDetails(ReplicationRunStageDetails)
         */
        default Builder stageDetails(Consumer<ReplicationRunStageDetails.Builder> stageDetails) {
            return stageDetails(ReplicationRunStageDetails.builder().applyMutation(stageDetails).build());
        }

        /**
         * <p>
         * The description of the current status of the replication job.
         * </p>
         * 
         * @param statusMessage
         *        The description of the current status of the replication job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI) from the replication run.
         * </p>
         * 
         * @param amiId
         *        The ID of the Amazon Machine Image (AMI) from the replication run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The start time of the next replication run.
         * </p>
         * 
         * @param scheduledStartTime
         *        The start time of the next replication run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledStartTime(Instant scheduledStartTime);

        /**
         * <p>
         * The completion time of the last replication run.
         * </p>
         * 
         * @param completedTime
         *        The completion time of the last replication run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedTime(Instant completedTime);

        /**
         * <p>
         * The description of the replication run.
         * </p>
         * 
         * @param description
         *        The description of the replication run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the replication run should produce an encrypted AMI.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the replication run should produce an encrypted AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KMS key ID
         * </p>
         * </li>
         * <li>
         * <p>
         * KMS key alias
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN referring to the KMS key ID
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN referring to the KMS key alias
         * </p>
         * </li>
         * </ul>
         * <p>
         * If encrypted is <i>true</i> but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS
         * is used.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        KMS key ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KMS key alias
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN referring to the KMS key ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN referring to the KMS key alias
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If encrypted is <i>true</i> but a KMS key ID is not specified, the customer's default KMS key for
         *        Amazon EBS is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String replicationRunId;

        private String state;

        private String type;

        private ReplicationRunStageDetails stageDetails;

        private String statusMessage;

        private String amiId;

        private Instant scheduledStartTime;

        private Instant completedTime;

        private String description;

        private Boolean encrypted;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationRun model) {
            replicationRunId(model.replicationRunId);
            state(model.state);
            type(model.type);
            stageDetails(model.stageDetails);
            statusMessage(model.statusMessage);
            amiId(model.amiId);
            scheduledStartTime(model.scheduledStartTime);
            completedTime(model.completedTime);
            description(model.description);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getReplicationRunId() {
            return replicationRunId;
        }

        public final void setReplicationRunId(String replicationRunId) {
            this.replicationRunId = replicationRunId;
        }

        @Override
        @Transient
        public final Builder replicationRunId(String replicationRunId) {
            this.replicationRunId = replicationRunId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(ReplicationRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ReplicationRunType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ReplicationRunStageDetails.Builder getStageDetails() {
            return stageDetails != null ? stageDetails.toBuilder() : null;
        }

        public final void setStageDetails(ReplicationRunStageDetails.BuilderImpl stageDetails) {
            this.stageDetails = stageDetails != null ? stageDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder stageDetails(ReplicationRunStageDetails stageDetails) {
            this.stageDetails = stageDetails;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getAmiId() {
            return amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        @Transient
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final Instant getScheduledStartTime() {
            return scheduledStartTime;
        }

        public final void setScheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
        }

        @Override
        @Transient
        public final Builder scheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
            return this;
        }

        public final Instant getCompletedTime() {
            return completedTime;
        }

        public final void setCompletedTime(Instant completedTime) {
            this.completedTime = completedTime;
        }

        @Override
        @Transient
        public final Builder completedTime(Instant completedTime) {
            this.completedTime = completedTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public ReplicationRun build() {
            return new ReplicationRun(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
