/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for validating an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerGroupValidationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerGroupValidationConfiguration.Builder, ServerGroupValidationConfiguration> {
    private static final SdkField<String> SERVER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverGroupId").getter(getter(ServerGroupValidationConfiguration::serverGroupId))
            .setter(setter(Builder::serverGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupId").build()).build();

    private static final SdkField<List<ServerValidationConfiguration>> SERVER_VALIDATION_CONFIGURATIONS_FIELD = SdkField
            .<List<ServerValidationConfiguration>> builder(MarshallingType.LIST)
            .memberName("serverValidationConfigurations")
            .getter(getter(ServerGroupValidationConfiguration::serverValidationConfigurations))
            .setter(setter(Builder::serverValidationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverValidationConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerValidationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerValidationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_GROUP_ID_FIELD,
            SERVER_VALIDATION_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverGroupId;

    private final List<ServerValidationConfiguration> serverValidationConfigurations;

    private ServerGroupValidationConfiguration(BuilderImpl builder) {
        this.serverGroupId = builder.serverGroupId;
        this.serverValidationConfigurations = builder.serverValidationConfigurations;
    }

    /**
     * <p>
     * The ID of the server group.
     * </p>
     * 
     * @return The ID of the server group.
     */
    public final String serverGroupId() {
        return serverGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerValidationConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasServerValidationConfigurations() {
        return serverValidationConfigurations != null && !(serverValidationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The validation configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerValidationConfigurations} method.
     * </p>
     * 
     * @return The validation configuration.
     */
    public final List<ServerValidationConfiguration> serverValidationConfigurations() {
        return serverValidationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverGroupId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasServerValidationConfigurations() ? serverValidationConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerGroupValidationConfiguration)) {
            return false;
        }
        ServerGroupValidationConfiguration other = (ServerGroupValidationConfiguration) obj;
        return Objects.equals(serverGroupId(), other.serverGroupId())
                && hasServerValidationConfigurations() == other.hasServerValidationConfigurations()
                && Objects.equals(serverValidationConfigurations(), other.serverValidationConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ServerGroupValidationConfiguration")
                .add("ServerGroupId", serverGroupId())
                .add("ServerValidationConfigurations",
                        hasServerValidationConfigurations() ? serverValidationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverGroupId":
            return Optional.ofNullable(clazz.cast(serverGroupId()));
        case "serverValidationConfigurations":
            return Optional.ofNullable(clazz.cast(serverValidationConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerGroupValidationConfiguration, T> g) {
        return obj -> g.apply((ServerGroupValidationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerGroupValidationConfiguration> {
        /**
         * <p>
         * The ID of the server group.
         * </p>
         * 
         * @param serverGroupId
         *        The ID of the server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupId(String serverGroupId);

        /**
         * <p>
         * The validation configuration.
         * </p>
         * 
         * @param serverValidationConfigurations
         *        The validation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverValidationConfigurations(Collection<ServerValidationConfiguration> serverValidationConfigurations);

        /**
         * <p>
         * The validation configuration.
         * </p>
         * 
         * @param serverValidationConfigurations
         *        The validation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverValidationConfigurations(ServerValidationConfiguration... serverValidationConfigurations);

        /**
         * <p>
         * The validation configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServerValidationConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<ServerValidationConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServerValidationConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #serverValidationConfigurations(List<ServerValidationConfiguration>)}.
         * 
         * @param serverValidationConfigurations
         *        a consumer that will call methods on {@link List<ServerValidationConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverValidationConfigurations(List<ServerValidationConfiguration>)
         */
        Builder serverValidationConfigurations(Consumer<ServerValidationConfiguration.Builder>... serverValidationConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String serverGroupId;

        private List<ServerValidationConfiguration> serverValidationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerGroupValidationConfiguration model) {
            serverGroupId(model.serverGroupId);
            serverValidationConfigurations(model.serverValidationConfigurations);
        }

        public final String getServerGroupId() {
            return serverGroupId;
        }

        public final void setServerGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
        }

        @Override
        @Transient
        public final Builder serverGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
            return this;
        }

        public final List<ServerValidationConfiguration.Builder> getServerValidationConfigurations() {
            List<ServerValidationConfiguration.Builder> result = ServerValidationConfigurationsCopier
                    .copyToBuilder(this.serverValidationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerValidationConfigurations(
                Collection<ServerValidationConfiguration.BuilderImpl> serverValidationConfigurations) {
            this.serverValidationConfigurations = ServerValidationConfigurationsCopier
                    .copyFromBuilder(serverValidationConfigurations);
        }

        @Override
        @Transient
        public final Builder serverValidationConfigurations(
                Collection<ServerValidationConfiguration> serverValidationConfigurations) {
            this.serverValidationConfigurations = ServerValidationConfigurationsCopier.copy(serverValidationConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serverValidationConfigurations(ServerValidationConfiguration... serverValidationConfigurations) {
            serverValidationConfigurations(Arrays.asList(serverValidationConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serverValidationConfigurations(
                Consumer<ServerValidationConfiguration.Builder>... serverValidationConfigurations) {
            serverValidationConfigurations(Stream.of(serverValidationConfigurations)
                    .map(c -> ServerValidationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServerGroupValidationConfiguration build() {
            return new ServerGroupValidationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
