/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Replication configuration of a server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerReplicationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerReplicationConfiguration.Builder, ServerReplicationConfiguration> {
    private static final SdkField<Server> SERVER_FIELD = SdkField.<Server> builder(MarshallingType.SDK_POJO).memberName("server")
            .getter(getter(ServerReplicationConfiguration::server)).setter(setter(Builder::server)).constructor(Server::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("server").build()).build();

    private static final SdkField<ServerReplicationParameters> SERVER_REPLICATION_PARAMETERS_FIELD = SdkField
            .<ServerReplicationParameters> builder(MarshallingType.SDK_POJO)
            .memberName("serverReplicationParameters")
            .getter(getter(ServerReplicationConfiguration::serverReplicationParameters))
            .setter(setter(Builder::serverReplicationParameters))
            .constructor(ServerReplicationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverReplicationParameters")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_FIELD,
            SERVER_REPLICATION_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Server server;

    private final ServerReplicationParameters serverReplicationParameters;

    private ServerReplicationConfiguration(BuilderImpl builder) {
        this.server = builder.server;
        this.serverReplicationParameters = builder.serverReplicationParameters;
    }

    /**
     * <p>
     * The ID of the server with which this replication configuration is associated.
     * </p>
     * 
     * @return The ID of the server with which this replication configuration is associated.
     */
    public final Server server() {
        return server;
    }

    /**
     * <p>
     * The parameters for replicating the server.
     * </p>
     * 
     * @return The parameters for replicating the server.
     */
    public final ServerReplicationParameters serverReplicationParameters() {
        return serverReplicationParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(server());
        hashCode = 31 * hashCode + Objects.hashCode(serverReplicationParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerReplicationConfiguration)) {
            return false;
        }
        ServerReplicationConfiguration other = (ServerReplicationConfiguration) obj;
        return Objects.equals(server(), other.server())
                && Objects.equals(serverReplicationParameters(), other.serverReplicationParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerReplicationConfiguration").add("Server", server())
                .add("ServerReplicationParameters", serverReplicationParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "server":
            return Optional.ofNullable(clazz.cast(server()));
        case "serverReplicationParameters":
            return Optional.ofNullable(clazz.cast(serverReplicationParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerReplicationConfiguration, T> g) {
        return obj -> g.apply((ServerReplicationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerReplicationConfiguration> {
        /**
         * <p>
         * The ID of the server with which this replication configuration is associated.
         * </p>
         * 
         * @param server
         *        The ID of the server with which this replication configuration is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder server(Server server);

        /**
         * <p>
         * The ID of the server with which this replication configuration is associated.
         * </p>
         * This is a convenience that creates an instance of the {@link Server.Builder} avoiding the need to create one
         * manually via {@link Server#builder()}.
         *
         * When the {@link Consumer} completes, {@link Server.Builder#build()} is called immediately and its result is
         * passed to {@link #server(Server)}.
         * 
         * @param server
         *        a consumer that will call methods on {@link Server.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #server(Server)
         */
        default Builder server(Consumer<Server.Builder> server) {
            return server(Server.builder().applyMutation(server).build());
        }

        /**
         * <p>
         * The parameters for replicating the server.
         * </p>
         * 
         * @param serverReplicationParameters
         *        The parameters for replicating the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverReplicationParameters(ServerReplicationParameters serverReplicationParameters);

        /**
         * <p>
         * The parameters for replicating the server.
         * </p>
         * This is a convenience that creates an instance of the {@link ServerReplicationParameters.Builder} avoiding
         * the need to create one manually via {@link ServerReplicationParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServerReplicationParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #serverReplicationParameters(ServerReplicationParameters)}.
         * 
         * @param serverReplicationParameters
         *        a consumer that will call methods on {@link ServerReplicationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverReplicationParameters(ServerReplicationParameters)
         */
        default Builder serverReplicationParameters(Consumer<ServerReplicationParameters.Builder> serverReplicationParameters) {
            return serverReplicationParameters(ServerReplicationParameters.builder().applyMutation(serverReplicationParameters)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Server server;

        private ServerReplicationParameters serverReplicationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerReplicationConfiguration model) {
            server(model.server);
            serverReplicationParameters(model.serverReplicationParameters);
        }

        public final Server.Builder getServer() {
            return server != null ? server.toBuilder() : null;
        }

        public final void setServer(Server.BuilderImpl server) {
            this.server = server != null ? server.build() : null;
        }

        @Override
        @Transient
        public final Builder server(Server server) {
            this.server = server;
            return this;
        }

        public final ServerReplicationParameters.Builder getServerReplicationParameters() {
            return serverReplicationParameters != null ? serverReplicationParameters.toBuilder() : null;
        }

        public final void setServerReplicationParameters(ServerReplicationParameters.BuilderImpl serverReplicationParameters) {
            this.serverReplicationParameters = serverReplicationParameters != null ? serverReplicationParameters.build() : null;
        }

        @Override
        @Transient
        public final Builder serverReplicationParameters(ServerReplicationParameters serverReplicationParameters) {
            this.serverReplicationParameters = serverReplicationParameters;
            return this;
        }

        @Override
        public ServerReplicationConfiguration build() {
            return new ServerReplicationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
