/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a VM server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VmServer implements SdkPojo, Serializable, ToCopyableBuilder<VmServer.Builder, VmServer> {
    private static final SdkField<VmServerAddress> VM_SERVER_ADDRESS_FIELD = SdkField
            .<VmServerAddress> builder(MarshallingType.SDK_POJO).memberName("vmServerAddress")
            .getter(getter(VmServer::vmServerAddress)).setter(setter(Builder::vmServerAddress))
            .constructor(VmServerAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmServerAddress").build()).build();

    private static final SdkField<String> VM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vmName")
            .getter(getter(VmServer::vmName)).setter(setter(Builder::vmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmName").build()).build();

    private static final SdkField<String> VM_MANAGER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vmManagerName").getter(getter(VmServer::vmManagerName)).setter(setter(Builder::vmManagerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmManagerName").build()).build();

    private static final SdkField<String> VM_MANAGER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vmManagerType").getter(getter(VmServer::vmManagerTypeAsString)).setter(setter(Builder::vmManagerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmManagerType").build()).build();

    private static final SdkField<String> VM_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vmPath")
            .getter(getter(VmServer::vmPath)).setter(setter(Builder::vmPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VM_SERVER_ADDRESS_FIELD,
            VM_NAME_FIELD, VM_MANAGER_NAME_FIELD, VM_MANAGER_TYPE_FIELD, VM_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final VmServerAddress vmServerAddress;

    private final String vmName;

    private final String vmManagerName;

    private final String vmManagerType;

    private final String vmPath;

    private VmServer(BuilderImpl builder) {
        this.vmServerAddress = builder.vmServerAddress;
        this.vmName = builder.vmName;
        this.vmManagerName = builder.vmManagerName;
        this.vmManagerType = builder.vmManagerType;
        this.vmPath = builder.vmPath;
    }

    /**
     * <p>
     * The VM server location.
     * </p>
     * 
     * @return The VM server location.
     */
    public final VmServerAddress vmServerAddress() {
        return vmServerAddress;
    }

    /**
     * <p>
     * The name of the VM.
     * </p>
     * 
     * @return The name of the VM.
     */
    public final String vmName() {
        return vmName;
    }

    /**
     * <p>
     * The name of the VM manager.
     * </p>
     * 
     * @return The name of the VM manager.
     */
    public final String vmManagerName() {
        return vmManagerName;
    }

    /**
     * <p>
     * The type of VM management product.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vmManagerType}
     * will return {@link VmManagerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vmManagerTypeAsString}.
     * </p>
     * 
     * @return The type of VM management product.
     * @see VmManagerType
     */
    public final VmManagerType vmManagerType() {
        return VmManagerType.fromValue(vmManagerType);
    }

    /**
     * <p>
     * The type of VM management product.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vmManagerType}
     * will return {@link VmManagerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vmManagerTypeAsString}.
     * </p>
     * 
     * @return The type of VM management product.
     * @see VmManagerType
     */
    public final String vmManagerTypeAsString() {
        return vmManagerType;
    }

    /**
     * <p>
     * The VM folder path in the vCenter Server virtual machine inventory tree.
     * </p>
     * 
     * @return The VM folder path in the vCenter Server virtual machine inventory tree.
     */
    public final String vmPath() {
        return vmPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vmServerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(vmName());
        hashCode = 31 * hashCode + Objects.hashCode(vmManagerName());
        hashCode = 31 * hashCode + Objects.hashCode(vmManagerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vmPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VmServer)) {
            return false;
        }
        VmServer other = (VmServer) obj;
        return Objects.equals(vmServerAddress(), other.vmServerAddress()) && Objects.equals(vmName(), other.vmName())
                && Objects.equals(vmManagerName(), other.vmManagerName())
                && Objects.equals(vmManagerTypeAsString(), other.vmManagerTypeAsString())
                && Objects.equals(vmPath(), other.vmPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VmServer").add("VmServerAddress", vmServerAddress()).add("VmName", vmName())
                .add("VmManagerName", vmManagerName()).add("VmManagerType", vmManagerTypeAsString()).add("VmPath", vmPath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vmServerAddress":
            return Optional.ofNullable(clazz.cast(vmServerAddress()));
        case "vmName":
            return Optional.ofNullable(clazz.cast(vmName()));
        case "vmManagerName":
            return Optional.ofNullable(clazz.cast(vmManagerName()));
        case "vmManagerType":
            return Optional.ofNullable(clazz.cast(vmManagerTypeAsString()));
        case "vmPath":
            return Optional.ofNullable(clazz.cast(vmPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VmServer, T> g) {
        return obj -> g.apply((VmServer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VmServer> {
        /**
         * <p>
         * The VM server location.
         * </p>
         * 
         * @param vmServerAddress
         *        The VM server location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmServerAddress(VmServerAddress vmServerAddress);

        /**
         * <p>
         * The VM server location.
         * </p>
         * This is a convenience that creates an instance of the {@link VmServerAddress.Builder} avoiding the need to
         * create one manually via {@link VmServerAddress#builder()}.
         *
         * When the {@link Consumer} completes, {@link VmServerAddress.Builder#build()} is called immediately and its
         * result is passed to {@link #vmServerAddress(VmServerAddress)}.
         * 
         * @param vmServerAddress
         *        a consumer that will call methods on {@link VmServerAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vmServerAddress(VmServerAddress)
         */
        default Builder vmServerAddress(Consumer<VmServerAddress.Builder> vmServerAddress) {
            return vmServerAddress(VmServerAddress.builder().applyMutation(vmServerAddress).build());
        }

        /**
         * <p>
         * The name of the VM.
         * </p>
         * 
         * @param vmName
         *        The name of the VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmName(String vmName);

        /**
         * <p>
         * The name of the VM manager.
         * </p>
         * 
         * @param vmManagerName
         *        The name of the VM manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmManagerName(String vmManagerName);

        /**
         * <p>
         * The type of VM management product.
         * </p>
         * 
         * @param vmManagerType
         *        The type of VM management product.
         * @see VmManagerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VmManagerType
         */
        Builder vmManagerType(String vmManagerType);

        /**
         * <p>
         * The type of VM management product.
         * </p>
         * 
         * @param vmManagerType
         *        The type of VM management product.
         * @see VmManagerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VmManagerType
         */
        Builder vmManagerType(VmManagerType vmManagerType);

        /**
         * <p>
         * The VM folder path in the vCenter Server virtual machine inventory tree.
         * </p>
         * 
         * @param vmPath
         *        The VM folder path in the vCenter Server virtual machine inventory tree.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmPath(String vmPath);
    }

    static final class BuilderImpl implements Builder {
        private VmServerAddress vmServerAddress;

        private String vmName;

        private String vmManagerName;

        private String vmManagerType;

        private String vmPath;

        private BuilderImpl() {
        }

        private BuilderImpl(VmServer model) {
            vmServerAddress(model.vmServerAddress);
            vmName(model.vmName);
            vmManagerName(model.vmManagerName);
            vmManagerType(model.vmManagerType);
            vmPath(model.vmPath);
        }

        public final VmServerAddress.Builder getVmServerAddress() {
            return vmServerAddress != null ? vmServerAddress.toBuilder() : null;
        }

        public final void setVmServerAddress(VmServerAddress.BuilderImpl vmServerAddress) {
            this.vmServerAddress = vmServerAddress != null ? vmServerAddress.build() : null;
        }

        @Override
        @Transient
        public final Builder vmServerAddress(VmServerAddress vmServerAddress) {
            this.vmServerAddress = vmServerAddress;
            return this;
        }

        public final String getVmName() {
            return vmName;
        }

        public final void setVmName(String vmName) {
            this.vmName = vmName;
        }

        @Override
        @Transient
        public final Builder vmName(String vmName) {
            this.vmName = vmName;
            return this;
        }

        public final String getVmManagerName() {
            return vmManagerName;
        }

        public final void setVmManagerName(String vmManagerName) {
            this.vmManagerName = vmManagerName;
        }

        @Override
        @Transient
        public final Builder vmManagerName(String vmManagerName) {
            this.vmManagerName = vmManagerName;
            return this;
        }

        public final String getVmManagerType() {
            return vmManagerType;
        }

        public final void setVmManagerType(String vmManagerType) {
            this.vmManagerType = vmManagerType;
        }

        @Override
        @Transient
        public final Builder vmManagerType(String vmManagerType) {
            this.vmManagerType = vmManagerType;
            return this;
        }

        @Override
        @Transient
        public final Builder vmManagerType(VmManagerType vmManagerType) {
            this.vmManagerType(vmManagerType == null ? null : vmManagerType.toString());
            return this;
        }

        public final String getVmPath() {
            return vmPath;
        }

        public final void setVmPath(String vmPath) {
            this.vmPath = vmPath;
        }

        @Override
        @Transient
        public final Builder vmPath(String vmPath) {
            this.vmPath = vmPath;
            return this;
        }

        @Override
        public VmServer build() {
            return new VmServer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
