/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <important>
 * <p>
 * <b>Product update</b>
 * </p>
 * <p>
 * As of March 31, 2022, Amazon Web Services will discontinue Server Migration Service (Amazon Web Services SMS). Going
 * forward, we recommend <a href="http://aws.amazon.com/application-migration-service">Amazon Web Services Application
 * Migration Service</a> (Amazon Web Services MGN) as the primary migration service for lift-and-shift migrations.
 * </p>
 * <p>
 * You can initiate new migration jobs in Server Migration Service until January 1, 2022. Complete these active
 * migration projects by March 31, 2022. For more information, see <a
 * href="http://aws.amazon.com/application-migration-service/when-to-choose-aws-mgn/">When to Choose AWS Application
 * Migration Service</a>.
 * </p>
 * </important>
 * <p>
 * Server Migration Service (Server Migration Service) makes it easier and faster for you to migrate your on-premises
 * workloads to Amazon Web Services. To learn more about Server Migration Service, see the following resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="http://aws.amazon.com/server-migration-service/">Server Migration Service product page</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/server-migration-service/latest/userguide/">Server Migration Service User
 * Guide</a>
 * </p>
 * </li>
 * </ul>
 */
package software.amazon.awssdk.services.sms;