/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppRequest extends SmsRequest implements ToCopyableBuilder<CreateAppRequest.Builder, CreateAppRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAppRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAppRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleName").getter(getter(CreateAppRequest::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(CreateAppRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<List<ServerGroup>> SERVER_GROUPS_FIELD = SdkField
            .<List<ServerGroup>> builder(MarshallingType.LIST)
            .memberName("serverGroups")
            .getter(getter(CreateAppRequest::serverGroups))
            .setter(setter(Builder::serverGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateAppRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ROLE_NAME_FIELD, CLIENT_TOKEN_FIELD, SERVER_GROUPS_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final String roleName;

    private final String clientToken;

    private final List<ServerGroup> serverGroups;

    private final List<Tag> tags;

    private CreateAppRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.roleName = builder.roleName;
        this.clientToken = builder.clientToken;
        this.serverGroups = builder.serverGroups;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the new application.
     * </p>
     * 
     * @return The name of the new application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the new application
     * </p>
     * 
     * @return The description of the new application
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the service role in the customer's account to be used by Server Migration Service.
     * </p>
     * 
     * @return The name of the service role in the customer's account to be used by Server Migration Service.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of application creation.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of application creation.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServerGroups() {
        return serverGroups != null && !(serverGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The server groups to include in the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerGroups} method.
     * </p>
     * 
     * @return The server groups to include in the application.
     */
    public final List<ServerGroup> serverGroups() {
        return serverGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be associated with the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be associated with the application.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasServerGroups() ? serverGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(roleName(), other.roleName()) && Objects.equals(clientToken(), other.clientToken())
                && hasServerGroups() == other.hasServerGroups() && Objects.equals(serverGroups(), other.serverGroups())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAppRequest").add("Name", name()).add("Description", description())
                .add("RoleName", roleName()).add("ClientToken", clientToken())
                .add("ServerGroups", hasServerGroups() ? serverGroups() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "serverGroups":
            return Optional.ofNullable(clazz.cast(serverGroups()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppRequest, T> g) {
        return obj -> g.apply((CreateAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAppRequest> {
        /**
         * <p>
         * The name of the new application.
         * </p>
         * 
         * @param name
         *        The name of the new application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the new application
         * </p>
         * 
         * @param description
         *        The description of the new application
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the service role in the customer's account to be used by Server Migration Service.
         * </p>
         * 
         * @param roleName
         *        The name of the service role in the customer's account to be used by Server Migration Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of application creation.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of application
         *        creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The server groups to include in the application.
         * </p>
         * 
         * @param serverGroups
         *        The server groups to include in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroups(Collection<ServerGroup> serverGroups);

        /**
         * <p>
         * The server groups to include in the application.
         * </p>
         * 
         * @param serverGroups
         *        The server groups to include in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroups(ServerGroup... serverGroups);

        /**
         * <p>
         * The server groups to include in the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ServerGroup>.Builder} avoiding the
         * need to create one manually via {@link List<ServerGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServerGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #serverGroups(List<ServerGroup>)}.
         * 
         * @param serverGroups
         *        a consumer that will call methods on {@link List<ServerGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverGroups(List<ServerGroup>)
         */
        Builder serverGroups(Consumer<ServerGroup.Builder>... serverGroups);

        /**
         * <p>
         * The tags to be associated with the application.
         * </p>
         * 
         * @param tags
         *        The tags to be associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be associated with the application.
         * </p>
         * 
         * @param tags
         *        The tags to be associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be associated with the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SmsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String roleName;

        private String clientToken;

        private List<ServerGroup> serverGroups = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            roleName(model.roleName);
            clientToken(model.clientToken);
            serverGroups(model.serverGroups);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<ServerGroup.Builder> getServerGroups() {
            List<ServerGroup.Builder> result = ServerGroupsCopier.copyToBuilder(this.serverGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerGroups(Collection<ServerGroup.BuilderImpl> serverGroups) {
            this.serverGroups = ServerGroupsCopier.copyFromBuilder(serverGroups);
        }

        @Override
        public final Builder serverGroups(Collection<ServerGroup> serverGroups) {
            this.serverGroups = ServerGroupsCopier.copy(serverGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroups(ServerGroup... serverGroups) {
            serverGroups(Arrays.asList(serverGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroups(Consumer<ServerGroup.Builder>... serverGroups) {
            serverGroups(Stream.of(serverGroups).map(c -> ServerGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
