/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAppReplicationConfigurationResponse extends SmsResponse implements
        ToCopyableBuilder<GetAppReplicationConfigurationResponse.Builder, GetAppReplicationConfigurationResponse> {
    private static final SdkField<List<ServerGroupReplicationConfiguration>> SERVER_GROUP_REPLICATION_CONFIGURATIONS_FIELD = SdkField
            .<List<ServerGroupReplicationConfiguration>> builder(MarshallingType.LIST)
            .memberName("serverGroupReplicationConfigurations")
            .getter(getter(GetAppReplicationConfigurationResponse::serverGroupReplicationConfigurations))
            .setter(setter(Builder::serverGroupReplicationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("serverGroupReplicationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerGroupReplicationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerGroupReplicationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVER_GROUP_REPLICATION_CONFIGURATIONS_FIELD));

    private final List<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations;

    private GetAppReplicationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.serverGroupReplicationConfigurations = builder.serverGroupReplicationConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerGroupReplicationConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasServerGroupReplicationConfigurations() {
        return serverGroupReplicationConfigurations != null
                && !(serverGroupReplicationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replication configurations associated with server groups in this application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerGroupReplicationConfigurations}
     * method.
     * </p>
     * 
     * @return The replication configurations associated with server groups in this application.
     */
    public final List<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations() {
        return serverGroupReplicationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasServerGroupReplicationConfigurations() ? serverGroupReplicationConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppReplicationConfigurationResponse)) {
            return false;
        }
        GetAppReplicationConfigurationResponse other = (GetAppReplicationConfigurationResponse) obj;
        return hasServerGroupReplicationConfigurations() == other.hasServerGroupReplicationConfigurations()
                && Objects.equals(serverGroupReplicationConfigurations(), other.serverGroupReplicationConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetAppReplicationConfigurationResponse")
                .add("ServerGroupReplicationConfigurations",
                        hasServerGroupReplicationConfigurations() ? serverGroupReplicationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverGroupReplicationConfigurations":
            return Optional.ofNullable(clazz.cast(serverGroupReplicationConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAppReplicationConfigurationResponse, T> g) {
        return obj -> g.apply((GetAppReplicationConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAppReplicationConfigurationResponse> {
        /**
         * <p>
         * The replication configurations associated with server groups in this application.
         * </p>
         * 
         * @param serverGroupReplicationConfigurations
         *        The replication configurations associated with server groups in this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupReplicationConfigurations(
                Collection<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations);

        /**
         * <p>
         * The replication configurations associated with server groups in this application.
         * </p>
         * 
         * @param serverGroupReplicationConfigurations
         *        The replication configurations associated with server groups in this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupReplicationConfigurations(ServerGroupReplicationConfiguration... serverGroupReplicationConfigurations);

        /**
         * <p>
         * The replication configurations associated with server groups in this application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ServerGroupReplicationConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <ServerGroupReplicationConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServerGroupReplicationConfiguration>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #serverGroupReplicationConfigurations(List<ServerGroupReplicationConfiguration>)}.
         * 
         * @param serverGroupReplicationConfigurations
         *        a consumer that will call methods on {@link List<ServerGroupReplicationConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverGroupReplicationConfigurations(List<ServerGroupReplicationConfiguration>)
         */
        Builder serverGroupReplicationConfigurations(
                Consumer<ServerGroupReplicationConfiguration.Builder>... serverGroupReplicationConfigurations);
    }

    static final class BuilderImpl extends SmsResponse.BuilderImpl implements Builder {
        private List<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppReplicationConfigurationResponse model) {
            super(model);
            serverGroupReplicationConfigurations(model.serverGroupReplicationConfigurations);
        }

        public final List<ServerGroupReplicationConfiguration.Builder> getServerGroupReplicationConfigurations() {
            List<ServerGroupReplicationConfiguration.Builder> result = ServerGroupReplicationConfigurationsCopier
                    .copyToBuilder(this.serverGroupReplicationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerGroupReplicationConfigurations(
                Collection<ServerGroupReplicationConfiguration.BuilderImpl> serverGroupReplicationConfigurations) {
            this.serverGroupReplicationConfigurations = ServerGroupReplicationConfigurationsCopier
                    .copyFromBuilder(serverGroupReplicationConfigurations);
        }

        @Override
        public final Builder serverGroupReplicationConfigurations(
                Collection<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations) {
            this.serverGroupReplicationConfigurations = ServerGroupReplicationConfigurationsCopier
                    .copy(serverGroupReplicationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupReplicationConfigurations(
                ServerGroupReplicationConfiguration... serverGroupReplicationConfigurations) {
            serverGroupReplicationConfigurations(Arrays.asList(serverGroupReplicationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupReplicationConfigurations(
                Consumer<ServerGroupReplicationConfiguration.Builder>... serverGroupReplicationConfigurations) {
            serverGroupReplicationConfigurations(Stream.of(serverGroupReplicationConfigurations)
                    .map(c -> ServerGroupReplicationConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetAppReplicationConfigurationResponse build() {
            return new GetAppReplicationConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
