/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAppLaunchConfigurationRequest extends SmsRequest implements
        ToCopyableBuilder<PutAppLaunchConfigurationRequest.Builder, PutAppLaunchConfigurationRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(PutAppLaunchConfigurationRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleName").getter(getter(PutAppLaunchConfigurationRequest::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()).build();

    private static final SdkField<Boolean> AUTO_LAUNCH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoLaunch").getter(getter(PutAppLaunchConfigurationRequest::autoLaunch))
            .setter(setter(Builder::autoLaunch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoLaunch").build()).build();

    private static final SdkField<List<ServerGroupLaunchConfiguration>> SERVER_GROUP_LAUNCH_CONFIGURATIONS_FIELD = SdkField
            .<List<ServerGroupLaunchConfiguration>> builder(MarshallingType.LIST)
            .memberName("serverGroupLaunchConfigurations")
            .getter(getter(PutAppLaunchConfigurationRequest::serverGroupLaunchConfigurations))
            .setter(setter(Builder::serverGroupLaunchConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupLaunchConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerGroupLaunchConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerGroupLaunchConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, ROLE_NAME_FIELD,
            AUTO_LAUNCH_FIELD, SERVER_GROUP_LAUNCH_CONFIGURATIONS_FIELD));

    private final String appId;

    private final String roleName;

    private final Boolean autoLaunch;

    private final List<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations;

    private PutAppLaunchConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.roleName = builder.roleName;
        this.autoLaunch = builder.autoLaunch;
        this.serverGroupLaunchConfigurations = builder.serverGroupLaunchConfigurations;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of service role in the customer's account that CloudFormation uses to launch the application.
     * </p>
     * 
     * @return The name of service role in the customer's account that CloudFormation uses to launch the application.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * Indicates whether the application is configured to launch automatically after replication is complete.
     * </p>
     * 
     * @return Indicates whether the application is configured to launch automatically after replication is complete.
     */
    public final Boolean autoLaunch() {
        return autoLaunch;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerGroupLaunchConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasServerGroupLaunchConfigurations() {
        return serverGroupLaunchConfigurations != null && !(serverGroupLaunchConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the launch configurations for server groups in the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerGroupLaunchConfigurations}
     * method.
     * </p>
     * 
     * @return Information about the launch configurations for server groups in the application.
     */
    public final List<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations() {
        return serverGroupLaunchConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(autoLaunch());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasServerGroupLaunchConfigurations() ? serverGroupLaunchConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAppLaunchConfigurationRequest)) {
            return false;
        }
        PutAppLaunchConfigurationRequest other = (PutAppLaunchConfigurationRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(roleName(), other.roleName())
                && Objects.equals(autoLaunch(), other.autoLaunch())
                && hasServerGroupLaunchConfigurations() == other.hasServerGroupLaunchConfigurations()
                && Objects.equals(serverGroupLaunchConfigurations(), other.serverGroupLaunchConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PutAppLaunchConfigurationRequest")
                .add("AppId", appId())
                .add("RoleName", roleName())
                .add("AutoLaunch", autoLaunch())
                .add("ServerGroupLaunchConfigurations",
                        hasServerGroupLaunchConfigurations() ? serverGroupLaunchConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "roleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "autoLaunch":
            return Optional.ofNullable(clazz.cast(autoLaunch()));
        case "serverGroupLaunchConfigurations":
            return Optional.ofNullable(clazz.cast(serverGroupLaunchConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAppLaunchConfigurationRequest, T> g) {
        return obj -> g.apply((PutAppLaunchConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAppLaunchConfigurationRequest> {
        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param appId
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of service role in the customer's account that CloudFormation uses to launch the application.
         * </p>
         * 
         * @param roleName
         *        The name of service role in the customer's account that CloudFormation uses to launch the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * Indicates whether the application is configured to launch automatically after replication is complete.
         * </p>
         * 
         * @param autoLaunch
         *        Indicates whether the application is configured to launch automatically after replication is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoLaunch(Boolean autoLaunch);

        /**
         * <p>
         * Information about the launch configurations for server groups in the application.
         * </p>
         * 
         * @param serverGroupLaunchConfigurations
         *        Information about the launch configurations for server groups in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupLaunchConfigurations(Collection<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations);

        /**
         * <p>
         * Information about the launch configurations for server groups in the application.
         * </p>
         * 
         * @param serverGroupLaunchConfigurations
         *        Information about the launch configurations for server groups in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupLaunchConfigurations(ServerGroupLaunchConfiguration... serverGroupLaunchConfigurations);

        /**
         * <p>
         * Information about the launch configurations for server groups in the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ServerGroupLaunchConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <ServerGroupLaunchConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServerGroupLaunchConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #serverGroupLaunchConfigurations(List<ServerGroupLaunchConfiguration>)}.
         * 
         * @param serverGroupLaunchConfigurations
         *        a consumer that will call methods on {@link List<ServerGroupLaunchConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverGroupLaunchConfigurations(List<ServerGroupLaunchConfiguration>)
         */
        Builder serverGroupLaunchConfigurations(
                Consumer<ServerGroupLaunchConfiguration.Builder>... serverGroupLaunchConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SmsRequest.BuilderImpl implements Builder {
        private String appId;

        private String roleName;

        private Boolean autoLaunch;

        private List<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAppLaunchConfigurationRequest model) {
            super(model);
            appId(model.appId);
            roleName(model.roleName);
            autoLaunch(model.autoLaunch);
            serverGroupLaunchConfigurations(model.serverGroupLaunchConfigurations);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final Boolean getAutoLaunch() {
            return autoLaunch;
        }

        public final void setAutoLaunch(Boolean autoLaunch) {
            this.autoLaunch = autoLaunch;
        }

        @Override
        public final Builder autoLaunch(Boolean autoLaunch) {
            this.autoLaunch = autoLaunch;
            return this;
        }

        public final List<ServerGroupLaunchConfiguration.Builder> getServerGroupLaunchConfigurations() {
            List<ServerGroupLaunchConfiguration.Builder> result = ServerGroupLaunchConfigurationsCopier
                    .copyToBuilder(this.serverGroupLaunchConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerGroupLaunchConfigurations(
                Collection<ServerGroupLaunchConfiguration.BuilderImpl> serverGroupLaunchConfigurations) {
            this.serverGroupLaunchConfigurations = ServerGroupLaunchConfigurationsCopier
                    .copyFromBuilder(serverGroupLaunchConfigurations);
        }

        @Override
        public final Builder serverGroupLaunchConfigurations(
                Collection<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations) {
            this.serverGroupLaunchConfigurations = ServerGroupLaunchConfigurationsCopier.copy(serverGroupLaunchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupLaunchConfigurations(ServerGroupLaunchConfiguration... serverGroupLaunchConfigurations) {
            serverGroupLaunchConfigurations(Arrays.asList(serverGroupLaunchConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupLaunchConfigurations(
                Consumer<ServerGroupLaunchConfiguration.Builder>... serverGroupLaunchConfigurations) {
            serverGroupLaunchConfigurations(Stream.of(serverGroupLaunchConfigurations)
                    .map(c -> ServerGroupLaunchConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAppLaunchConfigurationRequest build() {
            return new PutAppLaunchConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
