/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a replication job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationJob implements SdkPojo, Serializable, ToCopyableBuilder<ReplicationJob.Builder, ReplicationJob> {
    private static final SdkField<String> REPLICATION_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationJobId").getter(getter(ReplicationJob::replicationJobId))
            .setter(setter(Builder::replicationJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJobId").build()).build();

    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverId").getter(getter(ReplicationJob::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverId").build()).build();

    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverType").getter(getter(ReplicationJob::serverTypeAsString)).setter(setter(Builder::serverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverType").build()).build();

    private static final SdkField<VmServer> VM_SERVER_FIELD = SdkField.<VmServer> builder(MarshallingType.SDK_POJO)
            .memberName("vmServer").getter(getter(ReplicationJob::vmServer)).setter(setter(Builder::vmServer))
            .constructor(VmServer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmServer").build()).build();

    private static final SdkField<Instant> SEED_REPLICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("seedReplicationTime").getter(getter(ReplicationJob::seedReplicationTime))
            .setter(setter(Builder::seedReplicationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seedReplicationTime").build())
            .build();

    private static final SdkField<Integer> FREQUENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("frequency").getter(getter(ReplicationJob::frequency)).setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()).build();

    private static final SdkField<Boolean> RUN_ONCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("runOnce").getter(getter(ReplicationJob::runOnce)).setter(setter(Builder::runOnce))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runOnce").build()).build();

    private static final SdkField<Instant> NEXT_REPLICATION_RUN_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("nextReplicationRunStartTime")
            .getter(getter(ReplicationJob::nextReplicationRunStartTime))
            .setter(setter(Builder::nextReplicationRunStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextReplicationRunStartTime")
                    .build()).build();

    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseType").getter(getter(ReplicationJob::licenseTypeAsString)).setter(setter(Builder::licenseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseType").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleName").getter(getter(ReplicationJob::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()).build();

    private static final SdkField<String> LATEST_AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestAmiId").getter(getter(ReplicationJob::latestAmiId)).setter(setter(Builder::latestAmiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAmiId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ReplicationJob::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ReplicationJob::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ReplicationJob::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Integer> NUMBER_OF_RECENT_AMIS_TO_KEEP_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("numberOfRecentAmisToKeep")
            .getter(getter(ReplicationJob::numberOfRecentAmisToKeep)).setter(setter(Builder::numberOfRecentAmisToKeep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecentAmisToKeep").build())
            .build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("encrypted").getter(getter(ReplicationJob::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(ReplicationJob::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<List<ReplicationRun>> REPLICATION_RUN_LIST_FIELD = SdkField
            .<List<ReplicationRun>> builder(MarshallingType.LIST)
            .memberName("replicationRunList")
            .getter(getter(ReplicationJob::replicationRunList))
            .setter(setter(Builder::replicationRunList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationRunList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_JOB_ID_FIELD,
            SERVER_ID_FIELD, SERVER_TYPE_FIELD, VM_SERVER_FIELD, SEED_REPLICATION_TIME_FIELD, FREQUENCY_FIELD, RUN_ONCE_FIELD,
            NEXT_REPLICATION_RUN_START_TIME_FIELD, LICENSE_TYPE_FIELD, ROLE_NAME_FIELD, LATEST_AMI_ID_FIELD, STATE_FIELD,
            STATUS_MESSAGE_FIELD, DESCRIPTION_FIELD, NUMBER_OF_RECENT_AMIS_TO_KEEP_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD,
            REPLICATION_RUN_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationJobId;

    private final String serverId;

    private final String serverType;

    private final VmServer vmServer;

    private final Instant seedReplicationTime;

    private final Integer frequency;

    private final Boolean runOnce;

    private final Instant nextReplicationRunStartTime;

    private final String licenseType;

    private final String roleName;

    private final String latestAmiId;

    private final String state;

    private final String statusMessage;

    private final String description;

    private final Integer numberOfRecentAmisToKeep;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final List<ReplicationRun> replicationRunList;

    private ReplicationJob(BuilderImpl builder) {
        this.replicationJobId = builder.replicationJobId;
        this.serverId = builder.serverId;
        this.serverType = builder.serverType;
        this.vmServer = builder.vmServer;
        this.seedReplicationTime = builder.seedReplicationTime;
        this.frequency = builder.frequency;
        this.runOnce = builder.runOnce;
        this.nextReplicationRunStartTime = builder.nextReplicationRunStartTime;
        this.licenseType = builder.licenseType;
        this.roleName = builder.roleName;
        this.latestAmiId = builder.latestAmiId;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.description = builder.description;
        this.numberOfRecentAmisToKeep = builder.numberOfRecentAmisToKeep;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.replicationRunList = builder.replicationRunList;
    }

    /**
     * <p>
     * The ID of the replication job.
     * </p>
     * 
     * @return The ID of the replication job.
     */
    public final String replicationJobId() {
        return replicationJobId;
    }

    /**
     * <p>
     * The ID of the server.
     * </p>
     * 
     * @return The ID of the server.
     */
    public final String serverId() {
        return serverId;
    }

    /**
     * <p>
     * The type of server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The type of server.
     * @see ServerType
     */
    public final ServerType serverType() {
        return ServerType.fromValue(serverType);
    }

    /**
     * <p>
     * The type of server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The type of server.
     * @see ServerType
     */
    public final String serverTypeAsString() {
        return serverType;
    }

    /**
     * <p>
     * Information about the VM server.
     * </p>
     * 
     * @return Information about the VM server.
     */
    public final VmServer vmServer() {
        return vmServer;
    }

    /**
     * <p>
     * The seed replication time.
     * </p>
     * 
     * @return The seed replication time.
     */
    public final Instant seedReplicationTime() {
        return seedReplicationTime;
    }

    /**
     * <p>
     * The time between consecutive replication runs, in hours.
     * </p>
     * 
     * @return The time between consecutive replication runs, in hours.
     */
    public final Integer frequency() {
        return frequency;
    }

    /**
     * <p>
     * Indicates whether to run the replication job one time.
     * </p>
     * 
     * @return Indicates whether to run the replication job one time.
     */
    public final Boolean runOnce() {
        return runOnce;
    }

    /**
     * <p>
     * The start time of the next replication run.
     * </p>
     * 
     * @return The start time of the next replication run.
     */
    public final Instant nextReplicationRunStartTime() {
        return nextReplicationRunStartTime;
    }

    /**
     * <p>
     * The license type to be used for the AMI created by a successful replication run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link LicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The license type to be used for the AMI created by a successful replication run.
     * @see LicenseType
     */
    public final LicenseType licenseType() {
        return LicenseType.fromValue(licenseType);
    }

    /**
     * <p>
     * The license type to be used for the AMI created by a successful replication run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link LicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The license type to be used for the AMI created by a successful replication run.
     * @see LicenseType
     */
    public final String licenseTypeAsString() {
        return licenseType;
    }

    /**
     * <p>
     * The name of the IAM role to be used by Server Migration Service.
     * </p>
     * 
     * @return The name of the IAM role to be used by Server Migration Service.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The ID of the latest Amazon Machine Image (AMI).
     * </p>
     * 
     * @return The ID of the latest Amazon Machine Image (AMI).
     */
    public final String latestAmiId() {
        return latestAmiId;
    }

    /**
     * <p>
     * The state of the replication job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReplicationJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the replication job.
     * @see ReplicationJobState
     */
    public final ReplicationJobState state() {
        return ReplicationJobState.fromValue(state);
    }

    /**
     * <p>
     * The state of the replication job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReplicationJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the replication job.
     * @see ReplicationJobState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The description of the current status of the replication job.
     * </p>
     * 
     * @return The description of the current status of the replication job.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The description of the replication job.
     * </p>
     * 
     * @return The description of the replication job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The number of recent AMIs to keep in the customer's account for a replication job. By default, the value is set
     * to zero, meaning that all AMIs are kept.
     * </p>
     * 
     * @return The number of recent AMIs to keep in the customer's account for a replication job. By default, the value
     *         is set to zero, meaning that all AMIs are kept.
     */
    public final Integer numberOfRecentAmisToKeep() {
        return numberOfRecentAmisToKeep;
    }

    /**
     * <p>
     * Indicates whether the replication job should produce encrypted AMIs.
     * </p>
     * 
     * @return Indicates whether the replication job should produce encrypted AMIs.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KMS key ID
     * </p>
     * </li>
     * <li>
     * <p>
     * KMS key alias
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN referring to the KMS key ID
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN referring to the KMS key alias
     * </p>
     * </li>
     * </ul>
     * <p>
     * If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.
     * </p>
     * 
     * @return The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the
     *         following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         KMS key ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         KMS key alias
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN referring to the KMS key ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN referring to the KMS key alias
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS
     *         is used.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationRunList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationRunList() {
        return replicationRunList != null && !(replicationRunList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the replication runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationRunList} method.
     * </p>
     * 
     * @return Information about the replication runs.
     */
    public final List<ReplicationRun> replicationRunList() {
        return replicationRunList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationJobId());
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vmServer());
        hashCode = 31 * hashCode + Objects.hashCode(seedReplicationTime());
        hashCode = 31 * hashCode + Objects.hashCode(frequency());
        hashCode = 31 * hashCode + Objects.hashCode(runOnce());
        hashCode = 31 * hashCode + Objects.hashCode(nextReplicationRunStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(latestAmiId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRecentAmisToKeep());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationRunList() ? replicationRunList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationJob)) {
            return false;
        }
        ReplicationJob other = (ReplicationJob) obj;
        return Objects.equals(replicationJobId(), other.replicationJobId()) && Objects.equals(serverId(), other.serverId())
                && Objects.equals(serverTypeAsString(), other.serverTypeAsString())
                && Objects.equals(vmServer(), other.vmServer())
                && Objects.equals(seedReplicationTime(), other.seedReplicationTime())
                && Objects.equals(frequency(), other.frequency()) && Objects.equals(runOnce(), other.runOnce())
                && Objects.equals(nextReplicationRunStartTime(), other.nextReplicationRunStartTime())
                && Objects.equals(licenseTypeAsString(), other.licenseTypeAsString())
                && Objects.equals(roleName(), other.roleName()) && Objects.equals(latestAmiId(), other.latestAmiId())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(description(), other.description())
                && Objects.equals(numberOfRecentAmisToKeep(), other.numberOfRecentAmisToKeep())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && hasReplicationRunList() == other.hasReplicationRunList()
                && Objects.equals(replicationRunList(), other.replicationRunList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationJob").add("ReplicationJobId", replicationJobId()).add("ServerId", serverId())
                .add("ServerType", serverTypeAsString()).add("VmServer", vmServer())
                .add("SeedReplicationTime", seedReplicationTime()).add("Frequency", frequency()).add("RunOnce", runOnce())
                .add("NextReplicationRunStartTime", nextReplicationRunStartTime()).add("LicenseType", licenseTypeAsString())
                .add("RoleName", roleName()).add("LatestAmiId", latestAmiId()).add("State", stateAsString())
                .add("StatusMessage", statusMessage()).add("Description", description())
                .add("NumberOfRecentAmisToKeep", numberOfRecentAmisToKeep()).add("Encrypted", encrypted())
                .add("KmsKeyId", kmsKeyId()).add("ReplicationRunList", hasReplicationRunList() ? replicationRunList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replicationJobId":
            return Optional.ofNullable(clazz.cast(replicationJobId()));
        case "serverId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "serverType":
            return Optional.ofNullable(clazz.cast(serverTypeAsString()));
        case "vmServer":
            return Optional.ofNullable(clazz.cast(vmServer()));
        case "seedReplicationTime":
            return Optional.ofNullable(clazz.cast(seedReplicationTime()));
        case "frequency":
            return Optional.ofNullable(clazz.cast(frequency()));
        case "runOnce":
            return Optional.ofNullable(clazz.cast(runOnce()));
        case "nextReplicationRunStartTime":
            return Optional.ofNullable(clazz.cast(nextReplicationRunStartTime()));
        case "licenseType":
            return Optional.ofNullable(clazz.cast(licenseTypeAsString()));
        case "roleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "latestAmiId":
            return Optional.ofNullable(clazz.cast(latestAmiId()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "numberOfRecentAmisToKeep":
            return Optional.ofNullable(clazz.cast(numberOfRecentAmisToKeep()));
        case "encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "replicationRunList":
            return Optional.ofNullable(clazz.cast(replicationRunList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationJob, T> g) {
        return obj -> g.apply((ReplicationJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationJob> {
        /**
         * <p>
         * The ID of the replication job.
         * </p>
         * 
         * @param replicationJobId
         *        The ID of the replication job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationJobId(String replicationJobId);

        /**
         * <p>
         * The ID of the server.
         * </p>
         * 
         * @param serverId
         *        The ID of the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * The type of server.
         * </p>
         * 
         * @param serverType
         *        The type of server.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(String serverType);

        /**
         * <p>
         * The type of server.
         * </p>
         * 
         * @param serverType
         *        The type of server.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(ServerType serverType);

        /**
         * <p>
         * Information about the VM server.
         * </p>
         * 
         * @param vmServer
         *        Information about the VM server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmServer(VmServer vmServer);

        /**
         * <p>
         * Information about the VM server.
         * </p>
         * This is a convenience method that creates an instance of the {@link VmServer.Builder} avoiding the need to
         * create one manually via {@link VmServer#builder()}.
         *
         * When the {@link Consumer} completes, {@link VmServer.Builder#build()} is called immediately and its result is
         * passed to {@link #vmServer(VmServer)}.
         * 
         * @param vmServer
         *        a consumer that will call methods on {@link VmServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vmServer(VmServer)
         */
        default Builder vmServer(Consumer<VmServer.Builder> vmServer) {
            return vmServer(VmServer.builder().applyMutation(vmServer).build());
        }

        /**
         * <p>
         * The seed replication time.
         * </p>
         * 
         * @param seedReplicationTime
         *        The seed replication time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seedReplicationTime(Instant seedReplicationTime);

        /**
         * <p>
         * The time between consecutive replication runs, in hours.
         * </p>
         * 
         * @param frequency
         *        The time between consecutive replication runs, in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequency(Integer frequency);

        /**
         * <p>
         * Indicates whether to run the replication job one time.
         * </p>
         * 
         * @param runOnce
         *        Indicates whether to run the replication job one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runOnce(Boolean runOnce);

        /**
         * <p>
         * The start time of the next replication run.
         * </p>
         * 
         * @param nextReplicationRunStartTime
         *        The start time of the next replication run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextReplicationRunStartTime(Instant nextReplicationRunStartTime);

        /**
         * <p>
         * The license type to be used for the AMI created by a successful replication run.
         * </p>
         * 
         * @param licenseType
         *        The license type to be used for the AMI created by a successful replication run.
         * @see LicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseType
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The license type to be used for the AMI created by a successful replication run.
         * </p>
         * 
         * @param licenseType
         *        The license type to be used for the AMI created by a successful replication run.
         * @see LicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseType
         */
        Builder licenseType(LicenseType licenseType);

        /**
         * <p>
         * The name of the IAM role to be used by Server Migration Service.
         * </p>
         * 
         * @param roleName
         *        The name of the IAM role to be used by Server Migration Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The ID of the latest Amazon Machine Image (AMI).
         * </p>
         * 
         * @param latestAmiId
         *        The ID of the latest Amazon Machine Image (AMI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestAmiId(String latestAmiId);

        /**
         * <p>
         * The state of the replication job.
         * </p>
         * 
         * @param state
         *        The state of the replication job.
         * @see ReplicationJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationJobState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the replication job.
         * </p>
         * 
         * @param state
         *        The state of the replication job.
         * @see ReplicationJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationJobState
         */
        Builder state(ReplicationJobState state);

        /**
         * <p>
         * The description of the current status of the replication job.
         * </p>
         * 
         * @param statusMessage
         *        The description of the current status of the replication job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The description of the replication job.
         * </p>
         * 
         * @param description
         *        The description of the replication job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The number of recent AMIs to keep in the customer's account for a replication job. By default, the value is
         * set to zero, meaning that all AMIs are kept.
         * </p>
         * 
         * @param numberOfRecentAmisToKeep
         *        The number of recent AMIs to keep in the customer's account for a replication job. By default, the
         *        value is set to zero, meaning that all AMIs are kept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep);

        /**
         * <p>
         * Indicates whether the replication job should produce encrypted AMIs.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the replication job should produce encrypted AMIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KMS key ID
         * </p>
         * </li>
         * <li>
         * <p>
         * KMS key alias
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN referring to the KMS key ID
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN referring to the KMS key alias
         * </p>
         * </li>
         * </ul>
         * <p>
         * If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is
         * used.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the
         *        following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        KMS key ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KMS key alias
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN referring to the KMS key ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN referring to the KMS key alias
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon
         *        EBS is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Information about the replication runs.
         * </p>
         * 
         * @param replicationRunList
         *        Information about the replication runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRunList(Collection<ReplicationRun> replicationRunList);

        /**
         * <p>
         * Information about the replication runs.
         * </p>
         * 
         * @param replicationRunList
         *        Information about the replication runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRunList(ReplicationRun... replicationRunList);

        /**
         * <p>
         * Information about the replication runs.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ReplicationRun>.Builder} avoiding
         * the need to create one manually via {@link List<ReplicationRun>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationRun>.Builder#build()} is called immediately and
         * its result is passed to {@link #replicationRunList(List<ReplicationRun>)}.
         * 
         * @param replicationRunList
         *        a consumer that will call methods on {@link List<ReplicationRun>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationRunList(List<ReplicationRun>)
         */
        Builder replicationRunList(Consumer<ReplicationRun.Builder>... replicationRunList);
    }

    static final class BuilderImpl implements Builder {
        private String replicationJobId;

        private String serverId;

        private String serverType;

        private VmServer vmServer;

        private Instant seedReplicationTime;

        private Integer frequency;

        private Boolean runOnce;

        private Instant nextReplicationRunStartTime;

        private String licenseType;

        private String roleName;

        private String latestAmiId;

        private String state;

        private String statusMessage;

        private String description;

        private Integer numberOfRecentAmisToKeep;

        private Boolean encrypted;

        private String kmsKeyId;

        private List<ReplicationRun> replicationRunList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationJob model) {
            replicationJobId(model.replicationJobId);
            serverId(model.serverId);
            serverType(model.serverType);
            vmServer(model.vmServer);
            seedReplicationTime(model.seedReplicationTime);
            frequency(model.frequency);
            runOnce(model.runOnce);
            nextReplicationRunStartTime(model.nextReplicationRunStartTime);
            licenseType(model.licenseType);
            roleName(model.roleName);
            latestAmiId(model.latestAmiId);
            state(model.state);
            statusMessage(model.statusMessage);
            description(model.description);
            numberOfRecentAmisToKeep(model.numberOfRecentAmisToKeep);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            replicationRunList(model.replicationRunList);
        }

        public final String getReplicationJobId() {
            return replicationJobId;
        }

        public final void setReplicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
        }

        @Override
        public final Builder replicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
            return this;
        }

        public final String getServerId() {
            return serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getServerType() {
            return serverType;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType == null ? null : serverType.toString());
            return this;
        }

        public final VmServer.Builder getVmServer() {
            return vmServer != null ? vmServer.toBuilder() : null;
        }

        public final void setVmServer(VmServer.BuilderImpl vmServer) {
            this.vmServer = vmServer != null ? vmServer.build() : null;
        }

        @Override
        public final Builder vmServer(VmServer vmServer) {
            this.vmServer = vmServer;
            return this;
        }

        public final Instant getSeedReplicationTime() {
            return seedReplicationTime;
        }

        public final void setSeedReplicationTime(Instant seedReplicationTime) {
            this.seedReplicationTime = seedReplicationTime;
        }

        @Override
        public final Builder seedReplicationTime(Instant seedReplicationTime) {
            this.seedReplicationTime = seedReplicationTime;
            return this;
        }

        public final Integer getFrequency() {
            return frequency;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final Boolean getRunOnce() {
            return runOnce;
        }

        public final void setRunOnce(Boolean runOnce) {
            this.runOnce = runOnce;
        }

        @Override
        public final Builder runOnce(Boolean runOnce) {
            this.runOnce = runOnce;
            return this;
        }

        public final Instant getNextReplicationRunStartTime() {
            return nextReplicationRunStartTime;
        }

        public final void setNextReplicationRunStartTime(Instant nextReplicationRunStartTime) {
            this.nextReplicationRunStartTime = nextReplicationRunStartTime;
        }

        @Override
        public final Builder nextReplicationRunStartTime(Instant nextReplicationRunStartTime) {
            this.nextReplicationRunStartTime = nextReplicationRunStartTime;
            return this;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(LicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getLatestAmiId() {
            return latestAmiId;
        }

        public final void setLatestAmiId(String latestAmiId) {
            this.latestAmiId = latestAmiId;
        }

        @Override
        public final Builder latestAmiId(String latestAmiId) {
            this.latestAmiId = latestAmiId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReplicationJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getNumberOfRecentAmisToKeep() {
            return numberOfRecentAmisToKeep;
        }

        public final void setNumberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep) {
            this.numberOfRecentAmisToKeep = numberOfRecentAmisToKeep;
        }

        @Override
        public final Builder numberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep) {
            this.numberOfRecentAmisToKeep = numberOfRecentAmisToKeep;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<ReplicationRun.Builder> getReplicationRunList() {
            List<ReplicationRun.Builder> result = ReplicationRunListCopier.copyToBuilder(this.replicationRunList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationRunList(Collection<ReplicationRun.BuilderImpl> replicationRunList) {
            this.replicationRunList = ReplicationRunListCopier.copyFromBuilder(replicationRunList);
        }

        @Override
        public final Builder replicationRunList(Collection<ReplicationRun> replicationRunList) {
            this.replicationRunList = ReplicationRunListCopier.copy(replicationRunList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRunList(ReplicationRun... replicationRunList) {
            replicationRunList(Arrays.asList(replicationRunList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRunList(Consumer<ReplicationRun.Builder>... replicationRunList) {
            replicationRunList(Stream.of(replicationRunList).map(c -> ReplicationRun.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReplicationJob build() {
            return new ReplicationJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
