/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Logical grouping of servers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerGroup implements SdkPojo, Serializable, ToCopyableBuilder<ServerGroup.Builder, ServerGroup> {
    private static final SdkField<String> SERVER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverGroupId").getter(getter(ServerGroup::serverGroupId)).setter(setter(Builder::serverGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ServerGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<Server>> SERVER_LIST_FIELD = SdkField
            .<List<Server>> builder(MarshallingType.LIST)
            .memberName("serverList")
            .getter(getter(ServerGroup::serverList))
            .setter(setter(Builder::serverList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Server> builder(MarshallingType.SDK_POJO)
                                            .constructor(Server::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_GROUP_ID_FIELD,
            NAME_FIELD, SERVER_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverGroupId;

    private final String name;

    private final List<Server> serverList;

    private ServerGroup(BuilderImpl builder) {
        this.serverGroupId = builder.serverGroupId;
        this.name = builder.name;
        this.serverList = builder.serverList;
    }

    /**
     * <p>
     * The ID of a server group.
     * </p>
     * 
     * @return The ID of a server group.
     */
    public final String serverGroupId() {
        return serverGroupId;
    }

    /**
     * <p>
     * The name of a server group.
     * </p>
     * 
     * @return The name of a server group.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServerList() {
        return serverList != null && !(serverList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The servers that belong to a server group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerList} method.
     * </p>
     * 
     * @return The servers that belong to a server group.
     */
    public final List<Server> serverList() {
        return serverList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasServerList() ? serverList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerGroup)) {
            return false;
        }
        ServerGroup other = (ServerGroup) obj;
        return Objects.equals(serverGroupId(), other.serverGroupId()) && Objects.equals(name(), other.name())
                && hasServerList() == other.hasServerList() && Objects.equals(serverList(), other.serverList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerGroup").add("ServerGroupId", serverGroupId()).add("Name", name())
                .add("ServerList", hasServerList() ? serverList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverGroupId":
            return Optional.ofNullable(clazz.cast(serverGroupId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "serverList":
            return Optional.ofNullable(clazz.cast(serverList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerGroup, T> g) {
        return obj -> g.apply((ServerGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerGroup> {
        /**
         * <p>
         * The ID of a server group.
         * </p>
         * 
         * @param serverGroupId
         *        The ID of a server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupId(String serverGroupId);

        /**
         * <p>
         * The name of a server group.
         * </p>
         * 
         * @param name
         *        The name of a server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The servers that belong to a server group.
         * </p>
         * 
         * @param serverList
         *        The servers that belong to a server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverList(Collection<Server> serverList);

        /**
         * <p>
         * The servers that belong to a server group.
         * </p>
         * 
         * @param serverList
         *        The servers that belong to a server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverList(Server... serverList);

        /**
         * <p>
         * The servers that belong to a server group.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Server>.Builder} avoiding the need
         * to create one manually via {@link List<Server>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Server>.Builder#build()} is called immediately and its
         * result is passed to {@link #serverList(List<Server>)}.
         * 
         * @param serverList
         *        a consumer that will call methods on {@link List<Server>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverList(List<Server>)
         */
        Builder serverList(Consumer<Server.Builder>... serverList);
    }

    static final class BuilderImpl implements Builder {
        private String serverGroupId;

        private String name;

        private List<Server> serverList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerGroup model) {
            serverGroupId(model.serverGroupId);
            name(model.name);
            serverList(model.serverList);
        }

        public final String getServerGroupId() {
            return serverGroupId;
        }

        public final void setServerGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
        }

        @Override
        public final Builder serverGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Server.Builder> getServerList() {
            List<Server.Builder> result = ServerListCopier.copyToBuilder(this.serverList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerList(Collection<Server.BuilderImpl> serverList) {
            this.serverList = ServerListCopier.copyFromBuilder(serverList);
        }

        @Override
        public final Builder serverList(Collection<Server> serverList) {
            this.serverList = ServerListCopier.copy(serverList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverList(Server... serverList) {
            serverList(Arrays.asList(serverList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverList(Consumer<Server.Builder>... serverList) {
            serverList(Stream.of(serverList).map(c -> Server.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServerGroup build() {
            return new ServerGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
