/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for validating an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerValidationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerValidationConfiguration.Builder, ServerValidationConfiguration> {
    private static final SdkField<Server> SERVER_FIELD = SdkField.<Server> builder(MarshallingType.SDK_POJO).memberName("server")
            .getter(getter(ServerValidationConfiguration::server)).setter(setter(Builder::server)).constructor(Server::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("server").build()).build();

    private static final SdkField<String> VALIDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("validationId").getter(getter(ServerValidationConfiguration::validationId))
            .setter(setter(Builder::validationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ServerValidationConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SERVER_VALIDATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverValidationStrategy")
            .getter(getter(ServerValidationConfiguration::serverValidationStrategyAsString))
            .setter(setter(Builder::serverValidationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverValidationStrategy").build())
            .build();

    private static final SdkField<UserDataValidationParameters> USER_DATA_VALIDATION_PARAMETERS_FIELD = SdkField
            .<UserDataValidationParameters> builder(MarshallingType.SDK_POJO)
            .memberName("userDataValidationParameters")
            .getter(getter(ServerValidationConfiguration::userDataValidationParameters))
            .setter(setter(Builder::userDataValidationParameters))
            .constructor(UserDataValidationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userDataValidationParameters")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_FIELD,
            VALIDATION_ID_FIELD, NAME_FIELD, SERVER_VALIDATION_STRATEGY_FIELD, USER_DATA_VALIDATION_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Server server;

    private final String validationId;

    private final String name;

    private final String serverValidationStrategy;

    private final UserDataValidationParameters userDataValidationParameters;

    private ServerValidationConfiguration(BuilderImpl builder) {
        this.server = builder.server;
        this.validationId = builder.validationId;
        this.name = builder.name;
        this.serverValidationStrategy = builder.serverValidationStrategy;
        this.userDataValidationParameters = builder.userDataValidationParameters;
    }

    /**
     * Returns the value of the Server property for this object.
     * 
     * @return The value of the Server property for this object.
     */
    public final Server server() {
        return server;
    }

    /**
     * <p>
     * The ID of the validation.
     * </p>
     * 
     * @return The ID of the validation.
     */
    public final String validationId() {
        return validationId;
    }

    /**
     * <p>
     * The name of the configuration.
     * </p>
     * 
     * @return The name of the configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The validation strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serverValidationStrategy} will return {@link ServerValidationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #serverValidationStrategyAsString}.
     * </p>
     * 
     * @return The validation strategy.
     * @see ServerValidationStrategy
     */
    public final ServerValidationStrategy serverValidationStrategy() {
        return ServerValidationStrategy.fromValue(serverValidationStrategy);
    }

    /**
     * <p>
     * The validation strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serverValidationStrategy} will return {@link ServerValidationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #serverValidationStrategyAsString}.
     * </p>
     * 
     * @return The validation strategy.
     * @see ServerValidationStrategy
     */
    public final String serverValidationStrategyAsString() {
        return serverValidationStrategy;
    }

    /**
     * <p>
     * The validation parameters.
     * </p>
     * 
     * @return The validation parameters.
     */
    public final UserDataValidationParameters userDataValidationParameters() {
        return userDataValidationParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(server());
        hashCode = 31 * hashCode + Objects.hashCode(validationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(serverValidationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userDataValidationParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerValidationConfiguration)) {
            return false;
        }
        ServerValidationConfiguration other = (ServerValidationConfiguration) obj;
        return Objects.equals(server(), other.server()) && Objects.equals(validationId(), other.validationId())
                && Objects.equals(name(), other.name())
                && Objects.equals(serverValidationStrategyAsString(), other.serverValidationStrategyAsString())
                && Objects.equals(userDataValidationParameters(), other.userDataValidationParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerValidationConfiguration").add("Server", server()).add("ValidationId", validationId())
                .add("Name", name()).add("ServerValidationStrategy", serverValidationStrategyAsString())
                .add("UserDataValidationParameters", userDataValidationParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "server":
            return Optional.ofNullable(clazz.cast(server()));
        case "validationId":
            return Optional.ofNullable(clazz.cast(validationId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "serverValidationStrategy":
            return Optional.ofNullable(clazz.cast(serverValidationStrategyAsString()));
        case "userDataValidationParameters":
            return Optional.ofNullable(clazz.cast(userDataValidationParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerValidationConfiguration, T> g) {
        return obj -> g.apply((ServerValidationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerValidationConfiguration> {
        /**
         * Sets the value of the Server property for this object.
         *
         * @param server
         *        The new value for the Server property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder server(Server server);

        /**
         * Sets the value of the Server property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Server.Builder} avoiding the need to
         * create one manually via {@link Server#builder()}.
         *
         * When the {@link Consumer} completes, {@link Server.Builder#build()} is called immediately and its result is
         * passed to {@link #server(Server)}.
         * 
         * @param server
         *        a consumer that will call methods on {@link Server.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #server(Server)
         */
        default Builder server(Consumer<Server.Builder> server) {
            return server(Server.builder().applyMutation(server).build());
        }

        /**
         * <p>
         * The ID of the validation.
         * </p>
         * 
         * @param validationId
         *        The ID of the validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationId(String validationId);

        /**
         * <p>
         * The name of the configuration.
         * </p>
         * 
         * @param name
         *        The name of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The validation strategy.
         * </p>
         * 
         * @param serverValidationStrategy
         *        The validation strategy.
         * @see ServerValidationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerValidationStrategy
         */
        Builder serverValidationStrategy(String serverValidationStrategy);

        /**
         * <p>
         * The validation strategy.
         * </p>
         * 
         * @param serverValidationStrategy
         *        The validation strategy.
         * @see ServerValidationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerValidationStrategy
         */
        Builder serverValidationStrategy(ServerValidationStrategy serverValidationStrategy);

        /**
         * <p>
         * The validation parameters.
         * </p>
         * 
         * @param userDataValidationParameters
         *        The validation parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDataValidationParameters(UserDataValidationParameters userDataValidationParameters);

        /**
         * <p>
         * The validation parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserDataValidationParameters.Builder}
         * avoiding the need to create one manually via {@link UserDataValidationParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserDataValidationParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #userDataValidationParameters(UserDataValidationParameters)}.
         * 
         * @param userDataValidationParameters
         *        a consumer that will call methods on {@link UserDataValidationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userDataValidationParameters(UserDataValidationParameters)
         */
        default Builder userDataValidationParameters(Consumer<UserDataValidationParameters.Builder> userDataValidationParameters) {
            return userDataValidationParameters(UserDataValidationParameters.builder()
                    .applyMutation(userDataValidationParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Server server;

        private String validationId;

        private String name;

        private String serverValidationStrategy;

        private UserDataValidationParameters userDataValidationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerValidationConfiguration model) {
            server(model.server);
            validationId(model.validationId);
            name(model.name);
            serverValidationStrategy(model.serverValidationStrategy);
            userDataValidationParameters(model.userDataValidationParameters);
        }

        public final Server.Builder getServer() {
            return server != null ? server.toBuilder() : null;
        }

        public final void setServer(Server.BuilderImpl server) {
            this.server = server != null ? server.build() : null;
        }

        @Override
        public final Builder server(Server server) {
            this.server = server;
            return this;
        }

        public final String getValidationId() {
            return validationId;
        }

        public final void setValidationId(String validationId) {
            this.validationId = validationId;
        }

        @Override
        public final Builder validationId(String validationId) {
            this.validationId = validationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getServerValidationStrategy() {
            return serverValidationStrategy;
        }

        public final void setServerValidationStrategy(String serverValidationStrategy) {
            this.serverValidationStrategy = serverValidationStrategy;
        }

        @Override
        public final Builder serverValidationStrategy(String serverValidationStrategy) {
            this.serverValidationStrategy = serverValidationStrategy;
            return this;
        }

        @Override
        public final Builder serverValidationStrategy(ServerValidationStrategy serverValidationStrategy) {
            this.serverValidationStrategy(serverValidationStrategy == null ? null : serverValidationStrategy.toString());
            return this;
        }

        public final UserDataValidationParameters.Builder getUserDataValidationParameters() {
            return userDataValidationParameters != null ? userDataValidationParameters.toBuilder() : null;
        }

        public final void setUserDataValidationParameters(UserDataValidationParameters.BuilderImpl userDataValidationParameters) {
            this.userDataValidationParameters = userDataValidationParameters != null ? userDataValidationParameters.build()
                    : null;
        }

        @Override
        public final Builder userDataValidationParameters(UserDataValidationParameters userDataValidationParameters) {
            this.userDataValidationParameters = userDataValidationParameters;
            return this;
        }

        @Override
        public ServerValidationConfiguration build() {
            return new ServerValidationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
