/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for validating an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppValidationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AppValidationConfiguration.Builder, AppValidationConfiguration> {
    private static final SdkField<String> VALIDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("validationId").getter(getter(AppValidationConfiguration::validationId))
            .setter(setter(Builder::validationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AppValidationConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> APP_VALIDATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appValidationStrategy").getter(getter(AppValidationConfiguration::appValidationStrategyAsString))
            .setter(setter(Builder::appValidationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appValidationStrategy").build())
            .build();

    private static final SdkField<SSMValidationParameters> SSM_VALIDATION_PARAMETERS_FIELD = SdkField
            .<SSMValidationParameters> builder(MarshallingType.SDK_POJO).memberName("ssmValidationParameters")
            .getter(getter(AppValidationConfiguration::ssmValidationParameters)).setter(setter(Builder::ssmValidationParameters))
            .constructor(SSMValidationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmValidationParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ID_FIELD,
            NAME_FIELD, APP_VALIDATION_STRATEGY_FIELD, SSM_VALIDATION_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String validationId;

    private final String name;

    private final String appValidationStrategy;

    private final SSMValidationParameters ssmValidationParameters;

    private AppValidationConfiguration(BuilderImpl builder) {
        this.validationId = builder.validationId;
        this.name = builder.name;
        this.appValidationStrategy = builder.appValidationStrategy;
        this.ssmValidationParameters = builder.ssmValidationParameters;
    }

    /**
     * <p>
     * The ID of the validation.
     * </p>
     * 
     * @return The ID of the validation.
     */
    public final String validationId() {
        return validationId;
    }

    /**
     * <p>
     * The name of the configuration.
     * </p>
     * 
     * @return The name of the configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The validation strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appValidationStrategy} will return {@link AppValidationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #appValidationStrategyAsString}.
     * </p>
     * 
     * @return The validation strategy.
     * @see AppValidationStrategy
     */
    public final AppValidationStrategy appValidationStrategy() {
        return AppValidationStrategy.fromValue(appValidationStrategy);
    }

    /**
     * <p>
     * The validation strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appValidationStrategy} will return {@link AppValidationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #appValidationStrategyAsString}.
     * </p>
     * 
     * @return The validation strategy.
     * @see AppValidationStrategy
     */
    public final String appValidationStrategyAsString() {
        return appValidationStrategy;
    }

    /**
     * <p>
     * The validation parameters.
     * </p>
     * 
     * @return The validation parameters.
     */
    public final SSMValidationParameters ssmValidationParameters() {
        return ssmValidationParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(validationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(appValidationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ssmValidationParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppValidationConfiguration)) {
            return false;
        }
        AppValidationConfiguration other = (AppValidationConfiguration) obj;
        return Objects.equals(validationId(), other.validationId()) && Objects.equals(name(), other.name())
                && Objects.equals(appValidationStrategyAsString(), other.appValidationStrategyAsString())
                && Objects.equals(ssmValidationParameters(), other.ssmValidationParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppValidationConfiguration").add("ValidationId", validationId()).add("Name", name())
                .add("AppValidationStrategy", appValidationStrategyAsString())
                .add("SsmValidationParameters", ssmValidationParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "validationId":
            return Optional.ofNullable(clazz.cast(validationId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "appValidationStrategy":
            return Optional.ofNullable(clazz.cast(appValidationStrategyAsString()));
        case "ssmValidationParameters":
            return Optional.ofNullable(clazz.cast(ssmValidationParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppValidationConfiguration, T> g) {
        return obj -> g.apply((AppValidationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppValidationConfiguration> {
        /**
         * <p>
         * The ID of the validation.
         * </p>
         * 
         * @param validationId
         *        The ID of the validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationId(String validationId);

        /**
         * <p>
         * The name of the configuration.
         * </p>
         * 
         * @param name
         *        The name of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The validation strategy.
         * </p>
         * 
         * @param appValidationStrategy
         *        The validation strategy.
         * @see AppValidationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppValidationStrategy
         */
        Builder appValidationStrategy(String appValidationStrategy);

        /**
         * <p>
         * The validation strategy.
         * </p>
         * 
         * @param appValidationStrategy
         *        The validation strategy.
         * @see AppValidationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppValidationStrategy
         */
        Builder appValidationStrategy(AppValidationStrategy appValidationStrategy);

        /**
         * <p>
         * The validation parameters.
         * </p>
         * 
         * @param ssmValidationParameters
         *        The validation parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmValidationParameters(SSMValidationParameters ssmValidationParameters);

        /**
         * <p>
         * The validation parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link SSMValidationParameters.Builder} avoiding
         * the need to create one manually via {@link SSMValidationParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SSMValidationParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #ssmValidationParameters(SSMValidationParameters)}.
         * 
         * @param ssmValidationParameters
         *        a consumer that will call methods on {@link SSMValidationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmValidationParameters(SSMValidationParameters)
         */
        default Builder ssmValidationParameters(Consumer<SSMValidationParameters.Builder> ssmValidationParameters) {
            return ssmValidationParameters(SSMValidationParameters.builder().applyMutation(ssmValidationParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String validationId;

        private String name;

        private String appValidationStrategy;

        private SSMValidationParameters ssmValidationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(AppValidationConfiguration model) {
            validationId(model.validationId);
            name(model.name);
            appValidationStrategy(model.appValidationStrategy);
            ssmValidationParameters(model.ssmValidationParameters);
        }

        public final String getValidationId() {
            return validationId;
        }

        public final void setValidationId(String validationId) {
            this.validationId = validationId;
        }

        @Override
        public final Builder validationId(String validationId) {
            this.validationId = validationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAppValidationStrategy() {
            return appValidationStrategy;
        }

        public final void setAppValidationStrategy(String appValidationStrategy) {
            this.appValidationStrategy = appValidationStrategy;
        }

        @Override
        public final Builder appValidationStrategy(String appValidationStrategy) {
            this.appValidationStrategy = appValidationStrategy;
            return this;
        }

        @Override
        public final Builder appValidationStrategy(AppValidationStrategy appValidationStrategy) {
            this.appValidationStrategy(appValidationStrategy == null ? null : appValidationStrategy.toString());
            return this;
        }

        public final SSMValidationParameters.Builder getSsmValidationParameters() {
            return ssmValidationParameters != null ? ssmValidationParameters.toBuilder() : null;
        }

        public final void setSsmValidationParameters(SSMValidationParameters.BuilderImpl ssmValidationParameters) {
            this.ssmValidationParameters = ssmValidationParameters != null ? ssmValidationParameters.build() : null;
        }

        @Override
        public final Builder ssmValidationParameters(SSMValidationParameters ssmValidationParameters) {
            this.ssmValidationParameters = ssmValidationParameters;
            return this;
        }

        @Override
        public AppValidationConfiguration build() {
            return new AppValidationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
