/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAppValidationConfigurationRequest extends SmsRequest implements
        ToCopyableBuilder<PutAppValidationConfigurationRequest.Builder, PutAppValidationConfigurationRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(PutAppValidationConfigurationRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<List<AppValidationConfiguration>> APP_VALIDATION_CONFIGURATIONS_FIELD = SdkField
            .<List<AppValidationConfiguration>> builder(MarshallingType.LIST)
            .memberName("appValidationConfigurations")
            .getter(getter(PutAppValidationConfigurationRequest::appValidationConfigurations))
            .setter(setter(Builder::appValidationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appValidationConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppValidationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppValidationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ServerGroupValidationConfiguration>> SERVER_GROUP_VALIDATION_CONFIGURATIONS_FIELD = SdkField
            .<List<ServerGroupValidationConfiguration>> builder(MarshallingType.LIST)
            .memberName("serverGroupValidationConfigurations")
            .getter(getter(PutAppValidationConfigurationRequest::serverGroupValidationConfigurations))
            .setter(setter(Builder::serverGroupValidationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("serverGroupValidationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerGroupValidationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerGroupValidationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            APP_VALIDATION_CONFIGURATIONS_FIELD, SERVER_GROUP_VALIDATION_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appId;

    private final List<AppValidationConfiguration> appValidationConfigurations;

    private final List<ServerGroupValidationConfiguration> serverGroupValidationConfigurations;

    private PutAppValidationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.appValidationConfigurations = builder.appValidationConfigurations;
        this.serverGroupValidationConfigurations = builder.serverGroupValidationConfigurations;
    }

    /**
     * <p>
     * The ID of the application.
     * </p>
     * 
     * @return The ID of the application.
     */
    public final String appId() {
        return appId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppValidationConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAppValidationConfigurations() {
        return appValidationConfigurations != null && !(appValidationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration for application validation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppValidationConfigurations} method.
     * </p>
     * 
     * @return The configuration for application validation.
     */
    public final List<AppValidationConfiguration> appValidationConfigurations() {
        return appValidationConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerGroupValidationConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasServerGroupValidationConfigurations() {
        return serverGroupValidationConfigurations != null
                && !(serverGroupValidationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration for instance validation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerGroupValidationConfigurations}
     * method.
     * </p>
     * 
     * @return The configuration for instance validation.
     */
    public final List<ServerGroupValidationConfiguration> serverGroupValidationConfigurations() {
        return serverGroupValidationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppValidationConfigurations() ? appValidationConfigurations() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasServerGroupValidationConfigurations() ? serverGroupValidationConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAppValidationConfigurationRequest)) {
            return false;
        }
        PutAppValidationConfigurationRequest other = (PutAppValidationConfigurationRequest) obj;
        return Objects.equals(appId(), other.appId())
                && hasAppValidationConfigurations() == other.hasAppValidationConfigurations()
                && Objects.equals(appValidationConfigurations(), other.appValidationConfigurations())
                && hasServerGroupValidationConfigurations() == other.hasServerGroupValidationConfigurations()
                && Objects.equals(serverGroupValidationConfigurations(), other.serverGroupValidationConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PutAppValidationConfigurationRequest")
                .add("AppId", appId())
                .add("AppValidationConfigurations", hasAppValidationConfigurations() ? appValidationConfigurations() : null)
                .add("ServerGroupValidationConfigurations",
                        hasServerGroupValidationConfigurations() ? serverGroupValidationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "appValidationConfigurations":
            return Optional.ofNullable(clazz.cast(appValidationConfigurations()));
        case "serverGroupValidationConfigurations":
            return Optional.ofNullable(clazz.cast(serverGroupValidationConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appId", APP_ID_FIELD);
        map.put("appValidationConfigurations", APP_VALIDATION_CONFIGURATIONS_FIELD);
        map.put("serverGroupValidationConfigurations", SERVER_GROUP_VALIDATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAppValidationConfigurationRequest, T> g) {
        return obj -> g.apply((PutAppValidationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAppValidationConfigurationRequest> {
        /**
         * <p>
         * The ID of the application.
         * </p>
         * 
         * @param appId
         *        The ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The configuration for application validation.
         * </p>
         * 
         * @param appValidationConfigurations
         *        The configuration for application validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appValidationConfigurations(Collection<AppValidationConfiguration> appValidationConfigurations);

        /**
         * <p>
         * The configuration for application validation.
         * </p>
         * 
         * @param appValidationConfigurations
         *        The configuration for application validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appValidationConfigurations(AppValidationConfiguration... appValidationConfigurations);

        /**
         * <p>
         * The configuration for application validation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sms.model.AppValidationConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sms.model.AppValidationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sms.model.AppValidationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #appValidationConfigurations(List<AppValidationConfiguration>)}.
         * 
         * @param appValidationConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sms.model.AppValidationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appValidationConfigurations(java.util.Collection<AppValidationConfiguration>)
         */
        Builder appValidationConfigurations(Consumer<AppValidationConfiguration.Builder>... appValidationConfigurations);

        /**
         * <p>
         * The configuration for instance validation.
         * </p>
         * 
         * @param serverGroupValidationConfigurations
         *        The configuration for instance validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupValidationConfigurations(
                Collection<ServerGroupValidationConfiguration> serverGroupValidationConfigurations);

        /**
         * <p>
         * The configuration for instance validation.
         * </p>
         * 
         * @param serverGroupValidationConfigurations
         *        The configuration for instance validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupValidationConfigurations(ServerGroupValidationConfiguration... serverGroupValidationConfigurations);

        /**
         * <p>
         * The configuration for instance validation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sms.model.ServerGroupValidationConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sms.model.ServerGroupValidationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sms.model.ServerGroupValidationConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #serverGroupValidationConfigurations(List<ServerGroupValidationConfiguration>)}.
         * 
         * @param serverGroupValidationConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sms.model.ServerGroupValidationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverGroupValidationConfigurations(java.util.Collection<ServerGroupValidationConfiguration>)
         */
        Builder serverGroupValidationConfigurations(
                Consumer<ServerGroupValidationConfiguration.Builder>... serverGroupValidationConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SmsRequest.BuilderImpl implements Builder {
        private String appId;

        private List<AppValidationConfiguration> appValidationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<ServerGroupValidationConfiguration> serverGroupValidationConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAppValidationConfigurationRequest model) {
            super(model);
            appId(model.appId);
            appValidationConfigurations(model.appValidationConfigurations);
            serverGroupValidationConfigurations(model.serverGroupValidationConfigurations);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final List<AppValidationConfiguration.Builder> getAppValidationConfigurations() {
            List<AppValidationConfiguration.Builder> result = AppValidationConfigurationsCopier
                    .copyToBuilder(this.appValidationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppValidationConfigurations(
                Collection<AppValidationConfiguration.BuilderImpl> appValidationConfigurations) {
            this.appValidationConfigurations = AppValidationConfigurationsCopier.copyFromBuilder(appValidationConfigurations);
        }

        @Override
        public final Builder appValidationConfigurations(Collection<AppValidationConfiguration> appValidationConfigurations) {
            this.appValidationConfigurations = AppValidationConfigurationsCopier.copy(appValidationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appValidationConfigurations(AppValidationConfiguration... appValidationConfigurations) {
            appValidationConfigurations(Arrays.asList(appValidationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appValidationConfigurations(
                Consumer<AppValidationConfiguration.Builder>... appValidationConfigurations) {
            appValidationConfigurations(Stream.of(appValidationConfigurations)
                    .map(c -> AppValidationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServerGroupValidationConfiguration.Builder> getServerGroupValidationConfigurations() {
            List<ServerGroupValidationConfiguration.Builder> result = ServerGroupValidationConfigurationsCopier
                    .copyToBuilder(this.serverGroupValidationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerGroupValidationConfigurations(
                Collection<ServerGroupValidationConfiguration.BuilderImpl> serverGroupValidationConfigurations) {
            this.serverGroupValidationConfigurations = ServerGroupValidationConfigurationsCopier
                    .copyFromBuilder(serverGroupValidationConfigurations);
        }

        @Override
        public final Builder serverGroupValidationConfigurations(
                Collection<ServerGroupValidationConfiguration> serverGroupValidationConfigurations) {
            this.serverGroupValidationConfigurations = ServerGroupValidationConfigurationsCopier
                    .copy(serverGroupValidationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupValidationConfigurations(
                ServerGroupValidationConfiguration... serverGroupValidationConfigurations) {
            serverGroupValidationConfigurations(Arrays.asList(serverGroupValidationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupValidationConfigurations(
                Consumer<ServerGroupValidationConfiguration.Builder>... serverGroupValidationConfigurations) {
            serverGroupValidationConfigurations(Stream.of(serverGroupValidationConfigurations)
                    .map(c -> ServerGroupValidationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAppValidationConfigurationRequest build() {
            return new PutAppValidationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
