/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.sms.SmsAsyncClient;
import software.amazon.awssdk.services.sms.SmsServiceClientConfiguration;
import software.amazon.awssdk.services.sms.internal.SmsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.sms.model.CreateAppRequest;
import software.amazon.awssdk.services.sms.model.CreateAppResponse;
import software.amazon.awssdk.services.sms.model.CreateReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.CreateReplicationJobResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppLaunchConfigurationRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppLaunchConfigurationResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppReplicationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppReplicationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppValidationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppValidationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.DeleteReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.DeleteReplicationJobResponse;
import software.amazon.awssdk.services.sms.model.DeleteServerCatalogRequest;
import software.amazon.awssdk.services.sms.model.DeleteServerCatalogResponse;
import software.amazon.awssdk.services.sms.model.DisassociateConnectorRequest;
import software.amazon.awssdk.services.sms.model.DisassociateConnectorResponse;
import software.amazon.awssdk.services.sms.model.DryRunOperationException;
import software.amazon.awssdk.services.sms.model.GenerateChangeSetRequest;
import software.amazon.awssdk.services.sms.model.GenerateChangeSetResponse;
import software.amazon.awssdk.services.sms.model.GenerateTemplateRequest;
import software.amazon.awssdk.services.sms.model.GenerateTemplateResponse;
import software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationRequest;
import software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationResponse;
import software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.GetAppRequest;
import software.amazon.awssdk.services.sms.model.GetAppResponse;
import software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.GetAppValidationOutputRequest;
import software.amazon.awssdk.services.sms.model.GetAppValidationOutputResponse;
import software.amazon.awssdk.services.sms.model.GetConnectorsRequest;
import software.amazon.awssdk.services.sms.model.GetConnectorsResponse;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse;
import software.amazon.awssdk.services.sms.model.GetServersRequest;
import software.amazon.awssdk.services.sms.model.GetServersResponse;
import software.amazon.awssdk.services.sms.model.ImportAppCatalogRequest;
import software.amazon.awssdk.services.sms.model.ImportAppCatalogResponse;
import software.amazon.awssdk.services.sms.model.ImportServerCatalogRequest;
import software.amazon.awssdk.services.sms.model.ImportServerCatalogResponse;
import software.amazon.awssdk.services.sms.model.InternalErrorException;
import software.amazon.awssdk.services.sms.model.InvalidParameterException;
import software.amazon.awssdk.services.sms.model.LaunchAppRequest;
import software.amazon.awssdk.services.sms.model.LaunchAppResponse;
import software.amazon.awssdk.services.sms.model.ListAppsRequest;
import software.amazon.awssdk.services.sms.model.ListAppsResponse;
import software.amazon.awssdk.services.sms.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.sms.model.NoConnectorsAvailableException;
import software.amazon.awssdk.services.sms.model.NotifyAppValidationOutputRequest;
import software.amazon.awssdk.services.sms.model.NotifyAppValidationOutputResponse;
import software.amazon.awssdk.services.sms.model.OperationNotPermittedException;
import software.amazon.awssdk.services.sms.model.PutAppLaunchConfigurationRequest;
import software.amazon.awssdk.services.sms.model.PutAppLaunchConfigurationResponse;
import software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.PutAppValidationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.PutAppValidationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.ReplicationJobAlreadyExistsException;
import software.amazon.awssdk.services.sms.model.ReplicationJobNotFoundException;
import software.amazon.awssdk.services.sms.model.ReplicationRunLimitExceededException;
import software.amazon.awssdk.services.sms.model.ServerCannotBeReplicatedException;
import software.amazon.awssdk.services.sms.model.SmsException;
import software.amazon.awssdk.services.sms.model.StartAppReplicationRequest;
import software.amazon.awssdk.services.sms.model.StartAppReplicationResponse;
import software.amazon.awssdk.services.sms.model.StartOnDemandAppReplicationRequest;
import software.amazon.awssdk.services.sms.model.StartOnDemandAppReplicationResponse;
import software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunRequest;
import software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunResponse;
import software.amazon.awssdk.services.sms.model.StopAppReplicationRequest;
import software.amazon.awssdk.services.sms.model.StopAppReplicationResponse;
import software.amazon.awssdk.services.sms.model.TemporarilyUnavailableException;
import software.amazon.awssdk.services.sms.model.TerminateAppRequest;
import software.amazon.awssdk.services.sms.model.TerminateAppResponse;
import software.amazon.awssdk.services.sms.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.sms.model.UpdateAppRequest;
import software.amazon.awssdk.services.sms.model.UpdateAppResponse;
import software.amazon.awssdk.services.sms.model.UpdateReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.UpdateReplicationJobResponse;
import software.amazon.awssdk.services.sms.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.CreateReplicationJobRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteAppLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteAppReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteAppValidationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteReplicationJobRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DeleteServerCatalogRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.DisassociateConnectorRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GenerateChangeSetRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GenerateTemplateRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppValidationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetAppValidationOutputRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetConnectorsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetReplicationJobsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetReplicationRunsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.GetServersRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.ImportAppCatalogRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.ImportServerCatalogRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.LaunchAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.ListAppsRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.NotifyAppValidationOutputRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.PutAppLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.PutAppReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.PutAppValidationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StartAppReplicationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StartOnDemandAppReplicationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StartOnDemandReplicationRunRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.StopAppReplicationRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.TerminateAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.UpdateAppRequestMarshaller;
import software.amazon.awssdk.services.sms.transform.UpdateReplicationJobRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultSmsAsyncClient
implements SmsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSmsAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSmsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"SMS#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateAppResponse> createApp(CreateAppRequest createAppRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, createAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAppResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAppRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$createApp$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$createApp$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateReplicationJobResponse> createReplicationJob(CreateReplicationJobRequest createReplicationJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createReplicationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, createReplicationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateReplicationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createReplicationJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$createReplicationJob$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$createReplicationJob$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAppResponse> deleteApp(DeleteAppRequest deleteAppRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAppRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$deleteApp$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$deleteApp$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAppLaunchConfigurationResponse> deleteAppLaunchConfiguration(DeleteAppLaunchConfigurationRequest deleteAppLaunchConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAppLaunchConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAppLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAppLaunchConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppLaunchConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAppLaunchConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAppLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAppLaunchConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$deleteAppLaunchConfiguration$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$deleteAppLaunchConfiguration$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAppReplicationConfigurationResponse> deleteAppReplicationConfiguration(DeleteAppReplicationConfigurationRequest deleteAppReplicationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAppReplicationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAppReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAppReplicationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppReplicationConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAppReplicationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAppReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAppReplicationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$deleteAppReplicationConfiguration$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$deleteAppReplicationConfiguration$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAppValidationConfigurationResponse> deleteAppValidationConfiguration(DeleteAppValidationConfigurationRequest deleteAppValidationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAppValidationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAppValidationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAppValidationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppValidationConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAppValidationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAppValidationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAppValidationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$deleteAppValidationConfiguration$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$deleteAppValidationConfiguration$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteReplicationJobResponse> deleteReplicationJob(DeleteReplicationJobRequest deleteReplicationJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteReplicationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteReplicationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteReplicationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteReplicationJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$deleteReplicationJob$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$deleteReplicationJob$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteServerCatalogResponse> deleteServerCatalog(DeleteServerCatalogRequest deleteServerCatalogRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServerCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteServerCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServerCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServerCatalogResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServerCatalog").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteServerCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteServerCatalogRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$deleteServerCatalog$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$deleteServerCatalog$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateConnectorResponse> disassociateConnector(DisassociateConnectorRequest disassociateConnectorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateConnectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, disassociateConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateConnectorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateConnector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisassociateConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateConnectorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$disassociateConnector$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$disassociateConnector$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GenerateChangeSetResponse> generateChangeSet(GenerateChangeSetRequest generateChangeSetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateChangeSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, generateChangeSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateChangeSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateChangeSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateChangeSet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GenerateChangeSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)generateChangeSetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$generateChangeSet$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$generateChangeSet$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GenerateTemplateResponse> generateTemplate(GenerateTemplateRequest generateTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, generateTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GenerateTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)generateTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$generateTemplate$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$generateTemplate$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAppResponse> getApp(GetAppRequest getAppRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, getAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAppRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$getApp$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$getApp$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAppLaunchConfigurationResponse> getAppLaunchConfiguration(GetAppLaunchConfigurationRequest getAppLaunchConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppLaunchConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, getAppLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppLaunchConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppLaunchConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppLaunchConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAppLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAppLaunchConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$getAppLaunchConfiguration$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$getAppLaunchConfiguration$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAppReplicationConfigurationResponse> getAppReplicationConfiguration(GetAppReplicationConfigurationRequest getAppReplicationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppReplicationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, getAppReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppReplicationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppReplicationConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppReplicationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAppReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAppReplicationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$getAppReplicationConfiguration$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$getAppReplicationConfiguration$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAppValidationConfigurationResponse> getAppValidationConfiguration(GetAppValidationConfigurationRequest getAppValidationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppValidationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, getAppValidationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppValidationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppValidationConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppValidationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAppValidationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAppValidationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$getAppValidationConfiguration$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$getAppValidationConfiguration$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAppValidationOutputResponse> getAppValidationOutput(GetAppValidationOutputRequest getAppValidationOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppValidationOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, getAppValidationOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppValidationOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppValidationOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppValidationOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAppValidationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAppValidationOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$getAppValidationOutput$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$getAppValidationOutput$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetConnectorsResponse> getConnectors(GetConnectorsRequest getConnectorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getConnectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, getConnectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConnectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConnectorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConnectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetConnectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getConnectorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$getConnectors$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$getConnectors$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReplicationJobsResponse> getReplicationJobs(GetReplicationJobsRequest getReplicationJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReplicationJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, getReplicationJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReplicationJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReplicationJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReplicationJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetReplicationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getReplicationJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$getReplicationJobs$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$getReplicationJobs$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReplicationRunsResponse> getReplicationRuns(GetReplicationRunsRequest getReplicationRunsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReplicationRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, getReplicationRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReplicationRuns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReplicationRunsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReplicationRuns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetReplicationRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getReplicationRunsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$getReplicationRuns$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$getReplicationRuns$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetServersResponse> getServers(GetServersRequest getServersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, getServersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getServersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$getServers$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$getServers$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportAppCatalogResponse> importAppCatalog(ImportAppCatalogRequest importAppCatalogRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importAppCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, importAppCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportAppCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportAppCatalogResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportAppCatalog").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ImportAppCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importAppCatalogRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$importAppCatalog$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$importAppCatalog$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportServerCatalogResponse> importServerCatalog(ImportServerCatalogRequest importServerCatalogRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importServerCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, importServerCatalogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportServerCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportServerCatalogResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportServerCatalog").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ImportServerCatalogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importServerCatalogRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$importServerCatalog$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$importServerCatalog$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<LaunchAppResponse> launchApp(LaunchAppRequest launchAppRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)launchAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, launchAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"LaunchApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LaunchAppResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("LaunchApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new LaunchAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)launchAppRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$launchApp$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$launchApp$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAppsResponse> listApps(ListAppsRequest listAppsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAppsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, listAppsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAppsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApps").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAppsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAppsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$listApps$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$listApps$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<NotifyAppValidationOutputResponse> notifyAppValidationOutput(NotifyAppValidationOutputRequest notifyAppValidationOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)notifyAppValidationOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, notifyAppValidationOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"NotifyAppValidationOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyAppValidationOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyAppValidationOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new NotifyAppValidationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)notifyAppValidationOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$notifyAppValidationOutput$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$notifyAppValidationOutput$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAppLaunchConfigurationResponse> putAppLaunchConfiguration(PutAppLaunchConfigurationRequest putAppLaunchConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAppLaunchConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, putAppLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAppLaunchConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAppLaunchConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAppLaunchConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutAppLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAppLaunchConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$putAppLaunchConfiguration$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$putAppLaunchConfiguration$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAppReplicationConfigurationResponse> putAppReplicationConfiguration(PutAppReplicationConfigurationRequest putAppReplicationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAppReplicationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, putAppReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAppReplicationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAppReplicationConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAppReplicationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutAppReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAppReplicationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$putAppReplicationConfiguration$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$putAppReplicationConfiguration$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAppValidationConfigurationResponse> putAppValidationConfiguration(PutAppValidationConfigurationRequest putAppValidationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAppValidationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, putAppValidationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAppValidationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAppValidationConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAppValidationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutAppValidationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAppValidationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$putAppValidationConfiguration$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$putAppValidationConfiguration$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartAppReplicationResponse> startAppReplication(StartAppReplicationRequest startAppReplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startAppReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, startAppReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartAppReplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartAppReplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartAppReplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartAppReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startAppReplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$startAppReplication$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$startAppReplication$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartOnDemandAppReplicationResponse> startOnDemandAppReplication(StartOnDemandAppReplicationRequest startOnDemandAppReplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startOnDemandAppReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, startOnDemandAppReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartOnDemandAppReplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartOnDemandAppReplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartOnDemandAppReplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartOnDemandAppReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startOnDemandAppReplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$startOnDemandAppReplication$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$startOnDemandAppReplication$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartOnDemandReplicationRunResponse> startOnDemandReplicationRun(StartOnDemandReplicationRunRequest startOnDemandReplicationRunRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startOnDemandReplicationRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, startOnDemandReplicationRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartOnDemandReplicationRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartOnDemandReplicationRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartOnDemandReplicationRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartOnDemandReplicationRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startOnDemandReplicationRunRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$startOnDemandReplicationRun$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$startOnDemandReplicationRun$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopAppReplicationResponse> stopAppReplication(StopAppReplicationRequest stopAppReplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopAppReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, stopAppReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopAppReplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopAppReplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopAppReplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopAppReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopAppReplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$stopAppReplication$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$stopAppReplication$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TerminateAppResponse> terminateApp(TerminateAppRequest terminateAppRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)terminateAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, terminateAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateAppResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TerminateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)terminateAppRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$terminateApp$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$terminateApp$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAppResponse> updateApp(UpdateAppRequest updateAppRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, updateAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAppResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApp").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAppRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$updateApp$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$updateApp$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateReplicationJobResponse> updateReplicationJob(UpdateReplicationJobRequest updateReplicationJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateReplicationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSmsAsyncClient.resolveMetricPublishers(clientConfiguration, updateReplicationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReplicationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateReplicationJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "TemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemporarilyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(TemporarilyUnavailableException::builder).build());
                    }
                    case "MissingRequiredParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                    }
                    case "ReplicationJobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobNotFoundException::builder).build());
                    }
                    case "OperationNotPermittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                    }
                    case "InternalError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "ServerCannotBeReplicatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServerCannotBeReplicatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServerCannotBeReplicatedException::builder).build());
                    }
                    case "ReplicationRunLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationRunLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationRunLimitExceededException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "ReplicationJobAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationJobAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationJobAlreadyExistsException::builder).build());
                    }
                    case "NoConnectorsAvailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoConnectorsAvailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoConnectorsAvailableException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReplicationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateReplicationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateReplicationJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSmsAsyncClient.lambda$updateReplicationJob$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSmsAsyncClient.lambda$updateReplicationJob$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final SmsServiceClientConfiguration serviceClientConfiguration() {
        return new SmsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "sms";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SmsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SmsServiceClientConfigurationBuilder serviceConfigBuilder = new SmsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateReplicationJob$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateReplicationJob$138(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateReplicationJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateApp$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApp$134(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAppResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$terminateApp$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$terminateApp$130(List metricPublishers, MetricCollector apiCallMetricCollector, TerminateAppResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopAppReplication$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopAppReplication$126(List metricPublishers, MetricCollector apiCallMetricCollector, StopAppReplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startOnDemandReplicationRun$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startOnDemandReplicationRun$122(List metricPublishers, MetricCollector apiCallMetricCollector, StartOnDemandReplicationRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startOnDemandAppReplication$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startOnDemandAppReplication$118(List metricPublishers, MetricCollector apiCallMetricCollector, StartOnDemandAppReplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startAppReplication$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startAppReplication$114(List metricPublishers, MetricCollector apiCallMetricCollector, StartAppReplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAppValidationConfiguration$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAppValidationConfiguration$110(List metricPublishers, MetricCollector apiCallMetricCollector, PutAppValidationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAppReplicationConfiguration$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAppReplicationConfiguration$106(List metricPublishers, MetricCollector apiCallMetricCollector, PutAppReplicationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAppLaunchConfiguration$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAppLaunchConfiguration$102(List metricPublishers, MetricCollector apiCallMetricCollector, PutAppLaunchConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$notifyAppValidationOutput$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$notifyAppValidationOutput$98(List metricPublishers, MetricCollector apiCallMetricCollector, NotifyAppValidationOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listApps$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApps$94(List metricPublishers, MetricCollector apiCallMetricCollector, ListAppsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$launchApp$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$launchApp$90(List metricPublishers, MetricCollector apiCallMetricCollector, LaunchAppResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importServerCatalog$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importServerCatalog$86(List metricPublishers, MetricCollector apiCallMetricCollector, ImportServerCatalogResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importAppCatalog$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importAppCatalog$82(List metricPublishers, MetricCollector apiCallMetricCollector, ImportAppCatalogResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getServers$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServers$78(List metricPublishers, MetricCollector apiCallMetricCollector, GetServersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getReplicationRuns$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReplicationRuns$74(List metricPublishers, MetricCollector apiCallMetricCollector, GetReplicationRunsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getReplicationJobs$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReplicationJobs$70(List metricPublishers, MetricCollector apiCallMetricCollector, GetReplicationJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getConnectors$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConnectors$66(List metricPublishers, MetricCollector apiCallMetricCollector, GetConnectorsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAppValidationOutput$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppValidationOutput$62(List metricPublishers, MetricCollector apiCallMetricCollector, GetAppValidationOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAppValidationConfiguration$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppValidationConfiguration$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetAppValidationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAppReplicationConfiguration$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppReplicationConfiguration$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetAppReplicationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAppLaunchConfiguration$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppLaunchConfiguration$50(List metricPublishers, MetricCollector apiCallMetricCollector, GetAppLaunchConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getApp$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApp$46(List metricPublishers, MetricCollector apiCallMetricCollector, GetAppResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$generateTemplate$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateTemplate$42(List metricPublishers, MetricCollector apiCallMetricCollector, GenerateTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$generateChangeSet$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateChangeSet$38(List metricPublishers, MetricCollector apiCallMetricCollector, GenerateChangeSetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateConnector$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateConnector$34(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateConnectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteServerCatalog$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServerCatalog$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteServerCatalogResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteReplicationJob$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReplicationJob$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteReplicationJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAppValidationConfiguration$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAppValidationConfiguration$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAppValidationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAppReplicationConfiguration$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAppReplicationConfiguration$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAppReplicationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAppLaunchConfiguration$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAppLaunchConfiguration$14(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAppLaunchConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApp$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApp$10(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAppResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createReplicationJob$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReplicationJob$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateReplicationJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createApp$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApp$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAppResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

